/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementRemove {
    private static final Log LOG = LogFactory.getLog(SQLStatementRemove.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private String _statement;

    public SQLStatementRemove(SQLEngine engine, PersistenceFactory factory) {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName();
        this.buildStatement();
    }

    private void buildStatement() {
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(this._factory.quoteName(this._mapTo));
        sql.append(" WHERE ");
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this._factory.quoteName(ids[i].getName()));
            sql.append("=");
            sql.append("?");
        }
        this._statement = sql.toString();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)this._statement));
        }
    }

    /*
     * Loose catch block
     */
    public Object executeStatement(Connection conn, Identity identity) throws PersistenceException {
        block15: {
            PreparedStatement stmt;
            block14: {
                int result;
                SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
                SQLEngine extended = this._engine.getExtends();
                stmt = null;
                stmt = conn.prepareStatement(this._statement);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)stmt.toString()));
                }
                int count = 1;
                if (identity.size() != ids.length) {
                    throw new PersistenceException("Size of identity field mismatched!");
                }
                for (int i = 0; i < ids.length; ++i) {
                    stmt.setObject(count++, ids[i].toSQL(identity.get(i)));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)stmt.toString()));
                }
                if ((result = stmt.executeUpdate()) < 1) {
                    throw new PersistenceException("Object to be deleted does not exist! " + identity);
                }
                if (extended == null) break block14;
                extended.delete(conn, identity);
            }
            Object var9_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block15;
            }
            catch (Exception e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block15;
            {
                catch (SQLException except) {
                    LOG.fatal((Object)Messages.format((String)"jdo.deleteFatal", (Object)this._type, (Object)this._statement), (Throwable)except);
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
        return null;
    }
}

