/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementStore {
    private static final Log LOG = LogFactory.getLog(SQLStatementStore.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private boolean _hasFieldsToPersist = false;
    private String _statementLazy;
    private String _statementDirty;
    private String _statementLoad;

    public SQLStatementStore(SQLEngine engine, PersistenceFactory factory, String load) {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName();
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            this._hasFieldsToPersist = true;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("hasFieldsToPersist = " + this._hasFieldsToPersist));
        }
        this.buildStatement();
        this._statementLoad = load;
    }

    private void buildStatement() {
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this._factory.quoteName(this._mapTo));
        if (this._hasFieldsToPersist) {
            int i;
            sql.append(" SET ");
            int count = 0;
            SQLFieldInfo[] fields = this._engine.getInfo();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                if (!fields[i2].isStore()) continue;
                SQLColumnInfo[] columns = fields[i2].getColumnInfo();
                for (int j = 0; j < columns.length; ++j) {
                    if (count > 0) {
                        sql.append(',');
                    }
                    sql.append(this._factory.quoteName(columns[j].getName()));
                    sql.append("=?");
                    ++count;
                }
            }
            sql.append(" WHERE ");
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            for (i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(ids[i].getName()));
                sql.append("=");
                sql.append("?");
            }
            this._statementLazy = sql.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.updating", (Object)this._type, (Object)this._statementLazy));
            }
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].isStore() || !fields[i].isDirtyCheck()) continue;
                SQLColumnInfo[] columns = fields[i].getColumnInfo();
                for (int j = 0; j < columns.length; ++j) {
                    sql.append(" AND ");
                    sql.append(this._factory.quoteName(columns[j].getName()));
                    sql.append("=?");
                }
            }
            this._statementDirty = sql.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.updating", (Object)this._type, (Object)this._statementDirty));
            }
        }
    }

    /*
     * Loose catch block
     */
    public Object executeStatement(Connection conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        block38: {
            ClassDescriptor extDesc;
            PreparedStatement stmt = null;
            String storeStatement = null;
            SQLEngine extended = this._engine.getExtends();
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                extended.store(conn, identity, newentity, oldentity);
            }
            if (this._hasFieldsToPersist) {
                int i;
                storeStatement = this.getStoreStatement(oldentity);
                stmt = conn.prepareStatement(storeStatement);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)stmt.toString()));
                }
                int count = 1;
                SQLFieldInfo[] fields = this._engine.getInfo();
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    if (!fields[i2].isStore()) continue;
                    SQLColumnInfo[] columns = fields[i2].getColumnInfo();
                    Object value = newentity.getField(i2);
                    if (value == null) {
                        for (int j = 0; j < columns.length; ++j) {
                            stmt.setNull(count++, columns[j].getSqlType());
                        }
                        continue;
                    }
                    if (value instanceof Identity) {
                        Identity id = (Identity)value;
                        if (id.size() != columns.length) {
                            throw new PersistenceException("Size of identity field mismatch!");
                        }
                        for (int j = 0; j < columns.length; ++j) {
                            SQLTypeInfos.setValue(stmt, count++, columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                        }
                        continue;
                    }
                    if (columns.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    SQLTypeInfos.setValue(stmt, count++, columns[0].toSQL(value), columns[0].getSqlType());
                }
                SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
                if (identity.size() != ids.length) {
                    throw new PersistenceException("Size of identity field mismatched!");
                }
                for (i = 0; i < ids.length; ++i) {
                    stmt.setObject(count++, ids[i].toSQL(identity.get(i)));
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)ids[i].getName(), (Object)ids[i].toSQL(identity.get(i))));
                }
                if (oldentity.getFields() != null) {
                    boolean supportsSetNull = this._factory.supportsSetNullInWhere();
                    for (int i3 = 0; i3 < fields.length; ++i3) {
                        if (!fields[i3].isStore() || !fields[i3].isDirtyCheck()) continue;
                        SQLColumnInfo[] columns = fields[i3].getColumnInfo();
                        Object value = oldentity.getField(i3);
                        if (value == null) {
                            if (!supportsSetNull) continue;
                            for (int j = 0; j < columns.length; ++j) {
                                stmt.setNull(count++, columns[j].getSqlType());
                            }
                            continue;
                        }
                        if (value instanceof Identity) {
                            Identity id = (Identity)value;
                            if (id.size() != columns.length) {
                                throw new PersistenceException("Size of identity field mismatch!");
                            }
                            for (int j = 0; j < columns.length; ++j) {
                                SQLTypeInfos.setValue(stmt, count++, columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                                if (!LOG.isTraceEnabled()) continue;
                                LOG.trace((Object)Messages.format((String)"jdo.bindingField", (Object)columns[j].getName(), (Object)columns[j].toSQL(id.get(j))));
                            }
                            continue;
                        }
                        if (columns.length != 1) {
                            throw new PersistenceException("Complex field expected!");
                        }
                        SQLTypeInfos.setValue(stmt, count++, columns[0].toSQL(value), columns[0].getSqlType());
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)Messages.format((String)"jdo.bindingField", (Object)columns[0].getName(), (Object)columns[0].toSQL(value)));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)stmt.toString()));
                }
                if (stmt.executeUpdate() <= 0) {
                    stmt.close();
                    if (oldentity.getFields() != null) {
                        stmt = conn.prepareStatement(this._statementLoad);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)stmt.toString()));
                        }
                        count = 1;
                        for (i = 0; i < ids.length; ++i) {
                            stmt.setObject(count++, ids[i].toSQL(identity.get(i)));
                        }
                        ResultSet res = stmt.executeQuery();
                        if (res.next()) {
                            StringBuffer enlistFieldsNotMatching = new StringBuffer();
                            int numberOfFieldsNotMatching = 0;
                            for (int i4 = 0; i4 < fields.length; ++i4) {
                                SQLColumnInfo[] columns = fields[i4].getColumnInfo();
                                Object value = oldentity.getField(i4);
                                Object currentField = columns[0].toJava(res.getObject(columns[0].getName()));
                                if (fields[i4].getTableName().compareTo(this._mapTo) != 0) continue;
                                if (value == null || value != null && currentField == null) {
                                    enlistFieldsNotMatching.append("(" + this._type + ")." + columns[0].getName() + ": ");
                                    enlistFieldsNotMatching.append("[" + value + "/" + currentField + "]");
                                    continue;
                                }
                                if (value.equals(currentField)) continue;
                                if (numberOfFieldsNotMatching >= 1) {
                                    enlistFieldsNotMatching.append(", ");
                                }
                                enlistFieldsNotMatching.append("(" + this._type + ")." + columns[0].getName() + ": ");
                                enlistFieldsNotMatching.append("[" + value + "/" + currentField + "]");
                                ++numberOfFieldsNotMatching;
                            }
                            throw new ObjectModifiedException(Messages.format((String)"persist.objectModified", (Object)this._type, (Object)identity, (Object)enlistFieldsNotMatching.toString()));
                        }
                    }
                    throw new ObjectDeletedException(Messages.format((String)"persist.objectDeleted", (Object)this._type, (Object)identity));
                }
                Object var19_34 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block38;
                }
                catch (SQLException except2) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
                }
                break block38;
                {
                    catch (SQLException except) {
                        LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)storeStatement), (Throwable)except);
                        throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_35 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException except2) {
                        LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    private String getStoreStatement(ProposedEntity oldentity) throws PersistenceException {
        if (oldentity.getFields() == null) {
            return this._statementLazy;
        }
        if (this._factory.supportsSetNullInWhere()) {
            return this._statementDirty;
        }
        int pos = this._statementDirty.length() - 1;
        StringBuffer sql = new StringBuffer(pos * 4);
        sql.append(this._statementDirty);
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = fields.length - 1; i >= 0; --i) {
            if (!fields[i].isStore() || !fields[i].isDirtyCheck()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            Object value = oldentity.getField(i);
            if (value == null) {
                for (int j = columns.length - 1; j >= 0; --j) {
                    pos = this.nextParameter(true, sql, pos);
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = columns.length - 1; j >= 0; --j) {
                    pos = this.nextParameter(identity.get(j) == null, sql, pos);
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            pos = this.nextParameter(false, sql, pos);
        }
        return sql.toString();
    }

    private int nextParameter(boolean isNull, StringBuffer sb, int pos) {
        int internalpos;
        for (internalpos = pos; internalpos > 0 && (sb.charAt(internalpos - 1) != '=' || sb.charAt(internalpos) != '?'); --internalpos) {
        }
        if (internalpos > 0) {
            --internalpos;
            if (isNull) {
                sb.delete(internalpos, internalpos + 2);
                sb.insert(internalpos, " IS NULL");
            }
        }
        return internalpos;
    }
}

