/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import org.castor.core.nature.PropertyHolder;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.jdo.util.ClassLoadingUtils;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.Types;

public class ParamInfo {
    private String _userDefinedType;
    private String _systemType;
    private Class _class;
    private Class _fieldType;
    private Class _sqlType;
    private ClassLoader _classLoader;
    private TypeConvertor _convertor;

    public ParamInfo(String userDefinedType, String systemType, FieldDescriptor desc, ClassLoader classLoader) throws QueryException {
        this._userDefinedType = userDefinedType;
        this._systemType = systemType;
        this._classLoader = classLoader;
        Class userClass = null;
        Class systemClass = null;
        try {
            systemClass = ClassLoadingUtils.loadClass(this._classLoader, systemType);
        }
        catch (Exception e) {
            throw new QueryException("Error: Could not find system defined class: " + systemType);
        }
        if (!userDefinedType.equals("")) {
            try {
                userClass = Types.typeFromName((ClassLoader)this.getClass().getClassLoader(), (String)userDefinedType);
                if (userClass.isPrimitive()) {
                    userClass = Types.typeFromPrimitive((Class)userClass);
                }
            }
            catch (Exception e) {
                throw new QueryException("The class " + userClass + " could not be found.");
            }
            if (!(systemClass.isAssignableFrom(userClass) || Number.class.isAssignableFrom(userClass) && Number.class.isAssignableFrom(systemClass))) {
                throw new QueryException("The class " + userClass + " is incompatible with the system defined class " + systemType);
            }
            this._class = userClass;
        } else {
            this._class = systemClass;
        }
        if (desc != null) {
            this._fieldType = desc.getFieldType();
            try {
                this._sqlType = SQLTypeInfos.sqlTypeNum2javaType(new FieldDescriptorJDONature((PropertyHolder)desc).getSQLType()[0]);
            }
            catch (Exception ex) {
                throw new QueryException("Can't determine SQL class: " + ex);
            }
            this._convertor = new FieldDescriptorJDONature((PropertyHolder)desc).getConvertor();
        }
    }

    public void check(String userDefinedType, String systemType) throws QueryException {
        if (!this._userDefinedType.equals(userDefinedType)) {
            throw new QueryException("Different types were specified for the same numbered parameter.");
        }
        if (!systemType.equals(this._systemType)) {
            Class systemClass = null;
            try {
                systemClass = ClassLoadingUtils.loadClass(this._classLoader, systemType);
            }
            catch (Exception e) {
                throw new QueryException("Error: Could notfind system defined class: " + systemType);
            }
            if (!userDefinedType.equals("")) {
                Class userClass = null;
                try {
                    userClass = ClassLoadingUtils.loadClass(this._classLoader, this._userDefinedType);
                }
                catch (Exception e) {
                    throw new QueryException("The class " + userClass + " could not be found.");
                }
                if (!systemClass.isAssignableFrom(userClass)) {
                    throw new QueryException("The class " + userDefinedType + " is incompatible with the system defined class " + systemType);
                }
            }
        }
    }

    public boolean isUserDefined() {
        return !this._userDefinedType.equals("");
    }

    public Class getTheClass() {
        return this._class;
    }

    public Class getFieldType() {
        return this._fieldType;
    }

    public Class getSQLType() {
        return this._sqlType;
    }

    public TypeConvertor getConvertor() {
        return this._convertor;
    }
}

