/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.resolver.ResolverFactory;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Persistent;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOCallback;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.util.JDOClassDescriptorResolver;

public class ClassMolder {
    private static Log _log = LogFactory.getFactory().getInstance(ClassMolder.class);
    private String _name;
    private FieldMolder[] _ids;
    private FieldMolder[] _fhs;
    private ClassMolder _extends;
    private ClassMolder _depends;
    private Vector _dependent;
    private Vector _extendent;
    private AccessMode _accessMode;
    private Persistence _persistence;
    private LockEngine _engine;
    private CallbackInterceptor _callback;
    private Properties _cacheParams;
    public boolean _isKeyGenUsed;
    private boolean _debug = Boolean.getBoolean("org.exolab.castor.debug");
    private boolean _timeStampable;
    private int _priority = -1;
    private boolean _resolversHaveBeenReset = false;
    private ResolverStrategy[] _resolvers;
    private final ClassDescriptor _clsDesc;

    ClassMolder(DatingService ds, ClassDescriptorResolver classDescrResolver, LockEngine lock, ClassDescriptor clsDesc, Persistence persist) throws ClassNotFoundException, MappingException {
        this._engine = lock;
        this._persistence = persist;
        this._clsDesc = clsDesc;
        ClassMapping clsMap = ((ClassDescriptorImpl)clsDesc).getMapping();
        this._name = clsMap.getName();
        this._accessMode = AccessMode.valueOf((String)clsMap.getAccess().toString());
        this._timeStampable = TimeStampable.class.isAssignableFrom(clsDesc.getJavaClass());
        ds.register(this._name, this);
        ClassMapping dependClassMapping = (ClassMapping)clsMap.getDepends();
        ClassMapping extendsClassMapping = (ClassMapping)clsMap.getExtends();
        if (dependClassMapping != null) {
            ds.pairDepends(this, dependClassMapping.getName());
        }
        if (extendsClassMapping != null) {
            ds.pairExtends(this, extendsClassMapping.getName());
        }
        if (clsDesc.hasNature(ClassDescriptorJDONature.class.getName())) {
            ClassDescriptorJDONature nature = new ClassDescriptorJDONature((PropertyHolder)clsDesc);
            this._cacheParams = nature.getCacheParams();
            this._isKeyGenUsed = nature.getKeyGeneratorDescriptor() != null;
        }
        FieldMapping[] fmId = ClassMolderHelper.getIdFields(clsMap);
        this._ids = new FieldMolder[fmId.length];
        for (int i = 0; i < this._ids.length; ++i) {
            this._ids[i] = new FieldMolder(ds, this, fmId[i]);
        }
        FieldMapping[] fmFields = ClassMolderHelper.getFullFields(clsMap);
        int numberOfNonTransientFieldMolders = 0;
        for (int i = 0; i < fmFields.length; ++i) {
            if (this.isFieldTransient(fmFields[i])) continue;
            ++numberOfNonTransientFieldMolders;
        }
        this._fhs = new FieldMolder[numberOfNonTransientFieldMolders];
        this._resolvers = new ResolverStrategy[numberOfNonTransientFieldMolders];
        int fieldMolderNumber = 0;
        for (int i = 0; i < fmFields.length; ++i) {
            if (this.isFieldTransient(fmFields[i])) continue;
            if (fmFields[i].getSql() != null && fmFields[i].getSql().getManyTable() != null) {
                String[] manyName;
                String[] manyKey;
                String[] relatedIdSQL = null;
                int[] relatedIdType = null;
                TypeConvertor[] relatedIdConvertTo = null;
                TypeConvertor[] relatedIdConvertFrom = null;
                String manyTable = fmFields[i].getSql().getManyTable();
                String[] idSQL = new String[fmId.length];
                int[] idType = new int[fmId.length];
                TypeConvertor[] idConvertFrom = new TypeConvertor[fmId.length];
                TypeConvertor[] idConvertTo = new TypeConvertor[fmId.length];
                FieldDescriptor[] fd = ((ClassDescriptorImpl)clsDesc).getIdentities();
                for (int j = 0; j < fmId.length; ++j) {
                    idSQL[j] = fmId[j].getSql().getName()[0];
                    if (!fd[j].hasNature(FieldDescriptorJDONature.class.getName())) {
                        throw new MappingException("Identity type must contains sql information: " + this._name);
                    }
                    int[] type = new FieldDescriptorJDONature((PropertyHolder)fd[j]).getSQLType();
                    idType[j] = type == null ? 0 : type[0];
                    FieldHandlerImpl fh = (FieldHandlerImpl)fd[j].getHandler();
                    idConvertTo[j] = fh.getConvertTo();
                    idConvertFrom[j] = fh.getConvertFrom();
                }
                ClassDescriptor relDesc = null;
                try {
                    JDOClassDescriptorResolver jdoCDR = (JDOClassDescriptorResolver)classDescrResolver;
                    relDesc = jdoCDR.resolve(fmFields[i].getType());
                }
                catch (ResolverException e) {
                    throw new MappingException("Problem resolving class descriptor for class " + fmFields.getClass(), (Exception)((Object)e));
                }
                if (relDesc.hasNature(ClassDescriptorJDONature.class.getName())) {
                    FieldDescriptor[] relatedIds = ((ClassDescriptorImpl)relDesc).getIdentities();
                    relatedIdSQL = new String[relatedIds.length];
                    relatedIdType = new int[relatedIds.length];
                    relatedIdConvertTo = new TypeConvertor[relatedIds.length];
                    relatedIdConvertFrom = new TypeConvertor[relatedIds.length];
                    for (int j = 0; j < relatedIdSQL.length; ++j) {
                        if (!relatedIds[j].hasNature(FieldDescriptorJDONature.class.getName())) {
                            throw new MappingException("Field type is not persistence-capable: " + relatedIds[j].getFieldName());
                        }
                        FieldDescriptorJDONature nature = new FieldDescriptorJDONature((PropertyHolder)relatedIds[j]);
                        String[] tempId = nature.getSQLName();
                        relatedIdSQL[j] = tempId == null ? null : tempId[0];
                        int[] tempType = nature.getSQLType();
                        relatedIdType[j] = tempType == null ? 0 : tempType[0];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relatedIds[j].getHandler();
                        relatedIdConvertTo[j] = fh.getConvertTo();
                        relatedIdConvertFrom[j] = fh.getConvertFrom();
                    }
                }
                if ((manyKey = fmFields[i].getSql().getManyKey()) != null && manyKey.length != 0) {
                    if (manyKey.length != idSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + clsDesc.getJavaClass().getName());
                    }
                    idSQL = manyKey;
                }
                if ((manyName = fmFields[i].getSql().getName()) != null && manyName.length != 0) {
                    if (manyName.length != relatedIdSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + relDesc.getJavaClass().getName());
                    }
                    relatedIdSQL = manyName;
                }
                this._fhs[fieldMolderNumber] = new FieldMolder(ds, this, fmFields[i], manyTable, idSQL, idType, idConvertTo, idConvertFrom, relatedIdSQL, relatedIdType, relatedIdConvertTo, relatedIdConvertFrom);
            } else {
                this._fhs[fieldMolderNumber] = new FieldMolder(ds, this, fmFields[i]);
            }
            this._resolvers[fieldMolderNumber] = ResolverFactory.createRelationResolver(this._fhs[fieldMolderNumber], this, fieldMolderNumber, this._debug);
            ++fieldMolderNumber;
        }
        if (Persistent.class.isAssignableFrom(ds.resolve(this._name))) {
            this._callback = new JDOCallback();
        }
    }

    public ClassDescriptor getClassDescriptor() {
        return this._clsDesc;
    }

    private boolean isFieldTransient(FieldMapping fieldMapping) {
        boolean isFieldTransient = fieldMapping.getTransient();
        if (fieldMapping.getSql() != null) {
            isFieldTransient |= fieldMapping.getSql().getTransient();
        }
        return isFieldTransient;
    }

    public boolean removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        boolean removed = false;
        boolean updateCache = false;
        boolean updatePersist = false;
        this.resetResolvers();
        UpdateAndRemovedFlags flags = null;
        for (int i = 0; i < this._fhs.length; ++i) {
            flags = this._resolvers[i].removeRelation(tx, object, relatedMolder, relatedObject);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            removed |= flags.getRemoved();
        }
        tx.markModified(object, updatePersist, updateCache);
        return removed;
    }

    public int getPriority() {
        if (this._priority == -2) {
            return 0;
        }
        if (this._priority < 0) {
            this._priority = -2;
            int maxPrior = 0;
            for (int i = 0; i < this._fhs.length; ++i) {
                if (!this._fhs[i].isPersistanceCapable() || this._fhs[i].getFieldClassMolder() == this || !this._fhs[i].isStored()) continue;
                int refPrior = this._fhs[i].getFieldClassMolder().getPriority() + 1;
                maxPrior = Math.max(maxPrior, refPrior);
            }
            if (this._depends != null) {
                maxPrior = Math.max(maxPrior, this._depends.getPriority() + 1);
            }
            if (this._extends != null) {
                maxPrior = Math.max(maxPrior, this._extends.getPriority() + 1);
            }
            this._priority = maxPrior;
        }
        return this._priority;
    }

    public void loadTimeStamp(TransactionContext tx, DepositBox locker, AccessMode suggestedAccessMode) throws PersistenceException {
        Object loadObject = null;
        try {
            loadObject = this.newInstance(tx.getClassLoader());
        }
        catch (Exception ex) {
            throw new PersistenceException("failed to load object", ex);
        }
        ProposedEntity proposedObject = new ProposedEntity(this);
        proposedObject.setProposedEntityClass(loadObject.getClass());
        proposedObject.setEntity(loadObject);
        OID oid = locker.getOID();
        Object[] cachedFieldValues = locker.getObject(tx);
        proposedObject.setFields(cachedFieldValues);
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (!proposedObject.isFieldsSet() || accessMode == AccessMode.DbLocked) {
            proposedObject.initializeFields(this._fhs.length);
            Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
            this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
        }
        this.mold(tx, locker, proposedObject, suggestedAccessMode);
    }

    public void load(TransactionContext tx, DepositBox locker, ProposedEntity proposedObject, AccessMode suggestedAccessMode, QueryResults results) throws PersistenceException {
        OID oid = locker.getOID();
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be loaded is null");
        }
        if (!proposedObject.isObjectLockObjectToBeIgnored()) {
            Object[] cachedFieldValues = locker.getObject(tx);
            proposedObject.setFields(cachedFieldValues);
        } else {
            proposedObject.setFields(null);
        }
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (!proposedObject.isFieldsSet() || accessMode == AccessMode.DbLocked) {
            proposedObject.initializeFields(this._fhs.length);
            if (results != null) {
                results.getQuery().fetch(proposedObject);
            } else {
                Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
                this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
            }
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
        }
        proposedObject.setActualClassMolder(this);
        if (!proposedObject.isExpanded()) {
            this.mold(tx, locker, proposedObject, suggestedAccessMode);
        }
    }

    public void mold(TransactionContext tx, DepositBox locker, ProposedEntity proposedObject, AccessMode suggestedAccessMode) throws PersistenceException {
        OID oid = locker.getOID();
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        this.resetResolvers();
        if (proposedObject.getEntity() instanceof TimeStampable) {
            ((TimeStampable)proposedObject.getEntity()).jdoSetTimeStamp(locker.getTimeStamp());
        }
        this.setIdentity(tx, proposedObject.getEntity(), oid.getIdentity());
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this._resolvers[i].load(tx, oid, proposedObject, accessMode);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Unexpected field type!");
                }
            }
        }
        if (proposedObject.getEntity() instanceof TimeStampable) {
            locker.setTimeStamp(((TimeStampable)proposedObject.getEntity()).jdoGetTimeStamp());
        }
    }

    public Identity create(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        this.resetResolvers();
        if (this._persistence == null) {
            throw new PersistenceException("non persistence capable: " + oid.getName());
        }
        ProposedEntity entity = new ProposedEntity();
        entity.initializeFields(this._fhs.length);
        Identity ids = oid.getIdentity();
        long timeStamp = System.currentTimeMillis();
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(timeStamp);
        }
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    entity.setField(this._resolvers[i].create(tx, object), i);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        Identity createdId = this._persistence.create(tx.getDatabase(), tx.getConnection(oid.getMolder().getLockEngine()), entity, ids);
        if (createdId == null) {
            throw new PersistenceException("Identity can't be created!");
        }
        locker.setObject(tx, entity.getFields(), timeStamp);
        oid.setDbLock(true);
        this.setIdentity(tx, object, createdId);
        for (int i = 0; i < this._fhs.length; ++i) {
            entity.setField(this._resolvers[i].postCreate(tx, oid, object, entity.getField(i), createdId), i);
        }
        return createdId;
    }

    public void markCreate(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        boolean updateCache = false;
        this.resetResolvers();
        for (int i = 0; i < this._fhs.length; ++i) {
            updateCache |= this._resolvers[i].markCreate(tx, oid, object);
        }
        tx.markModified(object, false, updateCache);
    }

    public boolean preStore(TransactionContext tx, OID oid, DepositBox locker, Object object, int timeout) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForStore", (Object)this._name));
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format((String)"jdo.identityChanged", (Object)this._name, (Object)oid.getIdentity(), (Object)this.getIdentity(tx, object)));
        }
        Object[] fields = locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException(Messages.format((String)"persist.objectNotFound", (Object)this._name, (Object)oid));
        }
        Object[] newfields = new Object[this._fhs.length];
        boolean updateCache = false;
        boolean updatePersist = false;
        for (int i = 0; i < newfields.length; ++i) {
            UpdateFlags flags = this._resolvers[i].preStore(tx, oid, object, timeout, fields[i]);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            newfields[i] = flags.getNewField();
        }
        tx.markModified(object, updatePersist, updateCache);
        if (updateCache || updatePersist) {
            tx.writeLock(object, timeout);
        }
        return updateCache;
    }

    public void store(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForStore", (Object)this._name));
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format((String)"jdo.identityChanged", (Object)this._name, (Object)oid.getIdentity(), (Object)this.getIdentity(tx, object)));
        }
        ProposedEntity oldentity = new ProposedEntity();
        oldentity.setFields(locker.getObject(tx));
        if (oldentity.getFields() == null) {
            throw new PersistenceException(Messages.format((String)"persist.objectNotFound", (Object)this._name, (Object)oid));
        }
        long timeStamp = System.currentTimeMillis();
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(timeStamp);
        }
        ProposedEntity newentity = new ProposedEntity();
        newentity.initializeFields(this._fhs.length);
        for (int i = 0; i < this._fhs.length; ++i) {
            newentity.setField(this._resolvers[i].store(tx, object, oldentity.getField(i)), i);
        }
        Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
        this._persistence.store(conn, oid.getIdentity(), newentity, oldentity);
    }

    public boolean update(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        long objectTimestamp;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        this.resetResolvers();
        Object[] fields = locker.getObject(tx);
        if (!this.isDependent() && !this._timeStampable) {
            throw new IllegalArgumentException("A master object that involves in a long transaction must be a TimeStampable!");
        }
        long lockTimestamp = locker.getTimeStamp();
        long l = objectTimestamp = this._timeStampable ? ((TimeStampable)object).jdoGetTimeStamp() : 1L;
        if (objectTimestamp > 0L && oid.getIdentity() != null) {
            if (this._timeStampable && lockTimestamp == 0L) {
                throw new PersistenceException(Messages.format((String)"persist.objectNotInCache", (Object)this._name, (Object)oid.getIdentity()));
            }
            if (this._timeStampable && objectTimestamp != lockTimestamp) {
                throw new ObjectModifiedException("Timestamp mismatched!");
            }
            if (!this._timeStampable && this.isDependent() && fields == null) {
                fields = new Object[this._fhs.length];
                Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
                ProposedEntity proposedObject = new ProposedEntity(this);
                proposedObject.setProposedEntityClass(object.getClass());
                proposedObject.setEntity(object);
                proposedObject.setFields(fields);
                this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
                fields = proposedObject.getFields();
                oid.setDbLock(accessMode == AccessMode.DbLocked);
                locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
            }
            try {
                for (int i = 0; i < this._fhs.length; ++i) {
                    this._resolvers[i].update(tx, oid, object, accessMode, fields[i]);
                }
            }
            catch (ObjectNotFoundException e) {
                _log.warn((Object)e.getMessage(), (Throwable)((Object)e));
                throw new ObjectModifiedException("dependent object deleted concurrently");
            }
            return false;
        }
        if (objectTimestamp == 0L || objectTimestamp == 1L) {
            boolean updateCache = false;
            for (int i = 0; i < this._fhs.length; ++i) {
                updateCache |= this._resolvers[i].updateWhenNoTimestampSet(tx, oid, object, suggestedAccessMode);
            }
            tx.markModified(object, false, updateCache);
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("object: " + object + " timestamp: " + objectTimestamp + " lockertimestamp: " + lockTimestamp));
        }
        throw new ObjectModifiedException("Invalid object timestamp detected.");
    }

    public void updateCache(TransactionContext tx, OID oid, DepositBox locker, Object object) {
        this.resetResolvers();
        if (oid.getIdentity() == null) {
            throw new IllegalStateException(Messages.format((String)"persist.missingIdentityForCacheUpdate", (Object)this._name));
        }
        Object[] fields = new Object[this._fhs.length];
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    fields[i] = this._resolvers[i].updateCache(tx, oid, object);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        if (object instanceof TimeStampable) {
            locker.setObject(tx, fields, ((TimeStampable)object).jdoGetTimeStamp());
        } else {
            locker.setObject(tx, fields, System.currentTimeMillis());
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        this.resetResolvers();
        Identity ids = oid.getIdentity();
        for (int i = 0; i < this._fhs.length; ++i) {
            if (!this._fhs[i].isManyToMany()) continue;
            this._fhs[i].getRelationLoader().deleteRelation(tx.getConnection(oid.getMolder().getLockEngine()), ids);
        }
        this._persistence.delete(tx.getConnection(oid.getMolder().getLockEngine()), ids);
        Vector<ClassMolder> extendPath = new Vector<ClassMolder>();
        ClassMolder base = this;
        while (base != null) {
            extendPath.add(base);
            base = base._extends;
        }
        base = this._depends;
        while (base != null) {
            if (base._extendent != null) {
                for (int i = 0; i < base._extendent.size(); ++i) {
                    if (!extendPath.contains(base._extendent.get(i))) continue;
                }
            }
            base = base._extends;
        }
    }

    public void markDelete(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        this.resetResolvers();
        Object[] fields = locker.getObject(tx);
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this._resolvers[i].markDelete(tx, object, fields[i]);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Invalid field type!");
                }
            }
        }
    }

    public void revertObject(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        this.resetResolvers();
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForReverting", (Object)this._name));
        }
        Object[] fields = locker.getObject(tx);
        this.setIdentity(tx, object, oid.getIdentity());
        for (int i = 0; i < this._fhs.length; ++i) {
            if (fields != null) {
                this._resolvers[i].revertObject(tx, oid, object, fields[i]);
                continue;
            }
            this._resolvers[i].revertObject(tx, oid, object, null);
        }
    }

    public Object newInstance(ClassLoader loader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class aClass = null;
        aClass = ClassLoadingUtils.loadClass(loader, this._name);
        return aClass.newInstance();
    }

    public AccessMode getAccessMode(AccessMode txMode) {
        if (txMode == null) {
            return this._accessMode;
        }
        if (this._accessMode == AccessMode.ReadOnly || txMode == AccessMode.ReadOnly) {
            return AccessMode.ReadOnly;
        }
        if (this._accessMode == AccessMode.DbLocked || txMode == AccessMode.DbLocked) {
            return AccessMode.DbLocked;
        }
        if (this._accessMode == AccessMode.Exclusive || txMode == AccessMode.Exclusive) {
            return AccessMode.Exclusive;
        }
        return txMode;
    }

    public CallbackInterceptor getCallback() {
        return this._callback;
    }

    public boolean isDefaultIdentity(Identity identity) {
        if (identity == null) {
            return true;
        }
        for (int i = 0; i < identity.size(); ++i) {
            if (this._ids[i].isDefault(identity.get(i))) continue;
            return false;
        }
        return true;
    }

    public Identity getIdentity(TransactionContext tx, Object o) {
        if (this.isKeyGeneratorUsed() && !tx.isPersistent(o) && !tx.isReadOnly(o)) {
            return null;
        }
        return this.getActualIdentity(tx, o);
    }

    public Identity getActualIdentity(TransactionContext tx, Object o) {
        return this.getActualIdentity(tx.getClassLoader(), o);
    }

    public Identity getActualIdentity(ClassLoader loader, Object o) {
        Object[] ids = new Object[this._ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this._ids[i].getValue(o, loader);
        }
        if (ids[0] == null) {
            return null;
        }
        return new Identity(ids);
    }

    public void setIdentity(TransactionContext tx, Object object, Identity identity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Identity size mismatched!");
        }
        for (int i = 0; i < this._ids.length; ++i) {
            this._ids[i].setValue(object, identity.get(i), tx.getClassLoader());
        }
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public Class getJavaClass(ClassLoader loader) {
        Class result = null;
        try {
            result = ClassLoadingUtils.loadClass(loader, this._name);
        }
        catch (ClassNotFoundException e) {
            _log.error((Object)("Unable to load base class of " + this.getName()), (Throwable)e);
        }
        return result;
    }

    public boolean isAssignableFrom(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        Class molderClass = null;
        try {
            molderClass = ClassLoadingUtils.loadClass(loader, this._name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return molderClass.isAssignableFrom(cls);
    }

    public String getName() {
        return this._name;
    }

    public ClassMolder getExtends() {
        return this._extends;
    }

    public ClassMolder getDepends() {
        return this._depends;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    public Properties getCacheParams() {
        return this._cacheParams;
    }

    public boolean isDependent() {
        return this._depends != null;
    }

    void addExtendent(ClassMolder ext) {
        if (this._extendent == null) {
            this._extendent = new Vector();
        }
        this._extendent.add(ext);
    }

    void addDependent(ClassMolder dep) {
        if (this._dependent == null) {
            this._dependent = new Vector();
        }
        this._dependent.add(dep);
    }

    void setExtends(ClassMolder ext) {
        this._extends = ext;
        ext.addExtendent(this);
    }

    void setDepends(ClassMolder dep) {
        this._depends = dep;
        dep.addDependent(this);
    }

    public String toString() {
        return "ClassMolder " + this._name;
    }

    public boolean isKeyGenUsed() {
        return this._isKeyGenUsed;
    }

    public boolean isKeyGeneratorUsed() {
        return this._isKeyGenUsed || this._extends != null && this._extends.isKeyGeneratorUsed();
    }

    public void expireCache(TransactionContext tx, ObjectLock locker) throws PersistenceException {
        Object[] fields = locker.getObject();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < this._fhs.length; ++i) {
            this._resolvers[i].expireCache(tx, fields[i]);
        }
    }

    public void resetResolvers() {
        if (!this._resolversHaveBeenReset) {
            for (int i = 0; i < this._fhs.length; ++i) {
                this._resolvers[i] = ResolverFactory.createRelationResolver(this._fhs[i], this, i, this._debug);
            }
            this._resolversHaveBeenReset = true;
        }
    }

    public String getNamedQuery(String name) {
        return (String)new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getNamedQueries().get(name);
    }
}

