/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.EnumerationIterator;
import org.castor.persist.TransactionContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.AbstractMappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.util.JDOClassDescriptorResolver;

public final class ClassMolderHelper {
    public static final Log LOG = LogFactory.getLog(ClassMolderHelper.class);

    private ClassMolderHelper() {
    }

    public static Vector resolve(ClassDescriptorResolver cdResolver, LockEngine lock, PersistenceFactory factory) throws MappingException, ClassNotFoundException {
        Vector<ClassMolder> result = new Vector<ClassMolder>();
        JDOClassDescriptorResolver jdoCDR = (JDOClassDescriptorResolver)cdResolver;
        DatingService ds = new DatingService(jdoCDR.getClassLoader());
        Iterator iter = ((JDOClassDescriptorResolver)cdResolver).descriptorIterator();
        while (iter.hasNext()) {
            ClassDescriptor desc;
            Object next = iter.next();
            ClassDescriptor nextCd = (ClassDescriptor)next;
            Class toResolve = nextCd.getJavaClass();
            try {
                desc = cdResolver.resolve(toResolve);
            }
            catch (ResolverException e) {
                throw new MappingException("Cannot resolve type for " + toResolve.getName(), (Exception)((Object)e));
            }
            Persistence persist = factory.getPersistence(desc);
            ClassMolder mold = ClassMolderHelper.createClassMolder(ds, cdResolver, lock, desc, persist);
            result.add(mold);
        }
        ds.close();
        return result;
    }

    private static ClassMolder createClassMolder(DatingService ds, ClassDescriptorResolver cdResolver, LockEngine lockEngine, ClassDescriptor descriptor, Persistence persistence) throws MappingException, ClassNotFoundException {
        return new ClassMolder(ds, cdResolver, lockEngine, descriptor, persistence);
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0) {
            return true;
        }
        if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
            Timestamp t1 = (Timestamp)o1;
            Timestamp t2 = (Timestamp)o2;
            return t1.getTime() == t2.getTime() && t1.getNanos() / 1000000 == t2.getNanos() / 1000000;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public static boolean isEquals(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    public static ArrayList extractIdentityList(TransactionContext tx, ClassMolder molder, Object col) {
        if (col == null) {
            return new ArrayList();
        }
        if (col instanceof Collection) {
            ArrayList<Identity> idList = new ArrayList<Identity>();
            Iterator itor = ((Collection)col).iterator();
            while (itor.hasNext()) {
                Identity id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Iterator) {
            ArrayList<Identity> idList = new ArrayList<Identity>();
            Iterator itor = (Iterator)col;
            while (itor.hasNext()) {
                Identity id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Enumeration) {
            ArrayList<Identity> idList = new ArrayList<Identity>();
            Enumeration enumeration = (Enumeration)col;
            while (enumeration.hasMoreElements()) {
                Identity id = molder.getIdentity(tx, enumeration.nextElement());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Map) {
            ArrayList<Identity> idList = new ArrayList<Identity>();
            Iterator itor = ((Map)col).values().iterator();
            while (itor.hasNext()) {
                Identity id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col.getClass().isArray()) {
            ArrayList<Identity> idList = new ArrayList<Identity>();
            Object[] arrayCol = (Object[])col;
            for (int i = 0; i < arrayCol.length; ++i) {
                Identity id = molder.getIdentity(tx, arrayCol[i]);
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        throw new IllegalArgumentException("A Collection or Map is expected!");
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object.getClass().isArray()) {
            final class ArrayIterator
            implements Iterator {
                private Object[] _array;
                private int _i = 0;

                ArrayIterator(Object[] array) {
                    this._array = array;
                }

                public boolean hasNext() {
                    return this._i < this._array.length;
                }

                public Object next() {
                    return this._array[this._i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new ArrayIterator((Object[])object);
        }
        throw new IllegalArgumentException();
    }

    public static FieldMapping[] getFullFields(ClassMapping clsMap) throws MappingException {
        FieldMapping[] fields = null;
        ClassMapping extend = (ClassMapping)clsMap.getExtends();
        if (extend != null) {
            int i;
            ClassMapping origin = extend;
            while (origin.getExtends() != null) {
                origin = (ClassMapping)origin.getExtends();
            }
            String[] identities = origin.getIdentity();
            identities = AbstractMappingLoader.getIdentityColumnNames((String[])identities, (ClassMapping)origin);
            FieldMapping[] extendFields = ClassMolderHelper.getFullFields(extend);
            FieldMapping[] thisFields = clsMap.getClassChoice() != null ? clsMap.getClassChoice().getFieldMapping() : new FieldMapping[]{};
            ArrayList<FieldMapping> fieldList = new ArrayList<FieldMapping>(extendFields.length + thisFields.length - identities.length);
            for (i = 0; i < extendFields.length; ++i) {
                fieldList.add(extendFields[i]);
            }
            for (i = 0; i < thisFields.length; ++i) {
                boolean idfield = false;
                for (int k = 0; k < identities.length; ++k) {
                    if (!thisFields[i].getName().equals(identities[k])) continue;
                    idfield = true;
                    break;
                }
                if (idfield) continue;
                fieldList.add(thisFields[i]);
            }
            fields = new FieldMapping[fieldList.size()];
            fieldList.toArray(fields);
        } else {
            String[] identities = clsMap.getIdentity();
            if ((identities = AbstractMappingLoader.getIdentityColumnNames((String[])identities, (ClassMapping)clsMap)) == null || identities.length == 0) {
                throw new MappingException("Identity is null!");
            }
            FieldMapping[] thisFields = clsMap.getClassChoice().getFieldMapping();
            fields = new FieldMapping[thisFields.length - identities.length];
            int j = 0;
            for (int i = 0; i < thisFields.length; ++i) {
                boolean idfield = false;
                for (int k = 0; k < identities.length; ++k) {
                    if (!thisFields[i].getName().equals(identities[k])) continue;
                    idfield = true;
                    break;
                }
                if (idfield) continue;
                fields[j] = thisFields[i];
                ++j;
            }
        }
        return fields;
    }

    public static FieldMapping[] getIdFields(ClassMapping clsMap) throws MappingException {
        ClassMapping base = clsMap;
        while (base.getExtends() != null) {
            base = (ClassMapping)base.getExtends();
        }
        Object fmDepended = null;
        String[] identities = base.getIdentity();
        if ((identities = AbstractMappingLoader.getIdentityColumnNames((String[])identities, (ClassMapping)base)) == null || identities.length == 0) {
            throw new MappingException("Identity is null!");
        }
        FieldMapping[] fmIds = new FieldMapping[identities.length];
        FieldMapping[] fmBase = base.getClassChoice().getFieldMapping();
        block1: for (int i = 0; i < fmBase.length; ++i) {
            for (int k = 0; k < identities.length; ++k) {
                if (!fmBase[i].getName().equals(identities[k])) continue;
                fmIds[k] = fmBase[i];
                continue block1;
            }
        }
        if (fmDepended == null) {
            return fmIds;
        }
        FieldMapping[] fmResult = new FieldMapping[(fmDepended).length + identities.length];
        System.arraycopy(fmIds, 0, fmResult, 0, fmIds.length);
        System.arraycopy(fmDepended, 0, fmResult, fmIds.length, (fmDepended).length);
        return fmIds;
    }

    public static Collection getAddedValuesList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            return new ArrayList(0);
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return ((Map)collection).values();
            }
            ArrayList added = new ArrayList(((Map)collection).size());
            for (Object newValue : ((Map)collection).values()) {
                Identity newId = ch.getIdentity(tx, newValue);
                if (orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return (Collection)collection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Collection newValues = (Collection)collection;
            ArrayList added = new ArrayList(newValues.size());
            for (Object newValue : newValues) {
                Identity newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection instanceof Iterator) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                Iterator iterator = (Iterator)collection;
                ArrayList returnCollection = new ArrayList();
                while (iterator.hasNext()) {
                    returnCollection.add(iterator.next());
                }
                return returnCollection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Iterator newValuesIterator = (Iterator)collection;
            ArrayList added = new ArrayList();
            while (newValuesIterator.hasNext()) {
                Object newValue = newValuesIterator.next();
                Identity newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection instanceof Enumeration) {
            if (collection == null) {
                return new ArrayList(0);
            }
            Enumeration newValues = (Enumeration)collection;
            ArrayList added = new ArrayList();
            if (orgIds == null || orgIds.size() == 0) {
                while (newValues.hasMoreElements()) {
                    Object newValue = newValues.nextElement();
                    added.add(newValue);
                }
            } else {
                while (newValues.hasMoreElements()) {
                    Object newValue = newValues.nextElement();
                    Identity newId = ch.getIdentity(tx, newValue);
                    if (newId != null && orgIds.contains(newId)) continue;
                    added.add(newValue);
                }
            }
            return added;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                Object[] newValues = (Object[])collection;
                ArrayList<Object> result = new ArrayList<Object>(newValues.length);
                for (int i = 0; i < newValues.length; ++i) {
                    result.add(newValues[i]);
                }
                return result;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Object[] newValues = (Object[])collection;
            ArrayList<Object> added = new ArrayList<Object>(newValues.length);
            for (int i = 0; i < newValues.length; ++i) {
                Object newValue = newValues[i];
                Identity newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    public static Collection getRemovedIdsList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            if (orgIds == null) {
                return new ArrayList(0);
            }
            return orgIds;
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            HashSet<Identity> newIds = new HashSet<Identity>(((Map)collection).size());
            Iterator newItor = ((Map)collection).values().iterator();
            while (newItor.hasNext()) {
                newIds.add(ch.getIdentity(tx, newItor.next()));
            }
            ArrayList removed = new ArrayList(orgIds.size());
            for (Object id : orgIds) {
                if (newIds.contains(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Enumeration) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Enumeration newCol = (Enumeration)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            while (newCol.hasMoreElements()) {
                Object newObject = newCol.nextElement();
                Identity newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Collection newCol = (Collection)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            for (Object newObject : newCol) {
                Identity newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Iterator) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Iterator collectionIterator = (Iterator)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            while (collectionIterator.hasNext()) {
                Object newObject = collectionIterator.next();
                Identity newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Object[] newCol = (Object[])collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap<Identity, Object> newMap = new HashMap<Identity, Object>();
            for (int i = 0; i < newCol.length; ++i) {
                Object newObject = newCol[i];
                Identity newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }
}

