/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.jdo.util.ClassLoadingUtils;
import org.exolab.castor.jdo.DataObjectAccessException;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.types.SqlDirtyType;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.SQLRelationLoader;

public class FieldMolder {
    private static final String COLLECTION_TYPE_ARRAY = "array";
    private static final String COLLECTION_TYPE_COLLECTION = "collection";
    private static final String COLLECTION_TYPE_VECTOR = "vector";
    private static final String COLLECTION_TYPE_ARRAYLIST = "arraylist";
    private static final String COLLECTION_TYPE_HASHTABLE = "hashtable";
    private static final String COLLECTION_TYPE_MAP = "map";
    private static final String COLLECTION_TYPE_SET = "set";
    private static final String COLLECTION_TYPE_HASHMAP = "hashmap";
    private static final String COLLECTION_TYPE_HASHSET = "hashset";
    private static final String COLLECTION_TYPE_SORTED_SET = "sortedset";
    private static final String COLLECTION_TYPE_ITERATOR = "iterator";
    private static final String COLLECTION_TYPE_ENUMERATON = "enumerate";
    private static final String COLLECTION_TYPE_SORTED_MAP = "sortedmap";
    private static final String FIELD_TYPE_SERIALIZABLE = "serializable";
    public static final short PRIMITIVE = 0;
    public static final short SERIALIZABLE = 1;
    public static final short PERSISTANCECAPABLE = 2;
    public static final short ONE_TO_MANY = 3;
    public static final short MANY_TO_MANY = 4;
    private static Log _log = LogFactory.getFactory().getInstance(FieldMolder.class);
    private static final String METHOD_GET_PREFIX = "get";
    private static final String METHOD_IS_PREFIX = "is";
    private static final String METHOD_SET_PREFIX = "set";
    private static final String METHOD_ADD_PREFIX = "add";
    private static final String METHOD_CREATE_PREFIX = "create";
    private static final String METHOD_DELETE_PREFIX = "delete";
    private static final String METHOD_HAS_PREFIX = "has";
    private boolean _lazy;
    private boolean _check;
    private boolean _store;
    private boolean _multi;
    private boolean _serial;
    private boolean _addable;
    private ClassMolder _eMold;
    private ClassMolder _fMold;
    private Class _colClass;
    private String _fType;
    private String _fieldName;
    private Object _default;
    private boolean _readonly;
    private boolean _transient;
    private String _comparator;
    private HashMap _reflectServices;
    private ReflectService _defaultReflectService;
    private SQLRelationLoader _manyToManyLoader;
    private static final CollectionInfo[] INFO = new CollectionInfo[]{new CollectionInfo("collection", Collection.class), new CollectionInfo("vector", Vector.class), new CollectionInfo("arraylist", ArrayList.class), new CollectionInfo("hashtable", Hashtable.class), new CollectionInfo("hashmap", HashMap.class), new CollectionInfo("set", Set.class), new CollectionInfo("hashset", HashSet.class), new CollectionInfo("map", Map.class), new CollectionInfo("array", Object[].class), new CollectionInfo("sortedset", SortedSet.class), new CollectionInfo("iterator", Iterator.class), new CollectionInfo("enumerate", Enumeration.class), new CollectionInfo("sortedmap", SortedMap.class)};

    public String toString() {
        return "FieldMolder for " + this._eMold.getName() + "." + this._fieldName + " of type " + this._fType;
    }

    public String getName() {
        return this._fieldName;
    }

    public String getComparator() {
        return this._comparator;
    }

    public short getFieldType() {
        if (!this.isPersistanceCapable()) {
            return this.isSerializable() ? (short)1 : 0;
        }
        if (!this.isMulti()) {
            return 2;
        }
        if (!this.isManyToMany()) {
            return 3;
        }
        return 4;
    }

    public SQLRelationLoader getRelationLoader() {
        return this._manyToManyLoader;
    }

    public boolean isStored() {
        return this._fMold == null || this._store;
    }

    public boolean isManyToMany() {
        return this._manyToManyLoader != null;
    }

    public boolean isDependent() {
        if (this._fMold == null) {
            return false;
        }
        ClassMolder depends = this._fMold.getDepends();
        for (ClassMolder extendPath = this._eMold; extendPath != null; extendPath = extendPath.getExtends()) {
            if (extendPath != depends) continue;
            return true;
        }
        return false;
    }

    public boolean isMulti() {
        return this._multi;
    }

    public boolean isPersistanceCapable() {
        return this._fMold != null;
    }

    public boolean isSerializable() {
        return this._serial;
    }

    public boolean isCheckDirty() {
        return this._check;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isAddable() {
        return this._addable;
    }

    public boolean isTransient() {
        return this._transient;
    }

    void setFieldClassMolder(ClassMolder fMold) {
        this._fMold = fMold;
    }

    public ClassMolder getEnclosingClassMolder() {
        return this._eMold;
    }

    public ClassMolder getFieldClassMolder() {
        return this._fMold;
    }

    public LockEngine getFieldLockEngine() {
        return this._fMold == null ? null : this._fMold.getLockEngine();
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public Class getCollectionType() {
        return this._colClass;
    }

    public Object getValue(Object object, ClassLoader loader) {
        Object internalObject = object;
        ReflectService rf = this.getContextReflectService(loader);
        try {
            if (rf._field != null) {
                return rf._field.get(internalObject);
            }
            if (rf._getMethod != null) {
                if (rf._getSequence != null) {
                    for (int i = 0; i < rf._getSequence.length && (internalObject = rf._getSequence[i].invoke(internalObject, (Object[])null)) != null; ++i) {
                    }
                }
                if (internalObject == null || rf._hasMethod != null && !((Boolean)rf._hasMethod.invoke(internalObject, (Object[])null)).booleanValue()) {
                    return null;
                }
                return rf._getMethod.invoke(internalObject, (Object[])null);
            }
            return null;
        }
        catch (IllegalAccessException except) {
            throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeNoAccess", (Object)this.toString()), except);
        }
        catch (InvocationTargetException except) {
            throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeInvocation", (Object)this.toString(), (Object)except), except);
        }
    }

    public void addValue(Object object, Object value, ClassLoader loader) {
        ReflectService rf = this.getContextReflectService(loader);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling " + rf._addMethod.getName() + " on " + object.getClass().getName() + " with value " + value));
        }
        try {
            if (rf._addMethod == null) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.addMethodNotDefined", (Object)this.getName()));
            }
            if (value == null) {
                throw new NullPointerException("Adding null value is not allowed");
            }
            rf._addMethod.invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new DataObjectAccessException("Argument ," + value + ", cannot be added!", e);
        }
        catch (IllegalAccessException e) {
            throw new DataObjectAccessException("Field access error", e);
        }
        catch (InvocationTargetException e) {
            throw new DataObjectAccessException("Field invocation error", e);
        }
    }

    public void setValue(Object object, Object value, ClassLoader loader) {
        block12: {
            Object internalObject = object;
            ReflectService rf = this.getContextReflectService(loader);
            try {
                if (rf._field != null) {
                    rf._field.set(internalObject, value == null ? this._default : value);
                    break block12;
                }
                if (rf._setMethod != null) {
                    if (rf._getSequence != null) {
                        for (int i = 0; i < rf._getSequence.length; ++i) {
                            Object last = internalObject;
                            internalObject = rf._getSequence[i].invoke(internalObject, (Object[])null);
                            if (internalObject != null) continue;
                            if (value == null || rf._setSequence[i] == null) break;
                            internalObject = Types.newInstance(rf._getSequence[i].getReturnType());
                            rf._setSequence[i].invoke(last, internalObject);
                        }
                    }
                    if (internalObject != null) {
                        if (value == null && rf._deleteMethod != null) {
                            rf._deleteMethod.invoke(internalObject, (Object[])null);
                        } else {
                            rf._setMethod.invoke(internalObject, value == null ? this._default : value);
                        }
                    }
                    break block12;
                }
                throw new DataObjectAccessException("no method to set value for field: " + this._fType + " in class: " + this._eMold);
            }
            catch (IllegalArgumentException except) {
                if (value == null) {
                    throw new DataObjectAccessException(Messages.format((String)"mapping.typeConversionNull", (Object)this.toString()));
                }
                throw new DataObjectAccessException(Messages.format((String)"mapping.typeConversion", (Object)this.toString(), (Object)value.getClass().getName()));
            }
            catch (IllegalAccessException except) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeNoAccess", (Object)this.toString()), except);
            }
            catch (InvocationTargetException except) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeInvocation", (Object)this.toString(), (Object)except.getMessage()), except);
            }
        }
    }

    public boolean isDefault(Object value) {
        if (this._default == value) {
            return true;
        }
        if (this._default == null) {
            return false;
        }
        return this._default.equals(value);
    }

    protected Class getCollectionType(String coll, boolean lazy) {
        for (int i = 0; i < INFO.length; ++i) {
            if (!INFO[i]._name.equals(coll)) continue;
            return INFO[i]._type;
        }
        return null;
    }

    public FieldMolder(DatingService ds, ClassMolder eMold, FieldMapping fieldMap, String manyTable, String[] idSQL, int[] idType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] relatedIdSQL, int[] relatedIdType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom) throws MappingException {
        this(ds, eMold, fieldMap);
        this._manyToManyLoader = new SQLRelationLoader(manyTable, idSQL, idType, idTo, idFrom, relatedIdSQL, relatedIdType, ridTo, ridFrom);
    }

    public FieldMolder(DatingService ds, ClassMolder eMold, FieldMapping fieldMap) throws MappingException {
        try {
            Class<?> javaClass;
            this._defaultReflectService = new ReflectService();
            this._reflectServices = new HashMap();
            this._eMold = eMold;
            this._lazy = fieldMap.getLazy();
            if (fieldMap.getSql() == null || fieldMap.getSql().getDirty() == null || !fieldMap.getSql().getDirty().equals(SqlDirtyType.IGNORE)) {
                this._check = true;
            }
            if (FIELD_TYPE_SERIALIZABLE.equals(fieldMap.getType())) {
                this._serial = true;
            }
            this._store = fieldMap.getSql() == null ? false : (fieldMap.getSql().getManyTable() != null ? false : fieldMap.getSql().getName().length != 0);
            if (fieldMap.getSql() != null) {
                this._readonly = fieldMap.getSql().getReadOnly();
            }
            if (fieldMap.getComparator() != null) {
                this._comparator = fieldMap.getComparator();
            }
            this._transient = fieldMap.getTransient();
            if (fieldMap.getSql() != null) {
                boolean isSQLTransient = fieldMap.getSql().getTransient();
                if (this._transient && !isSQLTransient) {
                    throw new MappingException(Messages.message((String)"persist.transient.conflict"));
                }
                this._transient = isSQLTransient;
            }
            if (fieldMap.getCollection() != null) {
                this._multi = true;
            }
            if (fieldMap.getCollection() != null) {
                if (COLLECTION_TYPE_ARRAY.equals(fieldMap.getCollection().toString())) {
                    String arrayClassName = "[L" + fieldMap.getType() + ";";
                    try {
                        this._colClass = ds.resolve(arrayClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MappingException("mapping.classNotFound", (Object)arrayClassName);
                    }
                } else {
                    this._colClass = this.getCollectionType(fieldMap.getCollection().toString(), this._lazy);
                    if (this._colClass != SortedSet.class && this._comparator != null) {
                        throw new MappingException(Messages.message((String)"mapping.wrong.use.of.comparator"));
                    }
                }
                this._store = false;
            }
            this._fType = fieldMap.getType();
            try {
                javaClass = ds.resolve(eMold.getName());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("mapping.classNotFound", (Object)eMold.getName());
            }
            this._defaultReflectService._loader = javaClass.getClassLoader();
            if (null != this._defaultReflectService._loader) {
                this._reflectServices.put(this._defaultReflectService._loader, this._defaultReflectService);
            }
            String fieldName = fieldMap.getName();
            String fieldType = fieldMap.getType();
            Class declaredClass = null;
            if (fieldType != null) {
                try {
                    declaredClass = Types.typeFromName((ClassLoader)javaClass.getClassLoader(), (String)fieldType);
                    this._defaultReflectService._fClass = declaredClass;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("mapping.classNotFound", (Object)declaredClass);
                }
            }
            if (fieldMap.getDirect()) {
                Class fieldClass = this._colClass != null ? this._colClass : null;
                this._defaultReflectService._field = this.findField(javaClass, fieldName, fieldClass);
                if (this._defaultReflectService._field == null) {
                    throw new MappingException(Messages.format((String)"mapping.fieldNotAccessible", (Object)fieldName, (Object)javaClass.getName()));
                }
                this._defaultReflectService._fClass = this._defaultReflectService._field.getType();
                if (this._defaultReflectService._field.getModifiers() != 1 && this._defaultReflectService._field.getModifiers() != 65) {
                    throw new MappingException(Messages.format((String)"mapping.fieldNotAccessible", (Object)this._defaultReflectService._field.getName(), (Object)this._defaultReflectService._field.getDeclaringClass().getName()));
                }
            } else if (fieldMap.getGetMethod() == null && fieldMap.getSetMethod() == null) {
                ArrayList<Method> getSeq = new ArrayList<Method>();
                ArrayList<Method> setSeq = new ArrayList<Method>();
                String name = fieldMap.getName();
                Method method = null;
                String methodName = null;
                try {
                    int point;
                    while ((point = name.indexOf(46)) >= 0) {
                        Class<?> last;
                        block77: {
                            last = javaClass;
                            if (fieldMap.getType().compareTo("boolean") == 0) {
                                try {
                                    methodName = METHOD_IS_PREFIX + this.capitalize(name.substring(0, point));
                                    method = javaClass.getMethod(methodName, null);
                                }
                                catch (NoSuchMethodException nsme) {
                                    if (!_log.isDebugEnabled()) break block77;
                                    _log.debug((Object)Messages.format((String)"mapping.accessorNotFound", methodName, (Object)"boolean", (Object)this.getName()));
                                }
                            }
                        }
                        if (method == null) {
                            methodName = METHOD_GET_PREFIX + this.capitalize(name.substring(0, point));
                            method = javaClass.getMethod(methodName, null);
                        }
                        name = name.substring(point + 1);
                        if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                            throw new MappingException("mapping.accessorNotAccessible", (Object)methodName, (Object)javaClass.getName());
                        }
                        getSeq.add(method);
                        javaClass = method.getReturnType();
                        methodName = fieldMap.getType().compareTo("boolean") == 0 ? "set" + methodName.substring(2) : "set" + methodName.substring(3);
                        try {
                            method = last.getMethod(methodName, javaClass);
                            if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                                method = null;
                            }
                        }
                        catch (Exception except) {
                            method = null;
                        }
                        setSeq.add(method);
                        method = null;
                    }
                }
                catch (Exception ex) {
                    throw new MappingException(Messages.format((String)"mapping.accessorNotFound", methodName, null, (Object)javaClass.getName()), ex);
                }
                if (getSeq.size() > 0) {
                    ReflectService.access$202(this._defaultReflectService, getSeq.toArray(new Method[getSeq.size()]));
                    ReflectService.access$602(this._defaultReflectService, setSeq.toArray(new Method[setSeq.size()]));
                }
                Class methodClass = this._colClass != null ? this._colClass : declaredClass;
                this._defaultReflectService._getMethod = null;
                if (fieldMap.getType() != null && fieldMap.getType().compareTo("boolean") == 0) {
                    this._defaultReflectService._getMethod = FieldMolder.findAccessor(javaClass, METHOD_IS_PREFIX + this.capitalize(name), methodClass, true);
                }
                if (this._defaultReflectService._getMethod == null) {
                    this._defaultReflectService._getMethod = FieldMolder.findAccessor(javaClass, METHOD_GET_PREFIX + this.capitalize(name), methodClass, true);
                }
                if (this._defaultReflectService._getMethod == null) {
                    if (fieldMap.getType().compareTo("boolean") == 0) {
                        throw new MappingException("mapping.accessorNotFound", (Object)("get/is" + this.capitalize(name)), (Object)fieldMap.getType(), (Object)eMold.getName());
                    }
                    throw new MappingException("mapping.accessorNotFound", (Object)(METHOD_GET_PREFIX + this.capitalize(name)), (Object)fieldMap.getType(), (Object)eMold.getName());
                }
                if (this._colClass == null) {
                    this._defaultReflectService._fClass = this._defaultReflectService._getMethod.getReturnType();
                }
                this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, "set" + this.capitalize(name), methodClass, false);
                if (this._defaultReflectService._setMethod == null) {
                    this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, METHOD_ADD_PREFIX + this.capitalize(name), declaredClass, false);
                    if (this._defaultReflectService._addMethod == null && name.endsWith("s")) {
                        this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, METHOD_ADD_PREFIX + this.capitalize(name).substring(0, name.length() - 1), declaredClass, false);
                    }
                    if (this._defaultReflectService._addMethod != null) {
                        this._addable = true;
                    }
                }
                if (this._defaultReflectService._setMethod == null && this._defaultReflectService._addMethod == null) {
                    throw new MappingException("mapping.accessorNotFound", (Object)("set/add" + this.capitalize(name)), (Object)declaredClass, (Object)javaClass.getName());
                }
            } else {
                Class methodClass = this._defaultReflectService._fClass;
                if (fieldMap.getGetMethod() != null) {
                    if (this._colClass != null) {
                        this._defaultReflectService._getMethod = FieldMolder.findAccessor(javaClass, fieldMap.getGetMethod(), this._colClass, true);
                    } else {
                        this._defaultReflectService._getMethod = FieldMolder.findAccessor(javaClass, fieldMap.getGetMethod(), methodClass, true);
                    }
                    if (this._defaultReflectService._getMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", (Object)fieldMap.getGetMethod(), (Object)methodClass, (Object)javaClass.getName());
                    }
                    if (this._colClass == null) {
                        this._defaultReflectService._fClass = this._defaultReflectService._getMethod.getReturnType();
                    }
                } else {
                    throw new MappingException("mapping.getMethodMappingNotFound", (Object)(this._colClass != null ? this._colClass : methodClass), (Object)javaClass.getName());
                }
                if (fieldMap.getSetMethod() != null) {
                    if (this._colClass != null) {
                        this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), this._colClass, false);
                        if (this._defaultReflectService._setMethod == null && !fieldMap.getLazy()) {
                            this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), declaredClass, false);
                            if (this._defaultReflectService._addMethod != null) {
                                this._addable = true;
                            }
                        }
                    } else {
                        this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), methodClass, false);
                    }
                    if (this._defaultReflectService._setMethod == null && this._defaultReflectService._addMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", (Object)fieldMap.getSetMethod(), (Object)methodClass, (Object)javaClass.getName());
                    }
                    if (this._defaultReflectService._fClass == null) {
                        this._defaultReflectService._fClass = this._defaultReflectService._setMethod.getParameterTypes()[0];
                    }
                } else {
                    throw new MappingException("mapping.setMethodMappingNotFound", (Object)(this._colClass != null ? this._colClass : methodClass), (Object)javaClass.getName());
                }
            }
            if (fieldMap.getCreateMethod() != null) {
                try {
                    this._defaultReflectService._createMethod = javaClass.getMethod(fieldMap.getCreateMethod(), null);
                }
                catch (Exception except) {
                    throw new MappingException("mapping.createMethodNotFound", (Object)fieldMap.getCreateMethod(), (Object)javaClass.getName());
                }
            }
            if (fieldMap.getName() != null && !Types.isSimpleType((Class)this._defaultReflectService._fClass)) {
                try {
                    Method method = javaClass.getMethod(METHOD_CREATE_PREFIX + this.capitalize(fieldMap.getName()), null);
                    this._defaultReflectService._createMethod = method;
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
            if (fieldMap.getName() != null) {
                Method hasMethod = null;
                Method deleteMethod = null;
                try {
                    hasMethod = javaClass.getMethod(METHOD_HAS_PREFIX + this.capitalize(fieldMap.getName()), null);
                    if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                        hasMethod = null;
                    }
                    try {
                        if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                            deleteMethod = null;
                        }
                        deleteMethod = javaClass.getMethod(METHOD_DELETE_PREFIX + this.capitalize(fieldMap.getName()), null);
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    this._defaultReflectService._hasMethod = hasMethod;
                    this._defaultReflectService._deleteMethod = deleteMethod;
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
            if (this._defaultReflectService._field == null && this._defaultReflectService._setMethod == null && this._defaultReflectService._getMethod == null) {
                throw new MappingException("_field or _setMethod can't be created");
            }
            ds.pairFieldClass(this, this._fType);
        }
        catch (NullPointerException e) {
            _log.fatal((Object)"Caught unexpected NullPointerException: ", (Throwable)e);
            throw new MappingException("Unexpected Null pointer!\n" + e);
        }
        this._fieldName = fieldMap.getName();
        this._default = Types.getDefault((Class)this._defaultReflectService._fClass);
        if (!this._defaultReflectService._fClass.isPrimitive()) {
            this._default = null;
        }
    }

    private Field findField(Class javaClass, String fieldName, Class fieldType) throws MappingException {
        Class internalFieldType = fieldType;
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", (Object)fieldName, (Object)javaClass.getName());
            }
            if (internalFieldType == null) {
                internalFieldType = Types.typeFromPrimitive(field.getType());
            } else if (Types.typeFromPrimitive((Class)internalFieldType) != Types.typeFromPrimitive(field.getType())) {
                throw new MappingException("mapping.fieldTypeMismatch", (Object)field, (Object)internalFieldType.getName());
            }
            return field;
        }
        catch (NoSuchFieldException except) {
        }
        catch (SecurityException except) {
            // empty catch block
        }
        return null;
    }

    public static final Method findAccessor(Class javaClass, String methodName, Class fieldType, boolean getMethod) throws MappingException {
        try {
            Method method = null;
            if (getMethod) {
                method = javaClass.getMethod(methodName, new Class[0]);
                if (javaClass == MapItem.class) {
                    if (methodName.equals("getKey")) {
                        return method;
                    }
                    if (methodName.equals("getValue")) {
                        return method;
                    }
                }
                if (fieldType == null) {
                    fieldType = Types.typeFromPrimitive(method.getReturnType());
                } else {
                    fieldType = Types.typeFromPrimitive((Class)fieldType);
                    Class returnType = Types.typeFromPrimitive(method.getReturnType());
                    if (fieldType.isInterface() || (fieldType.getModifiers() & 0x400) != 0 || fieldType == Serializable.class ? !fieldType.isAssignableFrom(returnType) : !returnType.isAssignableFrom(fieldType)) {
                        throw new MappingException("mapping.accessorReturnTypeMismatch", (Object)method, (Object)fieldType.getName());
                    }
                }
            } else {
                Class fieldTypePrimitive = null;
                if (fieldType != null) {
                    fieldTypePrimitive = Types.typeFromPrimitive((Class)fieldType);
                    try {
                        method = javaClass.getMethod(methodName, fieldTypePrimitive);
                    }
                    catch (Exception ex) {
                        try {
                            method = javaClass.getMethod(methodName, fieldType);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
                if (method == null) {
                    Method[] methods = javaClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] paramTypes;
                        if (!methods[i].getName().equals(methodName) || (paramTypes = methods[i].getParameterTypes()).length != 1) continue;
                        Class paramType = Types.typeFromPrimitive(paramTypes[0]);
                        if (fieldType == null) {
                            method = methods[i];
                            break;
                        }
                        if (paramType.isAssignableFrom(fieldTypePrimitive)) {
                            method = methods[i];
                            break;
                        }
                        if (!fieldType.isInterface() && !FieldMolder.isAbstract(fieldType) || !fieldTypePrimitive.isAssignableFrom(paramType)) continue;
                        method = methods[i];
                        break;
                    }
                    if (method == null) {
                        return null;
                    }
                }
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", (Object)methodName, (Object)javaClass.getName());
            }
            return method;
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static boolean isAbstract(Class cls) {
        return (cls.getModifiers() & 0x400) != 0;
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    private ReflectService getContextReflectService(ClassLoader loader) {
        if (null == loader || this._defaultReflectService._loader == loader) {
            return this._defaultReflectService;
        }
        ReflectService resultReflectService = (ReflectService)this._reflectServices.get(loader);
        if (null == resultReflectService) {
            resultReflectService = new ReflectService(this._defaultReflectService, loader);
        }
        return resultReflectService;
    }

    private class ReflectService {
        private ClassLoader _loader;
        private Class _fClass;
        private Field _field;
        private Method[] _getSequence;
        private Method[] _setSequence;
        private Method _getMethod;
        private Method _setMethod;
        private Method _addMethod;
        private Method _hasMethod;
        private Method _deleteMethod;
        private Method _createMethod;

        ReflectService() {
        }

        ReflectService(ReflectService refSrv, ClassLoader loader) {
            this._loader = loader;
            this._fClass = this.cloneClass(refSrv._fClass);
            this._field = this.cloneField(refSrv._field);
            this._getSequence = this.cloneMethods(refSrv._getSequence);
            this._setSequence = this.cloneMethods(refSrv._setSequence);
            this._getMethod = this.cloneMethod(refSrv._getMethod);
            this._addMethod = this.cloneMethod(refSrv._addMethod);
            this._setMethod = this.cloneMethod(refSrv._setMethod);
            this._hasMethod = this.cloneMethod(refSrv._hasMethod);
            this._deleteMethod = this.cloneMethod(refSrv._deleteMethod);
            this._createMethod = this.cloneMethod(refSrv._createMethod);
        }

        private Field cloneField(Field originalField) {
            if (null == originalField) {
                return null;
            }
            Field resultField = null;
            try {
                resultField = originalField.getDeclaringClass().getField(originalField.getName());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return resultField;
        }

        private Method cloneMethod(Method originalMethod) {
            if (null == originalMethod) {
                return null;
            }
            Method resultMethod = null;
            try {
                Class newCls = this.loadClass(originalMethod.getDeclaringClass().getName());
                String methodName = originalMethod.getName();
                Class<?>[] methodParams = originalMethod.getParameterTypes();
                for (int i = 0; i < methodParams.length; ++i) {
                    if (methodParams[i].isPrimitive()) continue;
                    methodParams[i] = this.loadClass(methodParams[i].getName());
                }
                resultMethod = newCls.getMethod(methodName, methodParams);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return resultMethod;
        }

        private Method[] cloneMethods(Method[] originalMethods) {
            if (null == originalMethods) {
                return null;
            }
            Method[] resultMethods = new Method[originalMethods.length];
            for (int i = 0; i < originalMethods.length; ++i) {
                resultMethods[i] = this.cloneMethod(originalMethods[i]);
            }
            return resultMethods;
        }

        private Class cloneClass(Class originalClass) {
            if (null == originalClass) {
                return null;
            }
            if (originalClass.isPrimitive()) {
                return originalClass;
            }
            return this.loadClass(originalClass.getName());
        }

        private Class loadClass(String name) {
            Class resultClass = null;
            try {
                resultClass = ClassLoadingUtils.loadClass(this._loader, name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return resultClass;
        }

        static /* synthetic */ Method[] access$202(ReflectService x0, Method[] x1) {
            x0._getSequence = x1;
            return x1;
        }

        static /* synthetic */ Method[] access$602(ReflectService x0, Method[] x1) {
            x0._setSequence = x1;
            return x1;
        }
    }

    static class CollectionInfo {
        private String _name;
        private Class _type;

        CollectionInfo(String name, Class type) {
            this._name = name;
            this._type = type;
        }
    }
}

