/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;
import org.castor.cache.CacheFactoryRegistry;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.engine.ConnectionFactory;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.cache.CacheEntry;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;

public final class LockEngine {
    private static Log _log = LogFactory.getFactory().getInstance(LockEngine.class);
    private static CacheFactoryRegistry _cacheFactoryRegistry;
    private HashMap _typeInfo = new HashMap();
    private HashMap _xaTx = new HashMap();
    private ConnectionFactory _connectionFactory;
    private PersistenceFactory _persistenceFactory;

    public LockEngine(ConnectionFactory connectionFactory, ClassDescriptorResolver cdResolver, PersistenceFactory persistenceFactory) throws MappingException {
        if (_cacheFactoryRegistry == null) {
            AbstractProperties properties = CPAProperties.getInstance();
            _cacheFactoryRegistry = new CacheFactoryRegistry(properties);
        }
        this._connectionFactory = connectionFactory;
        this._persistenceFactory = persistenceFactory;
        try {
            Vector v = ClassMolderHelper.resolve(cdResolver, this, this._persistenceFactory);
            this._typeInfo = new HashMap();
            Enumeration enumeration = v.elements();
            HashSet<ClassMolder> processedClasses = new HashSet<ClassMolder>();
            HashSet freshClasses = new HashSet();
            while (enumeration.hasMoreElements()) {
                freshClasses.add(enumeration.nextElement());
            }
            int counter = 0;
            do {
                counter = freshClasses.size();
                Iterator itor = freshClasses.iterator();
                while (itor.hasNext()) {
                    ClassMolder molder = (ClassMolder)itor.next();
                    ClassMolder extend = molder.getExtends();
                    if (extend == null) {
                        Cache cache = null;
                        try {
                            cache = _cacheFactoryRegistry.getCache(molder.getCacheParams(), cdResolver.getMappingLoader().getClassLoader());
                        }
                        catch (CacheAcquireException e) {
                            String msg = Messages.message((String)"persist.cacheCreationFailed");
                            _log.error((Object)msg, (Throwable)e);
                            throw new MappingException(msg, (Exception)e);
                        }
                        TypeInfo info = new TypeInfo(molder, new HashMap(), cache);
                        this._typeInfo.put(molder.getName(), info);
                        itor.remove();
                        processedClasses.add(molder);
                        continue;
                    }
                    if (!processedClasses.contains(molder.getExtends())) continue;
                    TypeInfo baseInfo = (TypeInfo)this._typeInfo.get(extend.getName());
                    this._typeInfo.put(molder.getName(), new TypeInfo(molder, baseInfo));
                    itor.remove();
                    processedClasses.add(molder);
                }
            } while (freshClasses.size() > 0 && counter != freshClasses.size());
            if (freshClasses.size() > 0) {
                for (ClassMolder molder : freshClasses) {
                    _log.error((Object)("The base class, " + molder.getExtends().getName() + ", of the extends class ," + molder.getName() + " can not be resolved! "));
                }
                throw new MappingException("Some base class can not be resolved!");
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Declared Class not found!");
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public ClassMolder getClassMolder(Class cls) {
        TypeInfo info = (TypeInfo)this._typeInfo.get(cls.getName());
        if (info != null && !info._molder.isDependent()) {
            return info._molder;
        }
        return null;
    }

    public ClassMolder getClassMolderWithDependent(Class cls) {
        TypeInfo info = (TypeInfo)this._typeInfo.get(cls.getName());
        return info != null ? info._molder : null;
    }

    public ClassMolder getClassMolderByQuery(String name) {
        for (TypeInfo info : this._typeInfo.values()) {
            if (info._molder.getNamedQuery(name) == null) continue;
            return info._molder;
        }
        return null;
    }

    public Persistence getPersistence(Class cls) {
        ClassMolder molder = this.getClassMolder(cls);
        if (molder != null) {
            return molder.getPersistence();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OID load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode, int timeout, QueryResults results) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getName()));
        }
        ClassMolder molder = oid.getMolder();
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            try {
                short action = accessMode == AccessMode.Exclusive || accessMode == AccessMode.DbLocked ? (short)2 : 1;
                lock = typeInfo.acquire(oid, tx, action, timeout);
                typeInfo._molder.load(tx, lock, proposedObject, suggestedAccessMode, results);
                if (proposedObject.isExpanded()) {
                    typeInfo.release(oid, tx);
                } else {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)Messages.format((String)"jdo.loading.with.id", (Object)typeInfo._molder.getName(), (Object)oid.getIdentity()));
                    }
                    succeed = true;
                }
                OID oID = lock.getOID();
                Object var15_16 = null;
                if (lock == null) return oID;
                lock.confirm(tx, succeed);
                return oID;
            }
            catch (ObjectDeletedWaitingForLockException except) {
                throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)oid.getName(), (Object)oid.getIdentity()), (Throwable)((Object)except));
            }
            catch (LockNotGrantedException e) {
                if (lock == null) throw e;
                lock.release(tx);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (lock == null) throw throwable;
            lock.confirm(tx, succeed);
            throw throwable;
        }
    }

    public void markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getName()));
        }
        typeInfo._molder.markCreate(tx, oid, null, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OID create(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        OID internaloid = oid;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)object.getClass().getName()));
        }
        ObjectLock lock = null;
        if (internaloid.getIdentity() != null) {
            lock = null;
            boolean succeed = false;
            try {
                try {
                    lock = typeInfo.acquire(internaloid, tx, (short)3, 0);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)Messages.format((String)"jdo.creating.with.id", (Object)typeInfo._molder.getName(), (Object)internaloid.getIdentity()));
                    }
                    internaloid = lock.getOID();
                    typeInfo._molder.create(tx, internaloid, lock, object);
                    succeed = true;
                    internaloid.setDbLock(true);
                    OID oID = internaloid;
                    Object var11_14 = null;
                    if (lock == null) return oID;
                    lock.confirm(tx, succeed);
                    return oID;
                }
                catch (LockNotGrantedException except) {
                    throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)object.getClass().getName(), (Object)internaloid.getIdentity()), (Throwable)((Object)except));
                }
                catch (DuplicateIdentityException except) {
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (lock == null) throw throwable;
                lock.confirm(tx, succeed);
                throw throwable;
            }
        }
        boolean succeed = false;
        try {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)Messages.format((String)"jdo.creating.with.id", (Object)typeInfo._molder.getName(), (Object)internaloid.getIdentity()));
                }
                lock = typeInfo.acquire(internaloid, tx, (short)3, 0);
                internaloid = lock.getOID();
                Identity newids = typeInfo._molder.create(tx, internaloid, lock, object);
                succeed = true;
                internaloid.setDbLock(true);
                OID newoid = new OID(internaloid.getMolder(), internaloid.getDepends(), newids);
                typeInfo.rename(internaloid, newoid, tx);
                OID oID = newoid;
                Object var13_19 = null;
                if (lock == null) return oID;
                lock.confirm(tx, succeed);
                return oID;
            }
            catch (LockNotGrantedException e) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)"Key Generator Failure. Duplicated Identity is generated!"));
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (lock == null) throw throwable;
            lock.confirm(tx, succeed);
            throw throwable;
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            typeInfo.assure(oid, tx, true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.removing", (Object)typeInfo._molder.getName(), (Object)oid.getIdentity()));
            }
            typeInfo._molder.delete(tx, oid);
        }
        catch (LockNotGrantedException except) {
            throw new IllegalStateException(Messages.format((String)"persist.internal", (Object)"Attempt to delete object for which no lock was acquired"));
        }
    }

    public void markDelete(TransactionContext tx, OID oid, Object object, int timeout) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.upgrade(oid, tx, timeout);
        typeInfo._molder.markDelete(tx, oid, lock, object);
        lock.expire();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, int timeout) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        OID internaloid = oid;
        try {
            try {
                if (!(typeInfo.isLocked(internaloid) || typeInfo.isCached(internaloid) || typeInfo._molder.isDependent() || internaloid.getIdentity() == null)) {
                    lock = typeInfo.acquire(internaloid, tx, (short)4, timeout);
                    internaloid = lock.getOID();
                    try {
                        typeInfo._molder.loadTimeStamp(tx, lock, suggestedAccessMode);
                    }
                    catch (PersistenceException ex) {}
                } else {
                    lock = typeInfo.acquire(internaloid, tx, (short)4, timeout);
                    internaloid = lock.getOID();
                }
                succeed = !typeInfo._molder.update(tx, internaloid, lock, object, suggestedAccessMode);
                boolean ex = !succeed;
                Object var12_14 = null;
                if (lock == null) return ex;
                lock.confirm(tx, succeed);
                return ex;
            }
            catch (ObjectModifiedException e) {
                throw e;
            }
            catch (ObjectDeletedWaitingForLockException except) {
                throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)internaloid.getName(), (Object)internaloid.getIdentity()), (Throwable)((Object)except));
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (lock == null) throw throwable;
            lock.confirm(tx, succeed);
            throw throwable;
        }
    }

    public OID preStore(TransactionContext tx, OID oid, Object object, int timeout) throws PersistenceException {
        boolean modified;
        OID internaloid = oid;
        ObjectLock lock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        internaloid = new OID(typeInfo._molder, internaloid.getIdentity());
        try {
            lock = typeInfo.assure(internaloid, tx, false);
            internaloid = lock.getOID();
            modified = typeInfo._molder.preStore(tx, internaloid, lock, object, timeout);
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (ObjectDeletedException e) {
            lock.delete(tx);
            throw e;
        }
        if (modified) {
            return internaloid;
        }
        return null;
    }

    public void store(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        ObjectLock lock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            lock = typeInfo.assure(oid, tx, false);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.storing.with.id", (Object)typeInfo._molder.getName(), (Object)oid.getIdentity()));
            }
            typeInfo._molder.store(tx, oid, lock, object);
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (DuplicateIdentityException e) {
            throw e;
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (PersistenceException e) {
            lock.invalidate(tx);
            throw e;
        }
    }

    public void writeLock(TransactionContext tx, OID oid, int timeout) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            typeInfo.upgrade(oid, tx, timeout);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ObjectDeletedWaitingForLockException e) {
            throw new IllegalStateException("Object deleted waiting for lock?????????");
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
    }

    public void softLock(TransactionContext tx, OID oid, int timeout) throws LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        typeInfo.upgrade(oid, tx, timeout);
    }

    public void revertObject(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        try {
            ObjectLock lock = typeInfo.assure(oid, tx, false);
            typeInfo._molder.revertObject(tx, oid, lock, object);
        }
        catch (LockNotGrantedException e) {
            throw new IllegalStateException("Write Lock expected!");
        }
        catch (PersistenceException except) {
            throw except;
        }
    }

    public void updateCache(TransactionContext tx, OID oid, Object object) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.assure(oid, tx, true);
        typeInfo._molder.updateCache(tx, oid, lock, object);
    }

    public void releaseLock(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        ObjectLock lock = typeInfo.release(oid, tx);
        lock.getOID().setDbLock(false);
    }

    public void forgetObject(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        typeInfo.assure(oid, tx, true);
        typeInfo.delete(oid, tx);
        typeInfo.release(oid, tx);
    }

    public boolean expireCache(TransactionContext tx, OID oid, int timeout) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oid.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            block9: {
                try {
                    if (!typeInfo.isCached(oid)) break block9;
                    lock = typeInfo.acquire(oid, tx, (short)2, timeout);
                    typeInfo._molder.expireCache(tx, lock);
                    lock.expire();
                    succeed = true;
                }
                catch (LockNotGrantedException e) {
                    throw e;
                }
                catch (ObjectDeletedException e) {
                    throw e;
                }
                catch (PersistenceException e) {
                    throw e;
                }
            }
            Object var9_7 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
            throw throwable;
        }
        return succeed;
    }

    public void expireCache(Class cls) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        if (typeInfo != null) {
            typeInfo.expireCache();
        }
    }

    public void expireCache() {
        Iterator iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).expireCache();
        }
    }

    public void dumpCache() {
        Iterator iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).dumpCache();
        }
    }

    public void closeCaches() {
        Iterator iter = this._typeInfo.values().iterator();
        while (iter.hasNext()) {
            ((TypeInfo)iter.next()).closeCache();
        }
        Collection<CacheFactory> cacheFactories = _cacheFactoryRegistry.getCacheFactories();
        Iterator<CacheFactory> iter2 = cacheFactories.iterator();
        while (iter2.hasNext()) {
            iter2.next().shutdown();
        }
    }

    public void dumpCache(Class cls) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        if (typeInfo != null) {
            typeInfo.dumpCache();
        }
    }

    public HashMap getXATransactions() {
        return this._xaTx;
    }

    public boolean isCached(Class cls, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        return typeInfo.isCached(oid);
    }

    public boolean isLocked(Class cls, OID oid) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(cls.getName());
        return typeInfo.isLocked(oid);
    }

    private final class TypeInfo {
        private final ClassMolder _molder;
        private final String _name;
        private final HashMap _locks;
        private final Cache _cache;

        private TypeInfo(ClassMolder molder, HashMap locks, Cache cache) {
            this._name = molder.getName();
            this._molder = molder;
            this._locks = locks;
            this._cache = cache;
        }

        private TypeInfo(ClassMolder molder, TypeInfo base) {
            this(molder, base._locks, base._cache);
        }

        public void closeCache() {
            this._cache.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpCache() {
            _log.info((Object)(this._name + ".dumpCache()..."));
            HashMap hashMap = this._locks;
            synchronized (hashMap) {
                for (ObjectLock entry : this._locks.values()) {
                    _log.info((Object)("In locks: " + entry));
                }
                for (ObjectLock entry : this._cache.values()) {
                    _log.info((Object)("In cache: " + entry.getOID()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expireCache() {
            HashMap hashMap = this._locks;
            synchronized (hashMap) {
                Iterator iter = this._locks.values().iterator();
                while (iter.hasNext()) {
                    ObjectLock objectLock = (ObjectLock)iter.next();
                    objectLock.expire();
                    iter.remove();
                }
                this._cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock acquire(OID oid, TransactionContext tx, short lockAction, int timeout) throws LockNotGrantedException {
            HashMap hashMap;
            ObjectLock objectLock;
            OID internaloid = oid;
            ObjectLock entry = null;
            HashMap hashMap2 = this._locks;
            synchronized (hashMap2) {
                entry = (ObjectLock)this._locks.get(internaloid);
                if (entry == null) {
                    CacheEntry cachedEntry = (CacheEntry)this._cache.remove(internaloid);
                    if (cachedEntry != null) {
                        OID cacheOid = cachedEntry.getOID();
                        if (internaloid.getName().equals(cacheOid.getName())) {
                            entry = new ObjectLock(cachedEntry.getOID(), cachedEntry.getEntry(), cachedEntry.getTimeStamp());
                            entry.setOID(internaloid);
                        } else {
                            entry = new ObjectLock(internaloid);
                        }
                    } else {
                        entry = new ObjectLock(internaloid);
                    }
                    this._locks.put(internaloid, entry);
                }
                entry.enter();
            }
            boolean failed = true;
            try {
                switch (lockAction) {
                    case 1: {
                        entry.acquireLoadLock(tx, false, timeout);
                        break;
                    }
                    case 2: {
                        entry.acquireLoadLock(tx, true, timeout);
                        break;
                    }
                    case 3: {
                        entry.acquireCreateLock(tx);
                        break;
                    }
                    case 4: {
                        entry.acquireUpdateLock(tx, timeout);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("lockType " + lockAction + " is undefined!");
                    }
                }
                failed = false;
                objectLock = entry;
                Object var12_12 = null;
                hashMap = this._locks;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                HashMap hashMap3 = this._locks;
                synchronized (hashMap3) {
                    entry.leave();
                    if (failed && entry.isDisposable()) {
                        this._locks.remove(internaloid);
                        if (entry.isExpired()) {
                            this._cache.expire(internaloid);
                            entry.expired();
                        } else {
                            this._cache.put(internaloid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                        }
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (failed && entry.isDisposable()) {
                    this._locks.remove(internaloid);
                    if (entry.isExpired()) {
                        this._cache.expire(internaloid);
                        entry.expired();
                    } else {
                        this._cache.put(internaloid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                    }
                }
            }
            return objectLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock upgrade(OID oid, TransactionContext tx, int timeout) throws LockNotGrantedException {
            HashMap hashMap;
            OID internaloid = oid;
            ObjectLock entry = null;
            Object object = this._locks;
            synchronized (object) {
                entry = (ObjectLock)this._locks.get(internaloid);
                if (entry == null) {
                    throw new ObjectDeletedWaitingForLockException("Lock entry not found. Deleted?");
                }
                if (!entry.hasLock(tx, false)) {
                    throw new IllegalStateException("Transaction does not hold the any lock on " + internaloid + "!");
                }
                internaloid = entry.getOID();
                entry.enter();
            }
            try {
                entry.upgrade(tx, timeout);
                object = entry;
                Object var9_8 = null;
                hashMap = this._locks;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                HashMap hashMap2 = this._locks;
                synchronized (hashMap2) {
                    entry.leave();
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock assure(OID oid, TransactionContext tx, boolean write) {
            HashMap hashMap = this._locks;
            synchronized (hashMap) {
                ObjectLock entry = (ObjectLock)this._locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("Lock, " + oid + ", doesn't exist or no lock!");
                }
                if (!entry.hasLock(tx, write)) {
                    throw new IllegalStateException("Transaction " + tx + " does not hold the " + (write ? "write" : "read") + " lock: " + entry + "!");
                }
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock rename(OID orgoid, OID newoid, TransactionContext tx) throws LockNotGrantedException {
            HashMap hashMap = this._locks;
            synchronized (hashMap) {
                ObjectLock entry = (ObjectLock)this._locks.get(orgoid);
                ObjectLock newentry = (ObjectLock)this._locks.get(newoid);
                if (orgoid == newoid) {
                    throw new LockNotGrantedException("Locks are the same");
                }
                if (entry == null) {
                    throw new LockNotGrantedException("Lock doesn't exist!");
                }
                if (!entry.isExclusivelyOwned(tx)) {
                    throw new LockNotGrantedException("Lock to be renamed is not own exclusively by transaction!");
                }
                if (entry.isEntered()) {
                    throw new LockNotGrantedException("Lock to be renamed is acquired by another transaction!");
                }
                if (newentry != null) {
                    throw new LockNotGrantedException("Lock is already existed for the new oid.");
                }
                entry = (ObjectLock)this._locks.remove(orgoid);
                entry.setOID(newoid);
                this._locks.put(newoid, entry);
                newoid.setDbLock(orgoid.isDbLock());
                return newentry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock delete(OID oid, TransactionContext tx) {
            HashMap hashMap;
            ObjectLock entry;
            Object object = this._locks;
            synchronized (object) {
                entry = (ObjectLock)this._locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("No lock to destroy!");
                }
                entry.enter();
            }
            try {
                entry.delete(tx);
                object = entry;
                Object var7_6 = null;
                hashMap = this._locks;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                HashMap hashMap2 = this._locks;
                synchronized (hashMap2) {
                    entry.leave();
                    if (entry.isDisposable()) {
                        this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                        this._locks.remove(oid);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (entry.isDisposable()) {
                    this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                    this._locks.remove(oid);
                }
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLock release(OID oid, TransactionContext tx) {
            HashMap hashMap;
            ObjectLock entry = null;
            Object object = this._locks;
            synchronized (object) {
                entry = (ObjectLock)this._locks.get(oid);
                if (entry == null) {
                    throw new IllegalStateException("No lock to release! " + oid + " for transaction " + tx);
                }
                entry.enter();
            }
            try {
                entry.release(tx);
                object = entry;
                Object var7_6 = null;
                hashMap = this._locks;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                HashMap hashMap2 = this._locks;
                synchronized (hashMap2) {
                    entry.leave();
                    if (entry.isDisposable()) {
                        this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                        if (entry.isExpired()) {
                            this._cache.expire(oid);
                            entry.expired();
                        }
                        this._locks.remove(oid);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                entry.leave();
                if (entry.isDisposable()) {
                    this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getTimeStamp()));
                    if (entry.isExpired()) {
                        this._cache.expire(oid);
                        entry.expired();
                    }
                    this._locks.remove(oid);
                }
            }
            return object;
        }

        public boolean isCached(OID oid) {
            return this._cache.containsKey(oid);
        }

        public boolean isLocked(OID oid) {
            return this._locks.containsKey(oid);
        }
    }
}

