/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.jdo.util.JDOUtils;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.persist.spi.Identity;

public class SQLRelationLoader {
    private String _tableName;
    private int[] _leftType;
    private TypeConvertor[] _leftFrom;
    private TypeConvertor[] _rightFrom;
    private int[] _rightType;
    private String[] _left;
    private String[] _right;
    private String _select;
    private String _insert;
    private String _delete;
    private String _deleteAll;

    public SQLRelationLoader(String table, String[] key, int[] keyType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] otherKey, int[] otherKeyType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom) {
        int i;
        this._leftFrom = idFrom;
        this._rightFrom = ridFrom;
        this._tableName = table;
        this._left = key;
        this._right = otherKey;
        this._leftType = keyType;
        this._rightType = otherKeyType;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        sb.append("SELECT ");
        for (i = 0; i < this._left.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this._left[i]);
            ++count;
        }
        for (i = 0; i < this._right.length; ++i) {
            sb.append(",");
            sb.append(this._right[i]);
            ++count;
        }
        sb.append(" FROM ");
        sb.append(this._tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this._left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this._left[i]);
            sb.append("=?");
        }
        for (i = 0; i < this._right.length; ++i) {
            sb.append(" AND ");
            sb.append(this._right[i]);
            sb.append("=?");
        }
        this._select = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("INSERT INTO ");
        sb.append(this._tableName);
        sb.append(" (");
        for (i = 0; i < this._left.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this._left[i]);
            ++count;
        }
        for (i = 0; i < this._right.length; ++i) {
            sb.append(",");
            sb.append(this._right[i]);
            ++count;
        }
        sb.append(") VALUES (");
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        this._insert = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this._tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this._left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this._left[i]);
            sb.append("=?");
        }
        for (i = 0; i < this._right.length; ++i) {
            sb.append(" AND ");
            sb.append(this._right[i]);
            sb.append("=?");
        }
        this._delete = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this._tableName);
        sb.append(" WHERE ");
        for (i = 0; i < this._left.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this._left[i]);
            sb.append("=?");
        }
        this._deleteAll = sb.toString();
    }

    private Object idToSQL(int index, Object object) {
        if (object == null || this._leftFrom[index] == null) {
            return object;
        }
        return this._leftFrom[index].convert(object);
    }

    private Object ridToSQL(int index, Object object) {
        if (object == null || this._rightFrom[index] == null) {
            return object;
        }
        return this._rightFrom[index].convert(object);
    }

    public void createRelation(Connection conn, Identity left, Identity right) throws PersistenceException {
        ResultSet rset = null;
        PreparedStatement selectStatement = null;
        PreparedStatement insertStatement = null;
        try {
            int i;
            int count = 1;
            selectStatement = conn.prepareStatement(this._select);
            for (i = 0; i < left.size(); ++i) {
                selectStatement.setObject(count, this.idToSQL(i, left.get(i)), this._leftType[i]);
                ++count;
            }
            for (i = 0; i < right.size(); ++i) {
                selectStatement.setObject(count, this.ridToSQL(i, right.get(i)), this._rightType[i]);
                ++count;
            }
            rset = selectStatement.executeQuery();
            count = 1;
            insertStatement = conn.prepareStatement(this._insert);
            if (!rset.next()) {
                for (i = 0; i < left.size(); ++i) {
                    insertStatement.setObject(count, this.idToSQL(i, left.get(i)), this._leftType[i]);
                    ++count;
                }
                for (i = 0; i < right.size(); ++i) {
                    insertStatement.setObject(count, this.ridToSQL(i, right.get(i)), this._rightType[i]);
                    ++count;
                }
                insertStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeResultSet(rset);
                JDOUtils.closeStatement(selectStatement);
                JDOUtils.closeStatement(insertStatement);
                throw throwable;
            }
        }
        JDOUtils.closeResultSet(rset);
        JDOUtils.closeStatement(selectStatement);
        JDOUtils.closeStatement(insertStatement);
    }

    public void deleteRelation(Connection conn, Identity left) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            int count = 1;
            stmt = conn.prepareStatement(this._deleteAll);
            for (int i = 0; i < left.size(); ++i) {
                stmt.setObject(count, this.idToSQL(i, left.get(i)), this._leftType[i]);
                ++count;
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeStatement(stmt);
    }

    public void deleteRelation(Connection conn, Identity left, Identity right) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            int i;
            int count = 1;
            stmt = conn.prepareStatement(this._delete);
            for (i = 0; i < left.size(); ++i) {
                stmt.setObject(count, this.idToSQL(i, left.get(i)), this._leftType[i]);
                ++count;
            }
            for (i = 0; i < right.size(); ++i) {
                stmt.setObject(count, this.ridToSQL(i, right.get(i)), this._rightType[i]);
                ++count;
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            catch (Throwable throwable) {
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeStatement(stmt);
    }
}

