/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

public final class JcsCache
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog(JcsCache.class);
    public static final String TYPE = "jcs";
    public static final String IMPLEMENTATION = "org.apache.jcs.JCS";
    private static final Class[] TYPES_GET_INSTANCE = new Class[]{String.class};
    private static final Class[] TYPES_GET = new Class[]{Object.class};
    private static final Class[] TYPES_PUT = new Class[]{Object.class, Object.class};
    private static final Class[] TYPES_REMOVE = TYPES_GET;
    private Object _cache;
    private Method _getMethod;
    private Method _putMethod;
    private Method _removeMethod;
    private Method _clearMethod;

    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        super.initialize(params);
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            Method method = cls.getMethod("getInstance", TYPES_GET_INSTANCE);
            this._cache = method.invoke(null, this.getName());
            cls = this._cache.getClass();
            this._getMethod = cls.getMethod("get", TYPES_GET);
            this._putMethod = cls.getMethod("put", TYPES_PUT);
            this._removeMethod = cls.getMethod("remove", TYPES_REMOVE);
            this._clearMethod = cls.getMethod("clear", null);
        }
        catch (Exception e) {
            String msg = "Error creating JCS cache: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public int size() {
        throw new UnsupportedOperationException("size()");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty()");
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue(Object)");
    }

    public Object get(Object key) {
        return this.invokeCacheMethod(this._getMethod, new Object[]{key});
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._putMethod, new Object[]{key, value});
        return oldValue;
    }

    public Object remove(Object key) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._removeMethod, new Object[]{key});
        return oldValue;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object[] params = new Object[]{entry.getKey(), entry.getValue()};
            this.invokeCacheMethod(this._putMethod, params);
        }
    }

    public void clear() {
        this.invokeCacheMethod(this._clearMethod, null);
    }

    public Set keySet() {
        throw new UnsupportedOperationException("keySet()");
    }

    public Collection values() {
        throw new UnsupportedOperationException("values()");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    private Object invokeCacheMethod(Method method, Object[] arguments) {
        try {
            return method.invoke(this._cache, arguments);
        }
        catch (Exception e) {
            String msg = "Failed to call method on JCS instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }
}

