/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.castor.cache.hashbelt.container.Container;

public final class WeakReferenceContainer
implements Container {
    private HashMap _container = new HashMap();
    private long _timestamp = 0L;

    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public synchronized Iterator keyIterator() {
        return new ArrayList(this.keySet()).iterator();
    }

    public Iterator valueIterator() {
        return this.values().iterator();
    }

    public synchronized int size() {
        return this._container.size();
    }

    public synchronized boolean isEmpty() {
        return this._container.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        return this._container.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        Iterator iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            Object found = ref.get();
            if (found != null) {
                if (!found.equals(value)) continue;
                return true;
            }
            iter.remove();
        }
        return false;
    }

    public synchronized Object get(Object key) {
        WeakReference ref = (WeakReference)this._container.get(key);
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        this._container.remove(key);
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        WeakReference<Object> ref = this._container.put(key, new WeakReference<Object>(value));
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        return null;
    }

    public synchronized Object remove(Object key) {
        WeakReference ref = (WeakReference)this._container.remove(key);
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this._container.put(entry.getKey(), new WeakReference(entry.getValue()));
        }
    }

    public synchronized void clear() {
        this._container.clear();
    }

    public synchronized Set keySet() {
        return this._container.keySet();
    }

    public synchronized Collection values() {
        ArrayList col = new ArrayList();
        Iterator iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            Object found = ref.get();
            if (found != null) {
                col.add(found);
                continue;
            }
            iter.remove();
        }
        return col;
    }

    public synchronized Set entrySet() {
        HashMap map = new HashMap();
        Iterator iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            Object found = ref.get();
            if (found != null) {
                map.put(entry.getKey(), found);
                continue;
            }
            iter.remove();
        }
        return map.entrySet();
    }
}

