/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import org.castor.core.util.Configuration;
import org.castor.cpa.persistence.convertor.AbstractTypeConvertor;

public final class StringToBoolean
extends AbstractTypeConvertor {
    private char _trueValue = (char)84;
    private char _falseValue = (char)70;

    public StringToBoolean() {
        super(String.class, Boolean.class);
    }

    public void configure(Configuration configuration) {
    }

    public void parameterize(String parameter) {
        if (parameter == null || parameter.length() != 2) {
            this._trueValue = (char)84;
            this._falseValue = (char)70;
        } else {
            this._trueValue = Character.toUpperCase(parameter.charAt(1));
            this._falseValue = Character.toUpperCase(parameter.charAt(0));
        }
    }

    public Object convert(Object object) {
        String val = (String)object;
        if (val.length() == 1) {
            char c = Character.toUpperCase(val.charAt(0));
            if (c == this._trueValue) {
                return Boolean.TRUE;
            }
            if (c == this._falseValue) {
                return Boolean.FALSE;
            }
        }
        throw new ClassCastException("Failed to convert string '" + object + "' to boolean because it didn't match the expected values '" + this._trueValue + "'/'" + this._falseValue + "' (true/false).");
    }
}

