/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.castor.core.util.Configuration;
import org.castor.cpa.persistence.convertor.TypeConvertor;
import org.exolab.castor.mapping.MappingException;

public final class TypeConvertorRegistry {
    private final Map _convertors = new HashMap();

    public TypeConvertorRegistry(Configuration config) {
        Object[] objects = config.getObjectArray("org.castor.cpa.persistence.TypeConvertors", config.getApplicationClassLoader());
        for (int i = 0; i < objects.length; ++i) {
            TypeConvertor convertor = (TypeConvertor)objects[i];
            convertor.configure(config);
            this.putConvertor(convertor.fromType(), convertor.toType(), convertor);
        }
    }

    private void putConvertor(Class fromType, Class toType, TypeConvertor convertor) {
        HashMap<Class, TypeConvertor> convertors = (HashMap<Class, TypeConvertor>)this._convertors.get(fromType);
        if (convertors == null) {
            convertors = new HashMap<Class, TypeConvertor>();
            this._convertors.put(fromType, convertors);
        }
        convertors.put(toType, convertor);
    }

    private TypeConvertor getConvertor(Class fromType, Class toType) throws MappingException {
        TypeConvertor convertor = null;
        Map convertors = (Map)this._convertors.get(fromType);
        if (convertors != null) {
            convertor = (TypeConvertor)convertors.get(toType);
        }
        if (convertor == null) {
            Iterator fromIter = this._convertors.entrySet().iterator();
            while (convertor == null && fromIter.hasNext()) {
                Map.Entry fromEntry = fromIter.next();
                if (!((Class)fromEntry.getKey()).isAssignableFrom(fromType)) continue;
                convertors = (Map)fromEntry.getValue();
                Iterator toIter = convertors.entrySet().iterator();
                while (convertor == null && toIter.hasNext()) {
                    Map.Entry toEntry = toIter.next();
                    if (!((Class)toEntry.getKey()).isAssignableFrom(toType)) continue;
                    convertor = (TypeConvertor)toEntry.getValue();
                }
            }
            if (convertor == null) {
                throw new MappingException("mapping.noConvertor", (Object)fromType.getName(), (Object)toType.getName());
            }
            this.putConvertor(fromType, toType, convertor);
        }
        return convertor;
    }

    public TypeConvertor getConvertor(Class fromType, Class toType, String parameter) throws MappingException {
        TypeConvertor convertor = this.getConvertor(fromType, toType);
        if (parameter != null) {
            convertor = (TypeConvertor)convertor.clone();
            convertor.parameterize(parameter);
        }
        return convertor;
    }
}

