/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.oql.SyntaxNotSupportedException;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public class JDBCQueryExpression
implements QueryExpression {
    private static Log _log = LogFactory.getFactory().getInstance(JDBCQueryExpression.class);
    protected Hashtable _tables = new Hashtable();
    private Vector _cols = new Vector();
    private Vector _conds = new Vector();
    protected Vector _joins = new Vector();
    protected String _select;
    private String _where;
    protected String _order;
    protected String _limit;
    protected String _offset;
    protected boolean _distinct = false;
    protected PersistenceFactory _factory;
    protected DbMetaInfo _dbInfo;

    public JDBCQueryExpression(PersistenceFactory factory) {
        this._factory = factory;
    }

    public void setDbMetaInfo(DbMetaInfo dbInfo) {
        this._dbInfo = dbInfo;
    }

    public void setDistinct(boolean distinct) {
        this._distinct = distinct;
    }

    public void addColumn(String tableName, String columnName) {
        this._tables.put(tableName, tableName);
        this._cols.addElement(this._factory.quoteName(tableName + "." + columnName));
    }

    public void addTable(String tableName) {
        this._tables.put(tableName, tableName);
    }

    public void addTable(String tableName, String tableAlias) {
        this._tables.put(tableAlias, tableName);
    }

    public void addParameter(String tableName, String columnName, String condOp) {
        this.addCondition(tableName, columnName, condOp, "?");
    }

    public void addCondition(String tableName, String columnName, String condOp, String value) {
        this._tables.put(tableName, tableName);
        this._conds.addElement(this._factory.quoteName(tableName + "." + columnName) + condOp + value);
    }

    public String encodeColumn(String tableName, String columnName) {
        return this._factory.quoteName(tableName + "." + columnName);
    }

    public void addInnerJoin(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        this.addInnerJoin(leftTable, leftColumn, leftTable, rightTable, rightColumn, rightTable);
    }

    public void addInnerJoin(String leftTable, String leftColumn, String leftTableAlias, String rightTable, String rightColumn, String rightTableAlias) {
        this._tables.put(leftTableAlias, leftTable);
        this._tables.put(rightTableAlias, rightTable);
        Join join = new Join(leftTableAlias, leftColumn, rightTableAlias, rightColumn, false);
        int index = this._joins.indexOf(join);
        if (index < 0) {
            this._joins.add(join);
        } else {
            this._joins.set(index, join);
        }
    }

    public void addInnerJoin(String leftTable, String[] leftColumn, String rightTable, String[] rightColumn) {
        this.addInnerJoin(leftTable, leftColumn, leftTable, rightTable, rightColumn, rightTable);
    }

    public void addInnerJoin(String leftTable, String[] leftColumn, String leftTableAlias, String rightTable, String[] rightColumn, String rightTableAlias) {
        this._tables.put(leftTableAlias, leftTable);
        this._tables.put(rightTableAlias, rightTable);
        Join join = new Join(leftTableAlias, leftColumn, rightTableAlias, rightColumn, false);
        int index = this._joins.indexOf(join);
        if (index < 0) {
            this._joins.add(join);
        } else {
            this._joins.set(index, join);
        }
    }

    public void addOuterJoin(String leftTable, String leftColumn, String rightTable, String rightColumn) {
        this.addOuterJoin(leftTable, leftColumn, rightTable, rightColumn, rightTable);
    }

    public void addOuterJoin(String leftTable, String leftColumn, String rightTable, String rightColumn, String rightTableAlias) {
        this._tables.put(leftTable, leftTable);
        this._tables.put(rightTableAlias, rightTable);
        Join join = new Join(leftTable, leftColumn, rightTableAlias, rightColumn, true);
        int index = this._joins.indexOf(join);
        if (index < 0) {
            this._joins.add(join);
        }
    }

    public void addOuterJoin(String leftTable, String[] leftColumn, String rightTable, String[] rightColumn) {
        this.addOuterJoin(leftTable, leftColumn, rightTable, rightColumn, rightTable);
    }

    public void addOuterJoin(String leftTable, String[] leftColumn, String rightTable, String[] rightColumn, String rightTableAlias) {
        this._tables.put(leftTable, leftTable);
        this._tables.put(rightTableAlias, rightTable);
        Join join = new Join(leftTable, leftColumn, rightTableAlias, rightColumn, true);
        int index = this._joins.indexOf(join);
        if (index < 0) {
            this._joins.add(join);
        }
    }

    public void addSelect(String selectClause) {
        this._select = selectClause;
    }

    public void addWhereClause(String where) {
        this._where = where;
    }

    public void addOrderClause(String order) {
        this._order = order;
    }

    public void addLimitClause(String limit) throws SyntaxNotSupportedException {
        if (!this.isLimitClauseSupported()) {
            throw new SyntaxNotSupportedException(Messages.format((String)"query.limitClauseNotSupported", (Object)this._factory.getFactoryName()));
        }
        this._limit = limit;
    }

    public void addOffsetClause(String offset) throws SyntaxNotSupportedException {
        if (!this.isOffsetClauseSupported()) {
            throw new SyntaxNotSupportedException(Messages.format((String)"query.offsetClauseNotSupported", (Object)this._factory.getFactoryName()));
        }
        this._offset = offset;
    }

    protected String getColumnList() {
        if (this._cols.size() == 0 && this._select == null) {
            return "1";
        }
        StringBuffer sql = new StringBuffer();
        int i = 0;
        for (i = 0; i < this._cols.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append((String)this._cols.elementAt(i));
        }
        if (this._select != null) {
            if (i > 0) {
                sql.append(",").append(this._select);
            } else {
                sql.append(this._select);
            }
        }
        return sql.toString();
    }

    protected boolean addWhereClause(StringBuffer sql, boolean first) {
        boolean internalFirst = first;
        if (this._conds.size() > 0) {
            if (internalFirst) {
                sql.append(" WHERE ");
                internalFirst = false;
            } else {
                sql.append(" AND ");
            }
            for (int i = 0; i < this._conds.size(); ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append((String)this._conds.elementAt(i));
            }
        }
        if (this._where != null) {
            if (internalFirst) {
                sql.append(" WHERE ");
                internalFirst = false;
            } else {
                sql.append(" AND ");
            }
            sql.append('(');
            sql.append(this._where);
            sql.append(')');
        }
        return internalFirst;
    }

    public String getStatement(boolean lock) throws SyntaxNotSupportedException {
        return this.getStandardStatement(lock, true).toString();
    }

    protected StringBuffer getStandardStatement(boolean lock, boolean oj) {
        int j;
        String tableName;
        Join join;
        int i;
        Vector<String> done = new Vector<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        if (this._select == null) {
            sql.append(this.getColumnList());
        } else {
            sql.append(this._select).append(" ");
        }
        sql.append(" FROM ");
        Hashtable tables = (Hashtable)this._tables.clone();
        boolean first = true;
        for (i = 0; i < this._joins.size(); ++i) {
            join = (Join)this._joins.elementAt(i);
            if (!join._outer || done.contains(join._leftTable)) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (oj) {
                sql.append("{oj ");
            }
            sql.append(this._factory.quoteName(join._leftTable));
            sql.append(" LEFT OUTER JOIN ");
            tableName = (String)tables.get(join._rightTable);
            if (join._rightTable.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join._rightTable));
            }
            sql.append(" ON ");
            for (j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
            }
            tables.remove(join._leftTable);
            tables.remove(join._rightTable);
            for (int k = i + 1; k < this._joins.size(); ++k) {
                Join join2 = (Join)this._joins.elementAt(k);
                if (!join2._outer || !join._leftTable.equals(join2._leftTable)) continue;
                sql.append(" LEFT OUTER JOIN ");
                tableName = (String)tables.get(join2._rightTable);
                if (join2._rightTable.equals(tableName)) {
                    sql.append(this._factory.quoteName(tableName));
                } else {
                    sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join2._rightTable));
                }
                sql.append(" ON ");
                for (int j2 = 0; j2 < join2._leftColumns.length; ++j2) {
                    if (j2 > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this._factory.quoteName(join2._leftTable + "." + join2._leftColumns[j2])).append("=");
                    sql.append(this._factory.quoteName(join2._rightTable + "." + join2._rightColumns[j2]));
                }
                tables.remove(join2._rightTable);
            }
            if (oj) {
                sql.append("}");
            }
            done.addElement(join._leftTable);
        }
        Enumeration enumeration = tables.keys();
        while (enumeration.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            String tableAlias = (String)enumeration.nextElement();
            tableName = (String)tables.get(tableAlias);
            if (tableAlias.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
                continue;
            }
            sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        first = true;
        for (i = 0; i < this._joins.size(); ++i) {
            join = (Join)this._joins.elementAt(i);
            if (join._outer) continue;
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            for (j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        return sql;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("<").append(this.getStatement(false)).append(">");
        }
        catch (SyntaxNotSupportedException e) {
            _log.error((Object)"Problem turning this to a String", (Throwable)((Object)e));
        }
        return buffer.toString();
    }

    public Object clone() {
        JDBCQueryExpression clone;
        try {
            clone = (JDBCQueryExpression)this.getClass().getConstructor(PersistenceFactory.class).newInstance(this._factory);
        }
        catch (Exception except) {
            throw new RuntimeException(except.toString());
        }
        clone._tables = (Hashtable)this._tables.clone();
        clone._conds = (Vector)this._conds.clone();
        clone._cols = (Vector)this._cols.clone();
        clone._joins = (Vector)this._joins.clone();
        return clone;
    }

    public boolean isLimitClauseSupported() {
        return false;
    }

    public boolean isOffsetClauseSupported() {
        return false;
    }

    static class Join {
        protected final String _leftTable;
        protected final String[] _leftColumns;
        protected final String _rightTable;
        protected final String[] _rightColumns;
        protected final boolean _outer;

        Join(String leftTable, String leftColumn, String rightTable, String rightColumn, boolean outer) {
            this._leftTable = leftTable;
            this._leftColumns = new String[]{leftColumn};
            this._rightTable = rightTable;
            this._rightColumns = new String[]{rightColumn};
            this._outer = outer;
        }

        Join(String leftTable, String[] leftColumns, String rightTable, String[] rightColumns, boolean outer) {
            this._leftTable = leftTable;
            this._leftColumns = (String[])leftColumns.clone();
            this._rightTable = rightTable;
            this._rightColumns = (String[])rightColumns.clone();
            this._outer = outer;
        }

        public int hashCode() {
            return this._leftTable.hashCode() ^ this._rightTable.hashCode();
        }

        public boolean equals(Object obj) {
            int i;
            Join join = (Join)obj;
            if (!this._leftTable.equals(join._leftTable) || !this._rightTable.equals(join._rightTable) || this._leftColumns.length != join._leftColumns.length || this._rightColumns.length != join._rightColumns.length) {
                return false;
            }
            for (i = 0; i < this._leftColumns.length; ++i) {
                if (this._leftColumns[i].equals(join._leftColumns[i])) continue;
                return false;
            }
            for (i = 0; i < this._rightColumns.length; ++i) {
                if (this._rightColumns[i].equals(join._rightColumns[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this._leftTable + "." + this._leftColumns[0] + (this._outer ? "*=" : "=") + this._rightTable + "." + this._rightColumns[0];
        }

        public boolean isOuter() {
            return this._outer;
        }
    }
}

