/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.cpa.persistence.sql.keygen.SqlTypeHandler;
import org.castor.util.Messages;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;

public abstract class AbstractKeyGenerator
implements KeyGenerator {
    protected PersistenceFactory _factory;
    protected String _factoryName;
    private SqlTypeHandler _sqlTypeHandler;
    private byte _style;

    protected void checkSupportedFactory(PersistenceFactory factory) throws MappingException {
        this._factoryName = factory.getFactoryName();
        String[] supportedFactoryNames = this.getSupportedFactoryNames();
        boolean supported = false;
        for (int i = 0; i < supportedFactoryNames.length; ++i) {
            if (!this._factoryName.equals(supportedFactoryNames[i])) continue;
            supported = true;
        }
        if (!supported) {
            String msg = Messages.format((String)"mapping.keyGenNotCompatible", (Object)this.getClass().getName(), (Object)this._factoryName);
            throw new MappingException(msg);
        }
    }

    protected abstract String[] getSupportedFactoryNames();

    protected void initSqlTypeHandler(int sqlType) {
        this._sqlTypeHandler = sqlType == 4 ? new IntegerSqlTypeHandler() : (sqlType == -5 ? new LongSqlTypeHandler() : (sqlType == 1 || sqlType == 12 ? new StringSqlTypeHandler() : new BigDecimalSqlTypeHandler()));
    }

    protected SqlTypeHandler getSqlTypeHandler() {
        return this._sqlTypeHandler;
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
    }

    protected final void setStyle(byte style) {
        this._style = style;
    }

    public final byte getStyle() {
        return this._style;
    }

    public String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }

    private class StringSqlTypeHandler
    implements SqlTypeHandler {
        private StringSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return rs.getString(1);
        }
    }

    private class BigDecimalSqlTypeHandler
    implements SqlTypeHandler {
        private BigDecimalSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return rs.getBigDecimal(1);
        }
    }

    private class LongSqlTypeHandler
    implements SqlTypeHandler {
        private LongSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return new Long(rs.getLong(1));
        }
    }

    private class IntegerSqlTypeHandler
    implements SqlTypeHandler {
        private IntegerSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return new Integer(rs.getInt(1));
        }
    }
}

