/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenValueHandler;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenerator;
import org.castor.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SequenceKeyGenerator
extends AbstractKeyGenerator {
    private static final Log LOG = LogFactory.getFactory().getInstance(SequenceKeyGenerator.class);
    private int _increment;
    private String _seqName;
    private boolean _triggerPresent;
    private SequenceKeyGenValueHandler _type = null;

    public SequenceKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        this.checkSupportedFactory(factory);
        this.supportsSqlType(sqlType);
        this.initSqlTypeHandler(sqlType);
        this.initType();
        boolean returning = "true".equals(params.getProperty("returning"));
        this._triggerPresent = "true".equals(params.getProperty("trigger", "false"));
        if (!this._factoryName.equals("oracle") && returning) {
            throw new MappingException(Messages.format((String)"mapping.keyGenParamNotCompat", (Object)"returning=\"true\"", (Object)this.getClass().getName(), (Object)this._factoryName));
        }
        this._factory = factory;
        this._seqName = params.getProperty("sequence", "{0}_seq");
        this.setStyle(this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("db2") ? (byte)-1 : (returning ? (byte)0 : 1));
        if (this._triggerPresent && !returning) {
            this.setStyle((byte)1);
        }
        if (this._triggerPresent && this.getStyle() == -1) {
            throw new MappingException(Messages.format((String)"mapping.keyGenParamNotCompat", (Object)"trigger=\"true\"", (Object)this.getClass().getName(), (Object)this._factoryName));
        }
        try {
            this._increment = Integer.parseInt(params.getProperty("increment", "1"));
        }
        catch (NumberFormatException nfe) {
            this._increment = 1;
        }
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5 && sqlType != 1 && sqlType != 12) {
            throw new MappingException(Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType)));
        }
    }

    private String getSeqName(String tableName, String primKeyName) {
        return MessageFormat.format(this._seqName, tableName, primKeyName);
    }

    public String[] getSupportedFactoryNames() {
        return new String[]{"oracle", "postgresql", "interbase", "sapdb", "db2"};
    }

    private void initType() {
        this._type = this._factoryName.equals("interbase") ? new InterbaseType() : (this._factoryName.equals("db2") ? new DB2Type() : new DefaultType());
        this._type.setGenerator(this);
        this._type.setSqlTypeHandler(this.getSqlTypeHandler());
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        try {
            return this._type.getValue(conn, tableName, primKeyName, props);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem generating new key", (Throwable)e);
            throw new PersistenceException(Messages.format((String)"persist.keyGenSQL", (Object)e));
        }
    }

    public String patchSQL(String insert, String primKeyName) throws MappingException {
        if (this.getStyle() == -1) {
            return insert;
        }
        StringTokenizer st = new StringTokenizer(insert);
        if (!st.hasMoreTokens() || !st.nextToken().equalsIgnoreCase("INSERT")) {
            throw new MappingException(Messages.format((String)"mapping.keyGenCannotParse", (Object)insert));
        }
        if (!st.hasMoreTokens() || !st.nextToken().equalsIgnoreCase("INTO")) {
            throw new MappingException(Messages.format((String)"mapping.keyGenCannotParse", (Object)insert));
        }
        if (!st.hasMoreTokens()) {
            throw new MappingException(Messages.format((String)"mapping.keyGenCannotParse", (Object)insert));
        }
        String tableName = st.nextToken();
        int idxQuote = tableName.indexOf(34);
        if (idxQuote >= 0) {
            StringBuffer buffer2 = new StringBuffer();
            int pos = 0;
            do {
                buffer2.append(tableName.substring(pos, idxQuote));
            } while ((idxQuote = tableName.indexOf(34, pos = idxQuote + 1)) != -1);
            buffer2.append(tableName.substring(pos));
            tableName = buffer2.toString();
        }
        String seqName = MessageFormat.format(this._seqName, tableName, primKeyName);
        String nextval = this._factory.quoteName(seqName + ".nextval");
        int lp1 = insert.indexOf(40);
        int lp2 = insert.indexOf(40, lp1 + 1);
        if (lp1 < 0) {
            throw new MappingException(Messages.format((String)"mapping.keyGenCannotParse", (Object)insert));
        }
        StringBuffer sb = new StringBuffer(insert);
        if (!this._triggerPresent) {
            if (lp2 < 0) {
                lp2 = lp1;
                lp1 = insert.indexOf(" VALUES ");
                sb.insert(lp2 + 1, nextval);
                sb.insert(lp1 + 1, "(" + this._factory.quoteName(primKeyName) + ") ");
            } else {
                sb.insert(lp2 + 1, nextval + ",");
                sb.insert(lp1 + 1, this._factory.quoteName(primKeyName) + ",");
            }
        }
        if (this.getStyle() == 0) {
            sb.append(" RETURNING ");
            sb.append(this._factory.quoteName(primKeyName));
            sb.append(" INTO ?");
        }
        return sb.toString();
    }

    private class InterbaseType
    extends SequenceKeyGenValueHandler {
        private InterbaseType() {
        }

        protected Object getValue(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
            return this.getValue("SELECT gen_id(" + SequenceKeyGenerator.this.getSeqName(tableName, primKeyName) + "," + SequenceKeyGenerator.this._increment + ") FROM rdb$database", conn);
        }
    }

    private class DB2Type
    extends SequenceKeyGenValueHandler {
        private DB2Type() {
        }

        protected Object getValue(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
            return this.getValue("SELECT nextval FOR " + SequenceKeyGenerator.this.getSeqName(tableName, primKeyName) + " FROM SYSIBM.SYSDUMMY1", conn);
        }
    }

    private class DefaultType
    extends SequenceKeyGenValueHandler {
        private DefaultType() {
        }

        protected Object getValue(Connection conn, String tableName, String primKeyName, Properties props) throws Exception {
            if (SequenceKeyGenerator.this.getStyle() == -1) {
                return this.getValue("SELECT nextval('" + SequenceKeyGenerator.this.getSeqName(tableName, primKeyName) + "')", conn);
            }
            if (SequenceKeyGenerator.this._triggerPresent && SequenceKeyGenerator.this._factoryName.equals("postgresql")) {
                Object insStmt = props.get("insertStatement");
                Class<?> psqlStmtClass = Class.forName("org.postgresql.Statement");
                Method getInsertedOID = psqlStmtClass.getMethod("getInsertedOID", null);
                int insertedOID = (Integer)getInsertedOID.invoke(insStmt, (Object[])null);
                PreparedStatement stmt = conn.prepareStatement("SELECT " + SequenceKeyGenerator.this._factory.quoteName(primKeyName) + " FROM " + SequenceKeyGenerator.this._factory.quoteName(tableName) + " WHERE OID=?");
                stmt.setInt(1, insertedOID);
                return this.getValue(stmt);
            }
            return this.getValue("SELECT " + SequenceKeyGenerator.this._factory.quoteName(SequenceKeyGenerator.this.getSeqName(tableName, primKeyName) + ".currval") + " FROM " + SequenceKeyGenerator.this._factory.quoteName(tableName), conn);
        }
    }

    private abstract class SequenceKeyGenValueHandler
    extends AbstractKeyGenValueHandler {
        private SequenceKeyGenValueHandler() {
        }

        protected abstract Object getValue(Connection var1, String var2, String var3, Properties var4) throws Exception;
    }
}

