/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.drivers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.drivers.ConnectionProxyFactory;

public final class ConnectionProxy
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(ConnectionProxy.class);
    private final Connection _connection;
    private final String _calledBy;

    public ConnectionProxy(Connection con, String calledBy) {
        this._connection = con;
        this._calledBy = calledBy;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating ConnectionProxy for calling class " + this._calledBy));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (LOG.isDebugEnabled()) {
            if ("close".equals(name)) {
                LOG.debug((Object)"Closing JDBC Connection instance.");
            } else if ("commit".equals(name)) {
                LOG.debug((Object)"Committing JDBC Connection instance.");
            } else if ("createStatement".equals(name)) {
                LOG.debug((Object)"Creating JDBC Statement for Connection instance.");
            } else if ("rollback".equals(name)) {
                LOG.debug((Object)"Rolling back JDBC Connection instance.");
            }
        }
        if ("prepareCall".equals(name)) {
            return ConnectionProxyFactory.newCallableStatementProxy((CallableStatement)method.invoke((Object)this._connection, args), (String)args[0]);
        }
        if ("prepareStatement".equals(name)) {
            return ConnectionProxyFactory.newPreparedStatementProxy((PreparedStatement)method.invoke((Object)this._connection, args), (String)args[0]);
        }
        if ("toString".equals(name)) {
            return this.getClass().getName() + " created and called by " + this._calledBy;
        }
        return method.invoke((Object)this._connection, args);
    }
}

