/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.drivers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.castor.cpa.CPAConfiguration;
import org.castor.jdo.drivers.CallableStatementProxy;
import org.castor.jdo.drivers.ConnectionProxy;
import org.castor.jdo.drivers.PreparedStatementProxy;

public final class ConnectionProxyFactory {
    private static final String DEFAULT_CALLED_BY = "unknown";
    private static boolean _isConfigured = false;
    private static boolean _useProxies = false;

    public static Connection newConnectionProxy(Connection connection) {
        return ConnectionProxyFactory.newConnectionProxy(connection, DEFAULT_CALLED_BY);
    }

    public static Connection newConnectionProxy(Connection connection, String calledBy) {
        if (!_isConfigured) {
            _useProxies = CPAConfiguration.getInstance().getBoolean("org.exolab.castor.persist.useProxies", true);
            _isConfigured = true;
        }
        if (!_useProxies) {
            return connection;
        }
        ClassLoader loader = connection.getClass().getClassLoader();
        Class[] interfaces = new Class[]{Connection.class};
        ConnectionProxy handler = new ConnectionProxy(connection, calledBy);
        return (Connection)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    protected static PreparedStatement newPreparedStatementProxy(PreparedStatement statement, String sql) {
        if (!_isConfigured) {
            _useProxies = CPAConfiguration.getInstance().getBoolean("org.exolab.castor.persist.useProxies", true);
            _isConfigured = true;
        }
        if (!_useProxies) {
            return statement;
        }
        ClassLoader loader = statement.getClass().getClassLoader();
        Class[] interfaces = new Class[]{PreparedStatement.class};
        PreparedStatementProxy handler = new PreparedStatementProxy(statement, sql);
        return (PreparedStatement)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    protected static CallableStatement newCallableStatementProxy(CallableStatement statement, String sql) {
        if (!_isConfigured) {
            _useProxies = CPAConfiguration.getInstance().getBoolean("org.exolab.castor.persist.useProxies", true);
            _isConfigured = true;
        }
        if (!_useProxies) {
            return statement;
        }
        ClassLoader loader = statement.getClass().getClassLoader();
        Class[] interfaces = new Class[]{CallableStatement.class};
        CallableStatementProxy handler = new CallableStatementProxy(statement, sql);
        return (CallableStatement)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    private ConnectionProxyFactory() {
    }
}

