/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.RelationCollection;
import org.castor.persist.resolver.ManyRelationResolver;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class OneToManyRelationResolver
extends ManyRelationResolver {
    public OneToManyRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex, boolean debug) {
        super(classMolder, fieldMolder, fieldIndex, debug);
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                Object oo = itor.next();
                if (this._fieldMolder.isDependent()) {
                    if (!tx.isRecorded(oo)) {
                        tx.markCreate(fieldClassMolder, oo, oid);
                        if (!fieldClassMolder.isKeyGenUsed()) continue;
                        updateCache = true;
                        continue;
                    }
                    if (tx.isDepended(oid, oo)) continue;
                    throw new PersistenceException("Dependent object may not change its master");
                }
                if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                tx.markCreate(fieldClassMolder, oo, null);
                if (!fieldClassMolder.isKeyGenUsed()) continue;
                updateCache = true;
            }
        }
        return updateCache;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) throws PersistenceException {
        block6: {
            ClassMolder fieldClassMolder;
            block5: {
                fieldClassMolder = this._fieldMolder.getFieldClassMolder();
                if (!this._fieldMolder.isDependent()) break block5;
                ArrayList alist = (ArrayList)field;
                if (field == null) break block6;
                for (int j = 0; j < alist.size(); ++j) {
                    Identity fid = (Identity)alist.get(j);
                    Object fetched = null;
                    if (fid == null || (fetched = tx.fetch(fieldClassMolder, fid, null)) == null) continue;
                    tx.delete(fetched);
                }
                Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
                while (itor.hasNext()) {
                    Object fobject = itor.next();
                    if (fobject == null || !tx.isPersistent(fobject)) continue;
                    tx.delete(fobject);
                }
                break block6;
            }
            if (field != null) {
                ArrayList alist = (ArrayList)field;
                for (int j = 0; j < alist.size(); ++j) {
                    Identity fid = (Identity)alist.get(j);
                    Object fetched = null;
                    if (fid == null || (fetched = tx.fetch(fieldClassMolder, fid, null)) == null) continue;
                    fieldClassMolder.removeRelation(tx, fetched, fieldClassMolder, object);
                }
                Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
                while (itor.hasNext()) {
                    Object fobject = itor.next();
                    if (fobject == null || !tx.isPersistent(fobject)) continue;
                    fieldClassMolder.removeRelation(tx, fobject, fieldClassMolder, object);
                }
            }
        }
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        UpdateFlags flags;
        block16: {
            Iterator itor;
            ArrayList added;
            RelationCollection lazy;
            ClassMolder fieldClassMolder;
            block17: {
                Object value;
                block15: {
                    flags = new UpdateFlags();
                    fieldClassMolder = this._fieldMolder.getFieldClassMolder();
                    value = this._fieldMolder.getValue(object, tx.getClassLoader());
                    ArrayList orgFields = (ArrayList)field;
                    if (value instanceof Lazy) break block15;
                    Collection removed = ClassMolderHelper.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                    Iterator removedItor = removed.iterator();
                    if (removedItor.hasNext()) {
                        if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                            flags.setUpdatePersist(true);
                        }
                        flags.setUpdateCache(true);
                    }
                    while (removedItor.hasNext()) {
                        Identity removedId = (Identity)removedItor.next();
                        Object reldel = tx.fetch(fieldClassMolder, removedId, null);
                        if (reldel == null) continue;
                        if (this._fieldMolder.isDependent()) {
                            tx.delete(reldel);
                            continue;
                        }
                        fieldClassMolder.removeRelation(tx, reldel, this._classMolder, object);
                    }
                    Collection added2 = ClassMolderHelper.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                    Iterator addedItor = added2.iterator();
                    if (addedItor.hasNext()) {
                        if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                            flags.setUpdatePersist(true);
                        }
                        flags.setUpdateCache(true);
                    }
                    while (addedItor.hasNext()) {
                        Object addedValue = addedItor.next();
                        if (this._fieldMolder.isDependent()) {
                            if (tx.isRecorded(addedValue)) continue;
                            tx.markCreate(fieldClassMolder, addedValue, oid);
                            continue;
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(addedValue)) continue;
                        tx.markCreate(fieldClassMolder, addedValue, null);
                    }
                    break block16;
                }
                lazy = (RelationCollection)value;
                tx.addTxSynchronizable(lazy);
                ArrayList deleted = lazy.getDeleted();
                if (!deleted.isEmpty()) {
                    if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                        flags.setUpdatePersist(true);
                    }
                    flags.setUpdateCache(true);
                    Iterator itor2 = deleted.iterator();
                    while (itor2.hasNext()) {
                        flags.setUpdateCache(true);
                        Object toBeDeleted = lazy.find(itor2.next());
                        if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                        if (this._fieldMolder.isDependent()) {
                            tx.delete(toBeDeleted);
                            continue;
                        }
                        fieldClassMolder.removeRelation(tx, toBeDeleted, this._classMolder, object);
                    }
                }
                if ((added = lazy.getAdded()).isEmpty()) break block16;
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                if (!this._fieldMolder.isDependent()) break block17;
                itor = added.iterator();
                while (itor.hasNext()) {
                    Object toBeAdded = lazy.find(itor.next());
                    if (toBeAdded == null) continue;
                    tx.markCreate(fieldClassMolder, toBeAdded, oid);
                }
                break block16;
            }
            if (!tx.isAutoStore()) break block16;
            itor = added.iterator();
            while (itor.hasNext()) {
                Object toBeAdded = lazy.find(itor.next());
                if (toBeAdded == null || tx.isRecorded(toBeAdded)) continue;
                tx.markCreate(fieldClassMolder, toBeAdded, null);
            }
        }
        return flags;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        ArrayList v = (ArrayList)field;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        ArrayList<Identity> newSetOfIds = new ArrayList<Identity>();
        Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
        while (itor.hasNext()) {
            Object element = itor.next();
            Identity actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
            newSetOfIds.add(actualIdentity);
            if (tx.isRecorded(element)) continue;
            if (this._fieldMolder.isDependent() && !this._fieldMolder.isLazy()) {
                if (v == null || !v.contains(actualIdentity)) continue;
                tx.markUpdate(fieldClassMolder, element, oid);
                continue;
            }
            if (!tx.isAutoStore()) continue;
            tx.markUpdate(fieldClassMolder, element, null);
        }
        if (v != null) {
            for (int j = 0; j < v.size(); ++j) {
                if (newSetOfIds.contains(v.get(j))) continue;
                ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                tx.load((Identity)v.get(j), proposedValue, suggestedAccessMode);
            }
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Identity createdId) {
        return field;
    }

    public boolean updateWhenNoTimestampSet(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                boolean creating;
                Object oo = itor.next();
                if (this._fieldMolder.isDependent()) {
                    if (!tx.isRecorded(oo)) {
                        tx.markCreate(fieldClassMolder, oo, oid);
                        if (!fieldClassMolder._isKeyGenUsed) continue;
                        updateCache = true;
                        continue;
                    }
                    if (tx.isDepended(oid, oo)) continue;
                    throw new PersistenceException("Dependent object may not change its master");
                }
                if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldClassMolder, oo, null)) || !fieldClassMolder._isKeyGenUsed) continue;
                updateCache = true;
            }
        }
        return updateCache;
    }
}

