/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.exolab.castor.gui.QueryHistory;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.JDOManager;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public final class QueryAnalyser {
    private boolean _packFrame = false;

    private QueryAnalyser(String databasename, String dbconfig) {
        MainFrame frame = new MainFrame(databasename, dbconfig);
        if (this._packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: org.exolab.castor.tools.QueryAnalyser <Databasename> <Databaseconfig>");
            System.out.println("Example: org.exolab.castor.tools.QueryAnalyser testdb database.xml");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new QueryAnalyser(args[0], args[1]);
    }

    private class MainFrame
    extends JFrame {
        private static final long serialVersionUID = 3524368558606642742L;
        private QueryHistory _qhistory = new QueryHistory();
        private Mapping _mapping = new Mapping();
        private JPanel _contentPane;
        private BorderLayout _borderLayout1 = new BorderLayout();
        private DefaultTableModel _model;
        private JDOManager _jdo;
        private String _dbName;
        private String _dbConf;
        private JTabbedPane _tabbedPane = new JTabbedPane();
        private JToolBar _toolbar = new JToolBar();
        private JButton _btnNext = new JButton();
        private JButton _btnExit = new JButton();
        private JPanel _sqlresult = new JPanel();
        private JTextPane _sqlPane = new JTextPane();
        private BorderLayout _borderLayout3 = new BorderLayout();
        private JTextPane _oqlquery = new JTextPane();
        private JPanel _queryPanel = new JPanel();
        private BorderLayout _borderLayout2 = new BorderLayout();
        private JScrollPane _resultScrollpane = new JScrollPane();
        private JTable _resultTable = new JTable();
        private JButton _execute = new JButton();
        private JScrollPane _errorScrollPane = new JScrollPane();
        private JPanel _errorPanel = new JPanel();
        private JTextPane _oqlerror = new JTextPane();
        private BorderLayout _borderLayout4 = new BorderLayout();
        private JButton _btnPrevious = new JButton();
        private JLabel _statusBar = new JLabel();

        public MainFrame(String dbName, String dbConf) {
            this._dbName = dbName;
            this._dbConf = dbConf;
            this.enableEvents(64L);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            this._contentPane = (JPanel)this.getContentPane();
            this._contentPane.setLayout(this._borderLayout1);
            this.setSize(new Dimension(600, 400));
            this.setTitle("Castor OQL-Ouery Analyser");
            this._sqlresult.setLayout(this._borderLayout3);
            this._oqlquery.setFont(new Font("Dialog", 0, 12));
            this._oqlquery.setToolTipText("create Query here");
            this._queryPanel.setLayout(this._borderLayout2);
            this._resultScrollpane.setToolTipText("");
            this._resultTable.setAutoResizeMode(0);
            this._btnExit.setMaximumSize(new Dimension(50, 39));
            this._btnExit.setMinimumSize(new Dimension(50, 39));
            this._btnExit.setActionCommand("");
            this._btnExit.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/exit.gif")));
            this._btnExit.setMnemonic('0');
            this._btnExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.exit();
                }
            });
            this._execute.setMaximumSize(new Dimension(50, 39));
            this._execute.setMinimumSize(new Dimension(50, 39));
            this._execute.setActionCommand("");
            this._execute.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/fire.gif")));
            this._execute.setMnemonic('0');
            this._execute.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.executeActionPerformed(e);
                }
            });
            this._errorPanel.setLayout(this._borderLayout4);
            this._btnPrevious.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.btnPreviousActionPerformed(e);
                }
            });
            this._btnNext.setMaximumSize(new Dimension(50, 39));
            this._btnNext.setMinimumSize(new Dimension(50, 39));
            this._btnNext.setActionCommand("");
            this._btnNext.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/arrw04e.gif")));
            this._btnNext.setMnemonic('0');
            this._btnNext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.btnNextActionPerformed(e);
                }
            });
            this._btnPrevious.setMaximumSize(new Dimension(50, 39));
            this._btnPrevious.setMinimumSize(new Dimension(50, 39));
            this._btnPrevious.setToolTipText("Goto previous Query");
            this._btnPrevious.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/arrw04d.gif")));
            this._btnPrevious.setMnemonic('0');
            this._contentPane.add((Component)this._tabbedPane, "Center");
            this._contentPane.add((Component)this._toolbar, "North");
            this._toolbar.add((Component)this._btnExit, null);
            this._toolbar.add((Component)this._execute, null);
            this._toolbar.add((Component)this._btnPrevious, null);
            this._toolbar.add((Component)this._btnNext, null);
            this._contentPane.add((Component)this._statusBar, "South");
            this._tabbedPane.add((Component)this._queryPanel, "OQL Query");
            this._queryPanel.add((Component)this._oqlquery, "Center");
            this._tabbedPane.add((Component)this._resultScrollpane, "Resultset");
            this._tabbedPane.add((Component)this._errorScrollPane, "Stacktrace");
            this._errorScrollPane.getViewport().add((Component)this._errorPanel, null);
            this._errorPanel.add((Component)this._oqlerror, "Center");
            this._tabbedPane.add((Component)this._sqlresult, "SQL");
            this._sqlresult.add((Component)this._sqlPane, "Center");
            this._resultScrollpane.getViewport().add((Component)this._resultTable, null);
            this.openDB();
            this._statusBar.setText("Database " + this._jdo.getDatabaseName() + " waiting for Queries");
            this.loadHistory();
            this._oqlquery.setText(this._qhistory.getCurrentQuery());
        }

        protected void processWindowEvent(WindowEvent e) {
            super.processWindowEvent(e);
            if (e.getID() == 201) {
                this.exit();
            }
        }

        void executeActionPerformed(ActionEvent e) {
            this.performQuery();
        }

        public void performQuery() {
            boolean firstObject = true;
            Vector properties = null;
            this._model = new DefaultTableModel();
            try {
                this._statusBar.setText("performing Query");
                this.clearTabs();
                Database db = this._jdo.getDatabase();
                db.begin();
                this._qhistory.addQuery(this._oqlquery.getText());
                OQLQuery oql = db.getOQLQuery(this._oqlquery.getText());
                Date starttime = new Date();
                QueryResults r = oql.execute(Database.READONLY);
                Date endtime = new Date();
                this._statusBar.setText("Query successful, Time: " + (endtime.getTime() - starttime.getTime()) + " ms");
                this._sqlPane.setText(((OQLQueryImpl)oql).getSQL());
                while (r.hasMore()) {
                    Object o = r.next();
                    if (firstObject) {
                        properties = this.getProperties(o);
                        this.fillTableHeader(properties, this._model);
                        firstObject = false;
                    }
                    this._model.addRow(this.fillRow(properties, o));
                }
                db.commit();
                this._resultTable.setModel(this._model);
                this._resultTable.repaint();
                this._tabbedPane.setSelectedComponent(this._resultScrollpane);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this._oqlerror.setText(sw.getBuffer().toString());
                this._statusBar.setText(e.getMessage());
            }
        }

        private Vector getProperties(Object o) {
            Vector<Method> properties = new Vector<Method>();
            Method[] ms = o.getClass().getMethods();
            for (int i = 0; i < ms.length; ++i) {
                Method m = ms[i];
                if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
                properties.add(m);
            }
            return properties;
        }

        private void fillTableHeader(Vector properties, DefaultTableModel model) {
            for (Method m : properties) {
                model.addColumn(m.getName().substring(3));
            }
        }

        private Vector fillRow(Vector properties, Object o) {
            Vector<Object> results = new Vector<Object>();
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                Object temp = null;
                Method m = (Method)i.next();
                try {
                    temp = m.invoke(o, (Object[])null);
                }
                catch (Exception ie) {
                    temp = null;
                }
                results.add(temp);
            }
            return results;
        }

        private void openDB() {
            try {
                JDOManager.loadConfiguration(this._dbConf, ClassLoader.getSystemClassLoader());
                this._jdo = JDOManager.createInstance(this._dbName);
                this._jdo.getDatabase();
            }
            catch (MappingException pe) {
                pe.printStackTrace();
                System.exit(1);
            }
            catch (PersistenceException pe) {
                pe.printStackTrace();
                System.exit(1);
            }
        }

        private void clearTabs() {
            this._oqlerror.setText("");
            this._sqlPane.setText("");
            this._resultTable.setModel(new DefaultTableModel());
        }

        void btnPreviousActionPerformed(ActionEvent e) {
            this.clearTabs();
            this._oqlquery.setText(this._qhistory.getPreviousQuery());
            this._tabbedPane.setSelectedComponent(this._queryPanel);
        }

        void btnNextActionPerformed(ActionEvent e) {
            this.clearTabs();
            this._oqlquery.setText(this._qhistory.getNextQuery());
            this._tabbedPane.setSelectedComponent(this._queryPanel);
        }

        public void saveHistory() {
            try {
                FileWriter writer = new FileWriter("queryhistory.xml");
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setMapping(this._mapping);
                marshaller.marshal((Object)this._qhistory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void loadHistory() {
            try {
                Unmarshaller unmarshaller = new Unmarshaller(Class.forName("org.exolab.castor.gui.QueryHistory"));
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                this._mapping.loadMapping(cl.getResource("org/exolab/castor/gui/Queryanlyser.xml"));
                unmarshaller.setMapping(this._mapping);
                FileReader reader = new FileReader("queryhistory.xml");
                this._qhistory = (QueryHistory)unmarshaller.unmarshal((Reader)reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void exit() {
            this.saveHistory();
            System.exit(0);
        }
    }
}

