/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Configuration;
import org.castor.cpa.CPAConfiguration;
import org.castor.cpa.persistence.convertor.AbstractSimpleTypeConvertor;
import org.castor.cpa.persistence.convertor.TypeConvertorRegistry;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.mapping.BindingType;
import org.castor.util.Messages;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.AbstractMappingLoader;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.NamedQuery;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.Sql;
import org.exolab.castor.mapping.xml.types.SqlDirtyType;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.util.ClassLoaderNature;
import org.exolab.castor.xml.util.ClassResolutionByFile;

public final class JDOMappingLoader
extends AbstractMappingLoader {
    private static final Log LOG = LogFactory.getLog(JDOMappingLoader.class);
    private static final char LEFT_PARAM_SEPARATOR = '[';
    private static final char RIGHT_PARAM_SEPARATOR = ']';
    private final TypeConvertorRegistry _typeConvertorRegistry;
    private final Map _keyGeneratorDescriptors = new HashMap();
    private final KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();
    private final Set _queryNames = new HashSet();
    private PersistenceFactory _factory;

    public static String definition2param(String sqlTypeDef) {
        int left = sqlTypeDef.indexOf(91);
        int right = sqlTypeDef.indexOf(93);
        if (right < 0) {
            right = sqlTypeDef.length();
        }
        if (left < 0) {
            return null;
        }
        return sqlTypeDef.substring(left + 1, right);
    }

    public static String definition2type(String sqlTypeDef) {
        int sep = sqlTypeDef.indexOf(91);
        if (sep < 0) {
            return sqlTypeDef;
        }
        return sqlTypeDef.substring(0, sep);
    }

    public JDOMappingLoader(ClassLoader loader) {
        super(loader);
        Configuration config = CPAConfiguration.getInstance();
        this._typeConvertorRegistry = new TypeConvertorRegistry(config);
    }

    public BindingType getBindingType() {
        return BindingType.JDO;
    }

    public void loadMapping(MappingRoot mapping, Object param) throws MappingException {
        if (this.loadMapping()) {
            this._factory = (PersistenceFactory)param;
            this.createKeyGenDescriptors(mapping);
            this.createClassDescriptors(mapping);
        }
    }

    private void createKeyGenDescriptors(MappingRoot mapping) throws MappingException {
        Enumeration enumeration = mapping.enumerateKeyGeneratorDef();
        while (enumeration.hasMoreElements()) {
            KeyGeneratorDescriptor desc;
            KeyGeneratorDef def = (KeyGeneratorDef)enumeration.nextElement();
            String name = def.getAlias();
            if (name == null) {
                name = def.getName();
            }
            if ((desc = (KeyGeneratorDescriptor)this._keyGeneratorDescriptors.get(name)) != null) {
                throw new MappingException(Messages.format((String)"mapping.dupKeyGen", (Object)name));
            }
            Properties params = new Properties();
            Enumeration enumerateParam = def.enumerateParam();
            while (enumerateParam.hasMoreElements()) {
                Param par = (Param)enumerateParam.nextElement();
                params.put(par.getName(), par.getValue());
            }
            desc = new KeyGeneratorDescriptor(name, def.getName(), params, this._keyGenReg);
            this._keyGeneratorDescriptors.put(name, desc);
        }
    }

    protected ClassDescriptor createClassDescriptor(ClassMapping classMapping) throws MappingException {
        if (classMapping.getMapTo() == null || classMapping.getMapTo().getTable() == null) {
            LOG.info((Object)Messages.format((String)"mapping.ignoringMapping", (Object)classMapping.getName()));
            return null;
        }
        ClassDescriptorImpl clsDesc = new ClassDescriptorImpl();
        clsDesc.addNature(ClassDescriptorJDONature.class.getName());
        ClassDescriptorJDONature jdoNature = new ClassDescriptorJDONature((PropertyHolder)clsDesc);
        clsDesc.setMapping(classMapping);
        Class javaClass = this.resolveType(classMapping.getName());
        if (!Types.isConstructable((Class)javaClass, (boolean)true)) {
            throw new MappingException("mapping.classNotConstructable", (Object)javaClass.getName());
        }
        clsDesc.setJavaClass(javaClass);
        ClassDescriptor extDesc = this.getExtended(classMapping, javaClass);
        if (extDesc != null) {
            if (!extDesc.hasNature(ClassDescriptorJDONature.class.getName())) {
                throw new IllegalArgumentException("Extended class does not have a JDO descriptor");
            }
            new ClassDescriptorJDONature((PropertyHolder)extDesc).addExtended((ClassDescriptor)clsDesc);
        }
        clsDesc.setExtends(extDesc);
        clsDesc.setDepends(this.getDepended(classMapping, javaClass));
        FieldDescriptorImpl[] allFields = this.createFieldDescriptors(classMapping, javaClass);
        this.checkFieldNameDuplicates((FieldDescriptor[])allFields, javaClass);
        for (int i = 0; i < allFields.length; ++i) {
            allFields[i].setContainingClassDescriptor((ClassDescriptor)clsDesc);
        }
        ArrayList<FieldDescriptorImpl> fieldList = new ArrayList<FieldDescriptorImpl>(allFields.length);
        ArrayList<Object> idList = new ArrayList<Object>();
        if (extDesc == null) {
            for (int i = 0; i < allFields.length; ++i) {
                if (!allFields[i].isIdentity()) {
                    fieldList.add(allFields[i]);
                    continue;
                }
                idList.add(allFields[i]);
            }
            if (idList.size() == 0) {
                String[] idNames = classMapping.getIdentity();
                if (idNames == null || idNames.length == 0) {
                    throw new MappingException("mapping.noIdentity", (Object)javaClass.getName());
                }
                for (int i = 0; i < idNames.length; ++i) {
                    FieldDescriptor identity = this.findIdentityByName(fieldList, idNames[i], javaClass);
                    if (identity == null) {
                        throw new MappingException("mapping.identityMissing", (Object)idNames[i], (Object)javaClass.getName());
                    }
                    idList.add(identity);
                }
            }
        } else {
            for (int i = 0; i < allFields.length; ++i) {
                fieldList.add(allFields[i]);
            }
            FieldDescriptor[] extIds = ((ClassDescriptorImpl)extDesc).getIdentities();
            for (int i = 0; i < extIds.length; ++i) {
                idList.add(extIds[i]);
            }
            for (int i = 0; i < idList.size(); ++i) {
                String idName = ((FieldDescriptor)idList.get(i)).getFieldName();
                FieldDescriptor identity = this.findIdentityByName(fieldList, idName, javaClass);
                if (identity == null) continue;
                idList.set(i, identity);
            }
        }
        FieldDescriptor[] ids = new FieldDescriptor[idList.size()];
        clsDesc.setIdentities(idList.toArray(ids));
        FieldDescriptor[] fields = new FieldDescriptor[fieldList.size()];
        clsDesc.setFields(fieldList.toArray(fields));
        jdoNature.setTableName(classMapping.getMapTo().getTable());
        this.extractAndSetAccessMode(jdoNature, classMapping);
        this.extractAndAddCacheParams(jdoNature, classMapping, javaClass);
        this.extractAndAddNamedQueries(jdoNature, classMapping);
        this.extractAndSetKeyGeneratorDescriptor(jdoNature, classMapping.getKeyGenerator());
        return clsDesc;
    }

    private void extractAndSetAccessMode(ClassDescriptorJDONature jdoNature, ClassMapping clsMap) {
        if (clsMap.getAccess() != null) {
            jdoNature.setAccessMode(AccessMode.valueOf((String)clsMap.getAccess().toString()));
        }
    }

    private void extractAndAddCacheParams(ClassDescriptorJDONature jdoNature, ClassMapping clsMap, Class javaClass) throws MappingException {
        jdoNature.addCacheParam("name", clsMap.getName());
        CacheTypeMapping cacheMapping = clsMap.getCacheTypeMapping();
        if (cacheMapping != null) {
            String type = cacheMapping.getType();
            jdoNature.addCacheParam("type", type);
            Param[] params = cacheMapping.getParam();
            for (int i = 0; i < params.length; ++i) {
                jdoNature.addCacheParam(params[i].getName(), params[i].getValue());
            }
            String debug = new Boolean(cacheMapping.getDebug()).toString();
            jdoNature.addCacheParam("debug", debug);
            String capacity = Long.toString(cacheMapping.getCapacity());
            jdoNature.addCacheParam("capacity", capacity);
            jdoNature.addCacheParam("ttl", capacity);
        }
    }

    private void extractAndAddNamedQueries(ClassDescriptorJDONature jdoNature, ClassMapping clsMap) throws MappingException {
        Enumeration namedQueriesEnum = clsMap.enumerateNamedQuery();
        while (namedQueriesEnum.hasMoreElements()) {
            NamedQuery query = (NamedQuery)namedQueriesEnum.nextElement();
            String queryName = query.getName();
            if (this._queryNames.contains(queryName)) {
                throw new MappingException("Duplicate entry for named query with name " + queryName);
            }
            this._queryNames.add(queryName);
            jdoNature.addNamedQuery(queryName, query.getQuery());
        }
    }

    private void extractAndSetKeyGeneratorDescriptor(ClassDescriptorJDONature jdoNature, String keyGeneratorName) {
        KeyGeneratorDescriptor keyGeneratorDescriptor = null;
        if (keyGeneratorName != null && (keyGeneratorDescriptor = (KeyGeneratorDescriptor)this._keyGeneratorDescriptors.get(keyGeneratorName)) == null) {
            keyGeneratorDescriptor = new KeyGeneratorDescriptor(keyGeneratorName, keyGeneratorName, new Properties(), this._keyGenReg);
            this._keyGeneratorDescriptors.put(keyGeneratorName, keyGeneratorDescriptor);
        }
        jdoNature.setKeyGeneratorDescriptor(keyGeneratorDescriptor);
    }

    protected FieldDescriptor findIdentityByName(List fldList, String idName, Class javaClass) throws MappingException {
        for (int i = 0; i < fldList.size(); ++i) {
            FieldDescriptor field = (FieldDescriptor)fldList.get(i);
            if (!idName.equals(field.getFieldName())) continue;
            if (!field.hasNature(FieldDescriptorJDONature.class.getName())) {
                throw new IllegalStateException("Identity field must be of type JDOFieldDescriptor");
            }
            String[] sqlName = new FieldDescriptorJDONature((PropertyHolder)field).getSQLName();
            if (sqlName == null) {
                throw new MappingException("mapping.noSqlName", (Object)field.getFieldName(), (Object)javaClass.getName());
            }
            fldList.remove(i);
            return field;
        }
        return null;
    }

    protected void resolveRelations(ClassDescriptor clsDesc) {
        FieldDescriptor[] fields = clsDesc.getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            ClassDescriptor desc = this.getDescriptor(field.getFieldType().getName());
            if (desc == null && !field.getFieldType().isPrimitive()) {
                ClassResolutionByFile resolutionCommand = new ClassResolutionByFile();
                resolutionCommand.addNature(ClassLoaderNature.class.getName());
                ClassLoaderNature clNature = new ClassLoaderNature((PropertyHolder)resolutionCommand);
                clNature.setClassLoader(this.getClassLoader());
                desc = resolutionCommand.resolve(field.getFieldType());
                ((FieldDescriptorImpl)field).setClassDescriptor(desc);
            }
            if (desc == null || !(field instanceof FieldDescriptorImpl)) continue;
            ((FieldDescriptorImpl)field).setClassDescriptor(desc);
        }
    }

    protected String[] getSqlTypes(FieldMapping fieldMap) {
        int current;
        if (fieldMap.getSql() == null) {
            return new String[0];
        }
        String sqlType = fieldMap.getSql().getType();
        if (sqlType == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int begin = 0;
        int state = 0;
        block4: for (current = 0; current < sqlType.length(); ++current) {
            switch (state) {
                case 0: {
                    if (sqlType.charAt(current) == ' ') {
                        types.add(sqlType.substring(begin, current));
                        begin = current + 1;
                        continue block4;
                    }
                    if (sqlType.charAt(current) != '[') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (sqlType.charAt(current) != ']') continue block4;
                    state = 0;
                    continue block4;
                }
            }
        }
        types.add(sqlType.substring(begin, current));
        String[] result = new String[types.size()];
        return types.toArray(result);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        Class internalFieldType = fieldType;
        org.castor.cpa.persistence.convertor.TypeConvertor convertorTo = null;
        org.castor.cpa.persistence.convertor.TypeConvertor convertorFrom = null;
        Object convertorParam = null;
        String typeName = null;
        Class sqlType = null;
        String sqlParam = null;
        internalFieldType = Types.typeFromPrimitive((Class)internalFieldType);
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (fieldMap.getSql() != null && sqlTypes.length > 0) {
            typeName = sqlTypes[0];
            sqlType = SQLTypeInfos.sqlTypeName2javaType(JDOMappingLoader.definition2type(typeName));
            sqlParam = JDOMappingLoader.definition2param(typeName);
        } else {
            sqlType = internalFieldType;
        }
        if (this._factory != null) {
            sqlType = this._factory.adjustSqlType(sqlType);
        }
        if (internalFieldType != sqlType) {
            block14: {
                try {
                    convertorTo = this._typeConvertorRegistry.getConvertor(sqlType, internalFieldType, sqlParam);
                }
                catch (MappingException ex) {
                    boolean isTypeSafeEnum = false;
                    if (internalFieldType != null && !JDOMappingLoader.isPrimitive((Class)internalFieldType)) {
                        Constructor cons = null;
                        try {
                            cons = internalFieldType.getConstructor(EMPTY_ARGS);
                            if (!Modifier.isPublic(cons.getModifiers())) {
                                cons = null;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        try {
                            int mods;
                            Method method;
                            Class<?> returnType;
                            if (cons == null && (returnType = (method = internalFieldType.getMethod("valueOf", STRING_ARG)).getReturnType()) != null && internalFieldType.isAssignableFrom(returnType) && Modifier.isStatic(mods = method.getModifiers())) {
                                convertorTo = new EnumTypeConvertor(sqlType, internalFieldType, method);
                                Types.addEnumType((Class)internalFieldType);
                                isTypeSafeEnum = true;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                    }
                    if (isTypeSafeEnum) break block14;
                    throw new MappingException("mapping.noConvertor", (Object)sqlType.getName(), (Object)internalFieldType.getName());
                }
            }
            convertorFrom = this._typeConvertorRegistry.getConvertor(internalFieldType, sqlType, sqlParam);
            if (convertorTo != null && convertorFrom != null) {
                Types.addConvertibleType((Class)internalFieldType);
            }
        }
        return new TypeInfo(internalFieldType, (TypeConvertor)convertorTo, convertorFrom, fieldMap.getRequired(), null, colHandler);
    }

    protected FieldDescriptorImpl createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        int[] sqlTypeNum;
        Sql sql = fieldMap.getSql();
        if (sql == null) {
            return super.createFieldDesc(javaClass, fieldMap);
        }
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            fieldType = this.resolveType(fieldMap.getType());
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            Class colType = CollectionHandlers.getCollectionType((String)fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler((Class)colType);
            if (colType.getName().equals("java.util.Iterator") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'iterator'";
                throw new MappingException(err);
            }
            if (colType.getName().equals("java.util.Enumeration") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'enumerate'";
                throw new MappingException(err);
            }
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        ExtendedFieldHandler exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass = this.resolveType(fieldMap.getHandler());
            if (!FieldHandler.class.isAssignableFrom(handlerClass)) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + FieldHandler.class.getName();
                throw new MappingException(err);
            }
            Constructor constructor = null;
            try {
                constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception except) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        boolean generalized = exfHandler instanceof GeneralizedFieldHandler;
        FieldHandler custom = handler;
        if (generalized) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            AbstractMappingLoader.TypeInfoReference typeInfoRef = new AbstractMappingLoader.TypeInfoReference((AbstractMappingLoader)this);
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                typeInfo = typeInfoRef.typeInfo;
            }
        }
        String[] sqlName = sql.getName();
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (sqlTypes.length > 0) {
            sqlTypeNum = new int[sqlTypes.length];
            for (int i = 0; i < sqlTypes.length; ++i) {
                String sqlTypeString = JDOMappingLoader.definition2type(sqlTypes[i]);
                Class sqlType = SQLTypeInfos.sqlTypeName2javaType(sqlTypeString);
                if (this._factory != null) {
                    sqlType = this._factory.adjustSqlType(sqlType);
                }
                sqlTypeNum[i] = SQLTypeInfos.javaType2sqlTypeNum(sqlType);
            }
        } else {
            Class sqlType = typeInfo.getFieldType();
            if (this._factory != null) {
                sqlType = this._factory.adjustSqlType(sqlType);
            }
            sqlTypeNum = new int[]{SQLTypeInfos.javaType2sqlTypeNum(sqlType)};
        }
        FieldDescriptorImpl fieldDescriptor = new FieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient());
        fieldDescriptor.addNature(FieldDescriptorJDONature.class.getName());
        fieldDescriptor.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            exfHandler.setFieldDescriptor((FieldDescriptor)fieldDescriptor);
        }
        if (sql.getTransient()) {
            fieldDescriptor.setTransient(true);
        }
        FieldDescriptorJDONature fieldJdoNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        if (sqlName.length > 0) {
            fieldJdoNature.setSQLName(sqlName);
        }
        fieldJdoNature.setSQLType(sqlTypeNum);
        fieldJdoNature.setManyTable(sql.getManyTable());
        if (sql.getManyKey().length > 0) {
            fieldJdoNature.setManyKey(sql.getManyKey());
        }
        fieldJdoNature.setDirtyCheck(!SqlDirtyType.IGNORE.equals(sql.getDirty()));
        fieldJdoNature.setReadOnly(sql.getReadOnly());
        return fieldDescriptor;
    }

    private class EnumTypeConvertor
    extends AbstractSimpleTypeConvertor {
        private final Method _method;

        public EnumTypeConvertor(Class fromType, Class toType, Method method) {
            super(fromType, toType);
            this._method = method;
        }

        public Object convert(Object object) {
            try {
                return this._method.invoke((Object)this.toType(), (String)object);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

