/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLStatementLookup {
    private static final Log LOG = LogFactory.getLog(SQLStatementLookup.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private String _statement;

    public SQLStatementLookup(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        try {
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            QueryExpression query = this._factory.getQueryExpression();
            for (int i = 0; i < ids.length; ++i) {
                query.addParameter(this._mapTo, ids[i].getName(), "=");
            }
            this._statement = query.getStatement(true);
        }
        catch (QueryException except) {
            LOG.warn((Object)"Problem building SQL", (Throwable)((Object)except));
            throw new MappingException((Exception)((Object)except));
        }
    }

    public Object executeStatement(Connection conn, Identity identity) throws PersistenceException {
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(this._statement);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.duplicateKeyCheck", (Object)this._statement));
            }
            int count = 1;
            if (identity.size() != ids.length) {
                throw new PersistenceException("Size of identity field mismatched!");
            }
            for (int i = 0; i < ids.length; ++i) {
                stmt.setObject(count++, ids[i].toSQL(identity.get(i)));
            }
            if (stmt.executeQuery().next()) {
                stmt.close();
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)identity));
            }
        }
        catch (SQLException except2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException except2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
        }
        return null;
    }
}

