/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;

public class DatingService {
    private ClassLoader _loader;
    private Hashtable _clsMolders;
    private Vector _needExtendsClassMolder;
    private Vector _needDependsClassMolder;
    private Vector _needFieldClass;
    private Hashtable _javaClasses;

    DatingService(ClassLoader loader) {
        this._loader = loader;
    }

    void close() throws MappingException {
        ClassMolder targetCm;
        ClassMolder initiateCm;
        Pair pair;
        Enumeration e;
        if (this._needExtendsClassMolder != null) {
            e = this._needExtendsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                initiateCm = (ClassMolder)pair._value;
                targetCm = (ClassMolder)this._clsMolders.get(pair._key);
                if (targetCm == null) {
                    throw new MappingException("Extended element, \"" + pair._key + "\"  not found!");
                }
                initiateCm.setExtends(targetCm);
                ((SQLEngine)initiateCm.getPersistence()).setExtends((SQLEngine)targetCm.getPersistence());
            }
        }
        if (this._needDependsClassMolder != null) {
            e = this._needDependsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                initiateCm = (ClassMolder)pair._value;
                targetCm = (ClassMolder)this._clsMolders.get(pair._key);
                if (targetCm == null) {
                    throw new MappingException("Depended element, \"" + pair._key + "\"  not found!");
                }
                initiateCm.setDepends(targetCm);
            }
        }
        if (this._needFieldClass != null) {
            e = this._needFieldClass.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                FieldMolder initiateFm = (FieldMolder)pair._value;
                targetCm = (ClassMolder)this._clsMolders.get(pair._key);
                if (targetCm == null) {
                    throw new MappingException("Field element, \"" + pair._key + "\"  not found!");
                }
                initiateFm.setFieldClassMolder(targetCm);
            }
        }
    }

    boolean pairExtends(ClassMolder me, String extName) throws MappingException {
        if (extName == null || extName.equals("")) {
            throw new IllegalArgumentException("Null classname not allowed!");
        }
        ClassMolder clsMold = (ClassMolder)this._clsMolders.get(extName);
        if (clsMold != null) {
            me.setExtends(clsMold);
            SQLEngine sql = (SQLEngine)me.getPersistence();
            if (sql == null) {
                throw new MappingException("Class " + me + " extends on " + extName + " which is not persistence capable!");
            }
            sql.setExtends((SQLEngine)clsMold.getPersistence());
            return true;
        }
        if (this._needExtendsClassMolder == null) {
            this._needExtendsClassMolder = new Vector();
        }
        this._needExtendsClassMolder.add(new Pair(extName, me));
        return false;
    }

    boolean pairDepends(ClassMolder me, String depName) {
        if (depName == null || depName.equals("")) {
            return true;
        }
        ClassMolder clsMold = (ClassMolder)this._clsMolders.get(depName);
        if (clsMold != null) {
            me.setDepends(clsMold);
            return true;
        }
        if (this._needDependsClassMolder == null) {
            this._needDependsClassMolder = new Vector();
        }
        this._needDependsClassMolder.add(new Pair(depName, me));
        return false;
    }

    Class resolve(String className) throws ClassNotFoundException {
        if (this._javaClasses == null) {
            this._javaClasses = new Hashtable();
        } else if (this._javaClasses.contains(className)) {
            return (Class)this._javaClasses.get(className);
        }
        Class resolved = Types.typeFromName((ClassLoader)this._loader, (String)className);
        this._javaClasses.put(className, resolved);
        return resolved;
    }

    boolean pairFieldClass(FieldMolder fieldMolder, String typeName) throws MappingException {
        try {
            if (typeName == null || typeName.equals("")) {
                return true;
            }
            if (Types.isSimpleType((Class)this.resolve(typeName))) {
                return true;
            }
            if (Types.isEnumType((Class)this.resolve(typeName))) {
                return true;
            }
            if (Types.isConvertibleType((Class)this.resolve(typeName))) {
                return true;
            }
            ClassMolder clsMold = (ClassMolder)this._clsMolders.get(typeName);
            if (clsMold != null) {
                fieldMolder.setFieldClassMolder(clsMold);
                return true;
            }
            if (this._needFieldClass == null) {
                this._needFieldClass = new Vector();
            }
            this._needFieldClass.add(new Pair(typeName, fieldMolder));
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("ClassNotFound :\n" + e);
        }
    }

    void register(String name, ClassMolder clsMold) {
        if (this._clsMolders == null) {
            this._clsMolders = new Hashtable();
        }
        this._clsMolders.put(name, clsMold);
    }

    private final class Pair {
        private Object _key;
        private Object _value;

        private Pair(Object key, Object value) {
            this._key = key;
            this._value = value;
        }
    }
}

