/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Configuration;
import org.castor.cpa.CPAConfiguration;
import org.exolab.castor.persist.spi.KeyGeneratorFactory;

public final class KeyGeneratorFactoryRegistry {
    private static final Log LOG = LogFactory.getLog(KeyGeneratorFactoryRegistry.class);
    private static Hashtable _factories = new Hashtable();

    public static KeyGeneratorFactory getKeyGeneratorFactory(String name) {
        KeyGeneratorFactoryRegistry.load();
        return (KeyGeneratorFactory)_factories.get(name);
    }

    public static String[] getKeyGeneratorFactoryNames() {
        KeyGeneratorFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration enumeration = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)enumeration.nextElement();
        }
        return names;
    }

    private static synchronized void load() {
        if (_factories.isEmpty()) {
            Configuration config = CPAConfiguration.getInstance();
            Object[] objects = config.getObjectArray("org.castor.cpa.persistence.sql.keygen.factories", config.getApplicationClassLoader());
            for (int i = 0; i < objects.length; ++i) {
                KeyGeneratorFactory factory = (KeyGeneratorFactory)objects[i];
                _factories.put(factory.getName(), factory);
            }
        }
    }

    private KeyGeneratorFactoryRegistry() {
    }
}

