/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Configuration;
import org.castor.cpa.CPAConfiguration;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class PersistenceFactoryRegistry {
    private static final Log LOG = LogFactory.getLog(PersistenceFactoryRegistry.class);
    private static Hashtable _factories;

    public static PersistenceFactory getPersistenceFactory(String name) {
        PersistenceFactoryRegistry.load();
        return (PersistenceFactory)_factories.get(name);
    }

    public static String[] getFactoryNames() {
        PersistenceFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration enumeration = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)enumeration.nextElement();
        }
        return names;
    }

    private static synchronized void load() {
        if (_factories == null) {
            _factories = new Hashtable();
            Configuration config = CPAConfiguration.getInstance();
            Object[] objects = config.getObjectArray("org.castor.cpa.persistence.sql.driver.factories", config.getApplicationClassLoader());
            for (int i = 0; i < objects.length; ++i) {
                PersistenceFactory factory = (PersistenceFactory)objects[i];
                _factories.put(factory.getFactoryName(), factory);
            }
        }
    }

    private PersistenceFactoryRegistry() {
    }
}

