/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.castor.util.Messages;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;

public class PersistenceInfoGroup {
    private LockEngine[] _engines;

    public PersistenceInfoGroup(LockEngine[] engines) {
        this._engines = engines;
    }

    public ClassMolder getClassMolder(Class type) throws ClassNotPersistenceCapableException {
        ClassMolder molder = null;
        int i = 0;
        while (i < this._engines.length && molder == null) {
            molder = this._engines[i++].getClassMolderWithDependent(type);
        }
        if (molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)type.getName()));
        }
        if (molder.isDependent()) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classIsDependent", (Object)type.getName(), (Object)molder.getDepends().getName()));
        }
        return molder;
    }

    public ClassMolder findClassMolderByQuery(String query) throws QueryException {
        ClassMolder molder = null;
        for (int i = 0; i < this._engines.length; ++i) {
            molder = this._engines[i].getClassMolderByQuery(query);
        }
        if (molder == null) {
            throw new QueryException("Cannot find a named query with the name " + query);
        }
        return molder;
    }

    public LockEngine getLockEngine() {
        if (this._engines != null && this._engines.length >= 1) {
            return this._engines[0];
        }
        return null;
    }
}

