/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.spi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.castor.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceQuery;

public abstract class AbstractCallQuery
implements PersistenceQuery {
    private static Log _log = LogFactory.getFactory().getInstance(AbstractCallQuery.class);
    private int[] _sqlTypes;
    protected PreparedStatement _stmt;
    protected ResultSet _rs;
    protected Identity _lastIdentity;
    private final Class[] _types;
    protected final Object[] _values;
    private final Class _javaClass;
    protected final String _call;

    protected AbstractCallQuery(String call, Class[] types, Class javaClass, int[] sqlTypes) {
        this._types = types;
        this._javaClass = javaClass;
        this._sqlTypes = sqlTypes;
        this._values = new Object[this._types.length];
        this._call = "{call " + call + "}";
    }

    protected abstract boolean nextRow() throws SQLException;

    public void fetch(ProposedEntity proposedObject) throws PersistenceException {
        try {
            for (int i = 1; i < this._sqlTypes.length; ++i) {
                proposedObject.setField(SQLTypeInfos.getValue(this._rs, i + 1, this._sqlTypes[i]), i - 1);
            }
            this._lastIdentity = this.nextRow() ? new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0])) : null;
        }
        catch (SQLException except) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }

    public void close() {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.rsClosingFailed"), (Throwable)except);
            }
            this._rs = null;
        }
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)except);
            }
            this._stmt = null;
        }
    }

    public int getParameterCount() {
        return this._types.length;
    }

    public Class getParameterType(int index) throws ArrayIndexOutOfBoundsException {
        return this._types[index];
    }

    public void setParameter(int index, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        this._values[index] = value;
    }

    public boolean absolute(int row) throws PersistenceException {
        return false;
    }

    public int size() throws PersistenceException {
        return 0;
    }

    public Class getResultType() {
        return this._javaClass;
    }

    public void execute(Object conn, AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException {
        this.execute(conn, accessMode);
    }

    protected abstract void execute(Object var1, AccessMode var2) throws QueryException, PersistenceException;

    public Identity nextIdentity(Identity identity) throws PersistenceException {
        try {
            if (this._lastIdentity == null) {
                if (!this.nextRow()) {
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
                return this._lastIdentity;
            }
            while (this._lastIdentity.equals(identity)) {
                if (!this.nextRow()) {
                    this._lastIdentity = null;
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
            }
            return this._lastIdentity;
        }
        catch (SQLException except) {
            this._lastIdentity = null;
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }
}

