/*
 * Decompiled with CFR 0.152.
 */
package gldapo.filter;

import gldapo.filter.FilterUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.ldap.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBuilder
extends GroovyObjectSupport {
    protected Stack<List<Filter>> stack = new Stack();
    protected Filter result;
    private Log log = LogFactory.getLog(FilterBuilder.class);

    public FilterBuilder(Closure closure) {
        this.push("root");
        this.call(closure);
        this.result = FilterUtil.and(this.pop("root"));
    }

    public void push(String debugLabel) {
        this.log.debug((Object)("Entering " + debugLabel));
        this.stack.push(new ArrayList());
    }

    public List<Filter> pop(String debugLabel) {
        this.log.debug((Object)("Leafing " + debugLabel));
        return this.stack.pop();
    }

    public void call(Closure c) {
        c.setDelegate((Object)this);
        c.call();
    }

    private Integer add(Filter f) {
        this.log.debug((Object)("Adding Filter to current result: " + DefaultGroovyMethods.inspect((Object)f)));
        this.stack.peek().add(f);
        return this.stack.peek().size() - 1;
    }

    public Object invokeMethod(String s, Object o) {
        if (o instanceof Object[]) {
            return this.invokeMethod(s, (Object[])o);
        }
        if (o == null) {
            return this.invokeMethod(s, new Object[0]);
        }
        return this.invokeMethod(s, new Object[]{o});
    }

    public Object invokeMethod(String name, Object[] args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + ((Object)((Object)this)).hashCode() + "Invoked " + name + " (" + DefaultGroovyMethods.inspect((Object)args) + ")"));
        }
        if ("and".equals(name)) {
            if (args.length == 1 && args[0] instanceof Closure) {
                Closure c = (Closure)args[0];
                this.push("and");
                this.call(c);
                return this.add(FilterUtil.and(this.pop("and")));
            }
            throw new IllegalArgumentException("FilterBuilder 'and' call is invalid!");
        }
        if ("or".equals(name)) {
            if (args.length == 1 && args[0] instanceof Closure) {
                Closure c = (Closure)args[0];
                this.push("and");
                this.call(c);
                return this.add(FilterUtil.or(this.pop("and")));
            }
            throw new IllegalArgumentException("FilterBuilder 'or' call is invalid!");
        }
        if ("eq".equals(name)) {
            if (args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                return this.add(FilterUtil.eq((String)args[0], (String)args[1]));
            }
            throw new IllegalArgumentException("FilterBuilder 'eq' call must have two arguments of type String");
        }
        if ("like".equals(name)) {
            if (args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                return this.add(FilterUtil.like((String)args[0], (String)args[1]));
            }
            throw new IllegalArgumentException("FilterBuilder 'like' call must have two arguments of type String");
        }
        if ("gte".equals(name)) {
            if (args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                return this.add(FilterUtil.gte((String)args[0], (String)args[1]));
            }
            throw new IllegalArgumentException("FilterBuilder 'gte' call must have two arguments of type String");
        }
        if ("lte".equals(name)) {
            if (args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                return this.add(FilterUtil.lte((String)args[0], (String)args[1]));
            }
            throw new IllegalArgumentException("FilterBuilder 'lte' call must have two arguments of type String");
        }
        if ("not".equals(name)) {
            if (args.length == 1 && args[0] instanceof Closure) {
                this.push("not");
                this.call((Closure)args[0]);
                return this.add(FilterUtil.not(FilterUtil.and(this.pop("not"))));
            }
            if (args.length == 1 && args[0] instanceof Integer) {
                int idx = (Integer)args[0];
                this.stack.peek().set(idx, FilterUtil.not(this.stack.peek().get(idx)));
                return idx;
            }
            throw new IllegalArgumentException("FilterBuilder 'not' call is invalid!");
        }
        throw new IllegalAccessError("FilterBuilder invalid call: " + name);
    }

    public Filter getFilter() {
        return this.result;
    }
}

