/*
 * Decompiled with CFR 0.152.
 */
package gldapo.filter;

import gldapo.filter.FilterBuilder;
import groovy.lang.Closure;
import java.util.List;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.GreaterThanOrEqualsFilter;
import org.springframework.ldap.filter.LessThanOrEqualsFilter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.NotFilter;
import org.springframework.ldap.filter.OrFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    public static Filter build(Closure closure) {
        return new FilterBuilder(closure).getFilter();
    }

    public static Filter or(List<Filter> filters) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        OrFilter currentFilter = new OrFilter();
        for (Filter filter : filters) {
            currentFilter.or(filter);
        }
        return currentFilter;
    }

    public static Filter and(List<Filter> filters) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        AndFilter currentFilter = new AndFilter();
        for (Filter filter : filters) {
            currentFilter.and(filter);
        }
        return currentFilter;
    }

    public static Filter and(Filter ... filter) {
        if (filter.length == 1) {
            return filter[0];
        }
        AndFilter result = new AndFilter();
        for (int i = 0; i < filter.length; ++i) {
            result.and(filter[i]);
        }
        return result;
    }

    public static Filter or(Filter ... filter) {
        if (filter.length == 1) {
            return filter[0];
        }
        OrFilter result = new OrFilter();
        for (int i = 0; i < filter.length; ++i) {
            result.or(filter[i]);
        }
        return result;
    }

    public static Filter eq(String field, String value) {
        return new EqualsFilter(field, value);
    }

    public static Filter eq(String field, int value) {
        return new EqualsFilter(field, value);
    }

    public static Filter gte(String field, String value) {
        return new GreaterThanOrEqualsFilter(field, value);
    }

    public static Filter gte(String field, int value) {
        return new GreaterThanOrEqualsFilter(field, value);
    }

    public static Filter lte(String field, String value) {
        return new LessThanOrEqualsFilter(field, value);
    }

    public static Filter lte(String field, int value) {
        return new LessThanOrEqualsFilter(field, value);
    }

    public static Filter like(String field, String value) {
        return new LikeFilter(field, value);
    }

    public static Filter not(Filter filter) {
        return new NotFilter(filter);
    }
}

