/*
 * Decompiled with CFR 0.152.
 */
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AbstractExecutorServiceTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AbstractExecutorServiceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractExecutorServiceTest.class);
    }

    public void testExecuteRunnable() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        JSR166TestCase.TrackedShortRunnable task = new JSR166TestCase.TrackedShortRunnable();
        AbstractExecutorServiceTest.assertFalse((boolean)task.done);
        Future<?> future = e.submit(task);
        future.get();
        AbstractExecutorServiceTest.assertTrue((boolean)task.done);
    }

    public void testSubmitCallable() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        Future<String> future = e.submit(new JSR166TestCase.StringTask());
        String result = future.get();
        AbstractExecutorServiceTest.assertSame((Object)"a test string", (Object)result);
    }

    public void testSubmitRunnable() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
        future.get();
        AbstractExecutorServiceTest.assertTrue((boolean)future.isDone());
    }

    public void testSubmitRunnable2() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
        String result = future.get();
        AbstractExecutorServiceTest.assertSame((Object)"a test string", (Object)result);
    }

    public void testSubmitPrivilegedAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                DirectExecutorService e = new DirectExecutorService();
                Future<Object> future = e.submit(Executors.callable(new PrivilegedAction(){

                    public Object run() {
                        return "a test string";
                    }
                }));
                Assert.assertSame((Object)"a test string", (Object)future.get());
            }
        };
        this.runWithPermissions(r, new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"), new RuntimePermission("modifyThread"));
    }

    public void testSubmitPrivilegedExceptionAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                DirectExecutorService e = new DirectExecutorService();
                Future<Object> future = e.submit(Executors.callable(new PrivilegedExceptionAction(){

                    public Object run() {
                        return "a test string";
                    }
                }));
                Assert.assertSame((Object)"a test string", (Object)future.get());
            }
        };
        this.runWithPermissions(r, new Permission[0]);
    }

    public void testSubmitFailedPrivilegedExceptionAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                DirectExecutorService e = new DirectExecutorService();
                Future<Object> future = e.submit(Executors.callable(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        throw new IndexOutOfBoundsException();
                    }
                }));
                try {
                    future.get();
                    AbstractExecutorServiceTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Assert.assertTrue((boolean)(success.getCause() instanceof IndexOutOfBoundsException));
                }
            }
        };
        this.runWithPermissions(r, new Permission[0]);
    }

    public void testExecuteNullRunnable() {
        try {
            DirectExecutorService e = new DirectExecutorService();
            e.submit((Runnable)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSubmitNullCallable() {
        try {
            DirectExecutorService e = new DirectExecutorService();
            e.submit((Callable)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptedSubmit() throws InterruptedException {
        final CountDownLatch submitted = new CountDownLatch(1);
        final CountDownLatch quittingTime = new CountDownLatch(1);
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        final JSR166TestCase.CheckedCallable<Void> awaiter = new JSR166TestCase.CheckedCallable<Void>(){

            @Override
            public Void realCall() throws InterruptedException {
                quittingTime.await();
                return null;
            }
        };
        try {
            Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

                @Override
                public void realRun() throws Exception {
                    Future future = p.submit(awaiter);
                    submitted.countDown();
                    future.get();
                }
            });
            t.start();
            submitted.await();
            t.interrupt();
            t.join();
        }
        finally {
            quittingTime.countDown();
            this.joinPool(p);
        }
    }

    public void testSubmitEE() throws InterruptedException {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        Callable c = new Callable(){

            public Object call() {
                return 5 / 0;
            }
        };
        try {
            p.submit(c).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            AbstractExecutorServiceTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<7> l = new ArrayList<7>();
        l.add(new Callable<Integer>(){

            @Override
            public Integer call() {
                return 5 / 0;
            }
        });
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            AbstractExecutorServiceTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            AbstractExecutorServiceTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        try {
            List r = e.invokeAll(new ArrayList());
            AbstractExecutorServiceTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
            l.add(new JSR166TestCase.NPETask());
            List futures = e.invokeAll(l);
            AbstractExecutorServiceTest.assertEquals((int)1, (int)futures.size());
            try {
                futures.get(0).get();
                this.shouldThrow();
            }
            catch (ExecutionException success) {
                AbstractExecutorServiceTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            AbstractExecutorServiceTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                AbstractExecutorServiceTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<8> l = new ArrayList<8>();
        l.add(new Callable<Integer>(){

            @Override
            public Integer call() {
                return 5 / 0;
            }
        });
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            AbstractExecutorServiceTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            AbstractExecutorServiceTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            AbstractExecutorServiceTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
            l.add(new JSR166TestCase.NPETask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            AbstractExecutorServiceTest.assertEquals((int)1, (int)futures.size());
            try {
                futures.get(0).get();
                this.shouldThrow();
            }
            catch (ExecutionException success) {
                AbstractExecutorServiceTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            AbstractExecutorServiceTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                AbstractExecutorServiceTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws InterruptedException {
        DirectExecutorService e = new DirectExecutorService();
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(this.possiblyInterruptedRunnable(2L * SHORT_DELAY_MS), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            AbstractExecutorServiceTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            AbstractExecutorServiceTest.assertTrue((boolean)f1.isDone());
            AbstractExecutorServiceTest.assertFalse((boolean)f1.isCancelled());
            AbstractExecutorServiceTest.assertTrue((boolean)f2.isDone());
            AbstractExecutorServiceTest.assertFalse((boolean)f2.isCancelled());
            AbstractExecutorServiceTest.assertTrue((boolean)f3.isDone());
            AbstractExecutorServiceTest.assertTrue((boolean)f3.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    static class DirectExecutorService
    extends AbstractExecutorService {
        private volatile boolean shutdown = false;

        DirectExecutorService() {
        }

        @Override
        public void execute(Runnable r) {
            r.run();
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown = true;
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return this.isShutdown();
        }
    }
}

