/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AbstractQueueTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AbstractQueueTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractQueueTest.class);
    }

    public void testAddS() {
        Succeed q = new Succeed();
        AbstractQueueTest.assertTrue((boolean)q.add(two));
    }

    public void testAddF() {
        Fail q = new Fail();
        try {
            q.add(one);
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddNPE() {
        Succeed q = new Succeed();
        try {
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveS() {
        Succeed q = new Succeed();
        q.remove();
    }

    public void testRemoveF() {
        Fail q = new Fail();
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testElementS() {
        Succeed q = new Succeed();
        q.element();
    }

    public void testElementF() {
        Fail q = new Fail();
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            Succeed q = new Succeed();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            Succeed q = new Succeed();
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            Succeed q = new Succeed();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            Succeed q = new Succeed();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll4() {
        try {
            Fail q = new Fail();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 20; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static class Fail
    extends AbstractQueue<Integer> {
        Fail() {
        }

        @Override
        public boolean offer(Integer x) {
            if (x == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public Integer peek() {
            return null;
        }

        @Override
        public Integer poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return null;
        }
    }

    static class Succeed
    extends AbstractQueue<Integer> {
        Succeed() {
        }

        @Override
        public boolean offer(Integer x) {
            if (x == null) {
                throw new NullPointerException();
            }
            return true;
        }

        @Override
        public Integer peek() {
            return JSR166TestCase.one;
        }

        @Override
        public Integer poll() {
            return JSR166TestCase.one;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return null;
        }
    }
}

