/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AbstractQueuedLongSynchronizerTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AbstractQueuedLongSynchronizerTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractQueuedLongSynchronizerTest.class);
    }

    public void testIsHeldExclusively() {
        Mutex rl = new Mutex();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)rl.isHeldExclusively());
    }

    public void testAcquire() {
        Mutex rl = new Mutex();
        rl.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)rl.isHeldExclusively());
        rl.release(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)rl.isHeldExclusively());
    }

    public void testTryAcquire() {
        Mutex rl = new Mutex();
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)rl.tryAcquire(1L));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)rl.isHeldExclusively());
        rl.release(1L);
    }

    public void testhasQueuedThreads() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasQueuedThreads());
        sync.acquire(1L);
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasQueuedThreads());
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasQueuedThreads());
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasQueuedThreads());
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasQueuedThreads());
        t1.join();
        t2.join();
    }

    public void testIsQueuedNPE() {
        Mutex sync = new Mutex();
        try {
            sync.isQueued(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsQueued() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isQueued(t1));
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isQueued(t2));
        sync.acquire(1L);
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isQueued(t1));
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isQueued(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isQueued(t2));
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isQueued(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isQueued(t2));
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isQueued(t1));
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isQueued(t2));
        t1.join();
        t2.join();
    }

    public void testGetFirstQueuedThread() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertNull((Object)sync.getFirstQueuedThread());
        sync.acquire(1L);
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertEquals((Object)t1, (Object)sync.getFirstQueuedThread());
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertEquals((Object)t1, (Object)sync.getFirstQueuedThread());
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertEquals((Object)t2, (Object)sync.getFirstQueuedThread());
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertNull((Object)sync.getFirstQueuedThread());
        t1.join();
        t2.join();
    }

    public void testHasContended() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasContended());
        sync.acquire(1L);
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasContended());
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasContended());
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasContended());
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasContended());
        t1.join();
        t2.join();
    }

    public void testGetQueuedThreads() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().isEmpty());
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().isEmpty());
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().contains(t1));
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().contains(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().contains(t2));
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.getQueuedThreads().contains(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().contains(t2));
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testGetExclusiveQueuedThreads() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().isEmpty());
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().isEmpty());
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().contains(t1));
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().contains(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().contains(t2));
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.getExclusiveQueuedThreads().contains(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().contains(t2));
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getExclusiveQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testGetSharedQueuedThreads() throws InterruptedException {
        Mutex sync = new Mutex();
        Thread t1 = new Thread(new InterruptedSyncRunnable(sync));
        Thread t2 = new Thread(new InterruptibleSyncRunnable(sync));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        t1.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getSharedQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testInterruptedException2() throws InterruptedException {
        final Mutex sync = new Mutex();
        sync.acquire(1L);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.tryAcquireNanos(1L, TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.MEDIUM_DELAY_MS));
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTryAcquireWhenSynced() throws InterruptedException {
        final Mutex sync = new Mutex();
        sync.acquire(1L);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)sync.tryAcquire(1L));
            }
        });
        t.start();
        t.join();
        sync.release(1L);
    }

    public void testAcquireNanos_Timeout() throws InterruptedException {
        final Mutex sync = new Mutex();
        sync.acquire(1L);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long nanos = TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.SHORT_DELAY_MS);
                Assert.assertFalse((boolean)sync.tryAcquireNanos(1L, nanos));
            }
        });
        t.start();
        t.join();
        sync.release(1L);
    }

    public void testGetState() throws InterruptedException {
        final Mutex sync = new Mutex();
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isHeldExclusively());
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isHeldExclusively());
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                sync.release(1L);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isHeldExclusively());
        t.join();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.isHeldExclusively());
    }

    public void testAcquireInterruptibly1() throws InterruptedException {
        Mutex sync = new Mutex();
        sync.acquire(1L);
        Thread t = new Thread(new InterruptedSyncRunnable(sync));
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.release(1L);
        t.join();
    }

    public void testAcquireInterruptibly2() throws InterruptedException {
        Mutex sync = new Mutex();
        sync.acquireInterruptibly(1L);
        Thread t = new Thread(new InterruptedSyncRunnable(sync));
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.isHeldExclusively());
        t.join();
    }

    public void testOwns() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Mutex sync2 = new Mutex();
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.owns(c));
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync2.owns(c));
    }

    public void testAwait_IllegalMonitor() throws InterruptedException {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        try {
            c.await();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignal_IllegalMonitor() throws InterruptedException {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        try {
            c.signal();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAwaitNanos_Timeout() throws InterruptedException {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        sync.acquire(1L);
        long t = c.awaitNanos(100L);
        AbstractQueuedLongSynchronizerTest.assertTrue((t <= 0L ? 1 : 0) != 0);
        sync.release(1L);
    }

    public void testAwait_Timeout() throws InterruptedException {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)c.await(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        sync.release(1L);
    }

    public void testAwaitUntil_Timeout() throws InterruptedException {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        sync.acquire(1L);
        Date d = new Date();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)c.awaitUntil(new Date(d.getTime() + 10L)));
        sync.release(1L);
    }

    public void testAwait() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                c.await();
                sync.release(1L);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        c.signal();
        sync.release(1L);
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testHasWaitersNPE() {
        Mutex sync = new Mutex();
        try {
            sync.hasWaiters(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthNPE() {
        Mutex sync = new Mutex();
        try {
            sync.getWaitQueueLength(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsNPE() {
        Mutex sync = new Mutex();
        try {
            sync.getWaitingThreads(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasWaitersIAE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Mutex sync2 = new Mutex();
        try {
            sync2.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testHasWaitersIMSE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        try {
            sync.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIAE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Mutex sync2 = new Mutex();
        try {
            sync2.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIMSE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        try {
            sync.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIAE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Mutex sync2 = new Mutex();
        try {
            sync2.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIMSE() {
        Mutex sync = new Mutex();
        AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        try {
            sync.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaiters() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Assert.assertFalse((boolean)sync.hasWaiters(c));
                Assert.assertEquals((int)0, (int)sync.getWaitQueueLength(c));
                c.await();
                sync.release(1L);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertEquals((int)1, (int)sync.getWaitQueueLength(c));
        c.signal();
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertEquals((int)0, (int)sync.getWaitQueueLength(c));
        sync.release(1L);
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testGetWaitQueueLength() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Assert.assertFalse((boolean)sync.hasWaiters(c));
                Assert.assertEquals((int)0, (int)sync.getWaitQueueLength(c));
                c.await();
                sync.release(1L);
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Assert.assertTrue((boolean)sync.hasWaiters(c));
                Assert.assertEquals((int)1, (int)sync.getWaitQueueLength(c));
                c.await();
                sync.release(1L);
            }
        });
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertEquals((int)2, (int)sync.getWaitQueueLength(c));
        c.signalAll();
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertEquals((int)0, (int)sync.getWaitQueueLength(c));
        sync.release(1L);
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t1.isAlive());
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t2.isAlive());
    }

    public void testGetWaitingThreads() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Assert.assertTrue((boolean)sync.getWaitingThreads(c).isEmpty());
                c.await();
                sync.release(1L);
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Assert.assertFalse((boolean)sync.getWaitingThreads(c).isEmpty());
                c.await();
                sync.release(1L);
            }
        });
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getWaitingThreads(c).isEmpty());
        sync.release(1L);
        t1.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getWaitingThreads(c).contains(t1));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getWaitingThreads(c).contains(t2));
        c.signalAll();
        sync.release(1L);
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)sync.hasWaiters(c));
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)sync.getWaitingThreads(c).isEmpty());
        sync.release(1L);
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t1.isAlive());
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t2.isAlive());
    }

    public void testAwaitUninterruptibly() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                sync.acquire(1L);
                c.awaitUninterruptibly();
                sync.release(1L);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        sync.acquire(1L);
        c.signal();
        sync.release(1L);
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwait_Interrupt() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                c.await();
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitNanos_Interrupt() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                c.awaitNanos(TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.LONG_DELAY_MS));
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testAwaitUntil_Interrupt() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                Date d = new Date();
                c.awaitUntil(new Date(d.getTime() + 10000L));
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t.isAlive());
    }

    public void testSignalAll() throws InterruptedException {
        final Mutex sync = new Mutex();
        final AbstractQueuedLongSynchronizer.ConditionObject c = sync.newCondition();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                c.await();
                sync.release(1L);
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                sync.acquire(1L);
                c.await();
                sync.release(1L);
            }
        });
        t1.start();
        t2.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        sync.acquire(1L);
        c.signalAll();
        sync.release(1L);
        t1.join(SHORT_DELAY_MS);
        t2.join(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t1.isAlive());
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)t2.isAlive());
    }

    public void testToString() {
        Mutex sync = new Mutex();
        String us = sync.toString();
        AbstractQueuedLongSynchronizerTest.assertTrue((us.indexOf("State = 0") >= 0 ? 1 : 0) != 0);
        sync.acquire(1L);
        String ls = sync.toString();
        AbstractQueuedLongSynchronizerTest.assertTrue((ls.indexOf("State = 65536") >= 0 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        Mutex l = new Mutex();
        l.acquire(1L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isHeldExclusively());
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        Mutex r = (Mutex)in.readObject();
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)r.isHeldExclusively());
    }

    public void testGetStateWithReleaseShared() {
        BooleanLatch l = new BooleanLatch();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        l.releaseShared(0L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isSignalled());
    }

    public void testReleaseShared() {
        BooleanLatch l = new BooleanLatch();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        l.releaseShared(0L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isSignalled());
        l.releaseShared(0L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isSignalled());
    }

    public void testAcquireSharedInterruptibly() throws InterruptedException {
        final BooleanLatch l = new BooleanLatch();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)l.isSignalled());
                l.acquireSharedInterruptibly(0L);
                Assert.assertTrue((boolean)l.isSignalled());
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        l.releaseShared(0L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isSignalled());
        t.join();
    }

    public void testAcquireSharedTimed() throws InterruptedException {
        final BooleanLatch l = new BooleanLatch();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)l.isSignalled());
                long nanos = TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.MEDIUM_DELAY_MS);
                Assert.assertTrue((boolean)l.tryAcquireSharedNanos(0L, nanos));
                Assert.assertTrue((boolean)l.isSignalled());
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        l.releaseShared(0L);
        AbstractQueuedLongSynchronizerTest.assertTrue((boolean)l.isSignalled());
        t.join();
    }

    public void testAcquireSharedInterruptibly_InterruptedException() throws InterruptedException {
        final BooleanLatch l = new BooleanLatch();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)l.isSignalled());
                l.acquireSharedInterruptibly(0L);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        t.interrupt();
        t.join();
    }

    public void testAcquireSharedNanos_InterruptedException() throws InterruptedException {
        final BooleanLatch l = new BooleanLatch();
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)l.isSignalled());
                long nanos = TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.SMALL_DELAY_MS);
                l.tryAcquireSharedNanos(0L, nanos);
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        t.interrupt();
        t.join();
    }

    public void testAcquireSharedNanos_Timeout() throws InterruptedException {
        final BooleanLatch l = new BooleanLatch();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)l.isSignalled());
                long nanos = TimeUnit.MILLISECONDS.toNanos(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertFalse((boolean)l.tryAcquireSharedNanos(0L, nanos));
            }
        });
        t.start();
        AbstractQueuedLongSynchronizerTest.delay(SHORT_DELAY_MS);
        AbstractQueuedLongSynchronizerTest.assertFalse((boolean)l.isSignalled());
        t.join();
    }

    class InterruptedSyncRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final Mutex sync;

        InterruptedSyncRunnable(Mutex l) {
            this.sync = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.sync.acquireInterruptibly(1L);
        }
    }

    class InterruptibleSyncRunnable
    extends JSR166TestCase.CheckedRunnable {
        final Mutex sync;

        InterruptibleSyncRunnable(Mutex l) {
            this.sync = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.sync.acquireInterruptibly(1L);
        }
    }

    static class BooleanLatch
    extends AbstractQueuedLongSynchronizer {
        BooleanLatch() {
        }

        public boolean isSignalled() {
            return this.getState() != 0L;
        }

        @Override
        public long tryAcquireShared(long ignore) {
            return this.isSignalled() ? 1L : -1L;
        }

        @Override
        public boolean tryReleaseShared(long ignore) {
            this.setState(0x40000000L);
            return true;
        }
    }

    static class Mutex
    extends AbstractQueuedLongSynchronizer {
        static final long LOCKED = 65536L;

        Mutex() {
        }

        @Override
        public boolean isHeldExclusively() {
            return this.getState() == 65536L;
        }

        @Override
        public boolean tryAcquire(long acquires) {
            return this.compareAndSetState(0L, 65536L);
        }

        @Override
        public boolean tryRelease(long releases) {
            if (this.getState() == 0L) {
                throw new IllegalMonitorStateException();
            }
            this.setState(0L);
            return true;
        }

        public AbstractQueuedLongSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedLongSynchronizer.ConditionObject(this);
        }
    }
}

