/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayDequeTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ArrayDequeTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ArrayDequeTest.class);
    }

    private ArrayDeque<Integer> populatedDeque(int n) {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.offerLast(new Integer(i)));
        }
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        ArrayDequeTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ArrayDequeTest.assertEquals((int)0, (int)new ArrayDeque().size());
    }

    public void testConstructor3() {
        try {
            ArrayDeque q = new ArrayDeque(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            ArrayDeque<Integer> q = new ArrayDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            ArrayDeque<Integer> q = new ArrayDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayDeque<Integer> q = new ArrayDeque<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testEmpty() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.removeFirst();
        q.removeFirst();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            q.removeFirst();
        }
        for (i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testPushNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>(1);
            q.push(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPush() {
        ArrayDeque<Integer> q = this.populatedDeque(3);
        q.pollLast();
        q.push(four);
        ArrayDequeTest.assertSame((Object)four, (Object)q.peekFirst());
    }

    public void testPop() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pop());
        }
        try {
            q.pop();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOfferNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferFirstNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.offerFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferLastNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.offerLast(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.offer(zero));
        ArrayDequeTest.assertTrue((boolean)q.offer(one));
        ArrayDequeTest.assertSame((Object)zero, q.peekFirst());
        ArrayDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testOfferFirst() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.offerFirst(zero));
        ArrayDequeTest.assertTrue((boolean)q.offerFirst(one));
        ArrayDequeTest.assertSame((Object)one, q.peekFirst());
        ArrayDequeTest.assertSame((Object)zero, q.peekLast());
    }

    public void testOfferLast() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.offerLast(zero));
        ArrayDequeTest.assertTrue((boolean)q.offerLast(one));
        ArrayDequeTest.assertSame((Object)zero, q.peekFirst());
        ArrayDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddFirstNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.addFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddLastNull() {
        try {
            ArrayDeque<Object> q = new ArrayDeque<Object>();
            q.addLast(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAdd() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertTrue((boolean)q.add(zero));
        ArrayDequeTest.assertTrue((boolean)q.add(one));
        ArrayDequeTest.assertSame((Object)zero, q.peekFirst());
        ArrayDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddFirst() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.addFirst(zero);
        q.addFirst(one);
        ArrayDequeTest.assertSame((Object)one, q.peekFirst());
        ArrayDequeTest.assertSame((Object)zero, q.peekLast());
    }

    public void testAddLast() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.addLast(zero);
        q.addLast(one);
        ArrayDequeTest.assertSame((Object)zero, q.peekFirst());
        ArrayDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddAll1() {
        try {
            ArrayDeque q = new ArrayDeque();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        ArrayDequeTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ArrayDequeTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testPollFirst() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        ArrayDequeTest.assertNull((Object)q.pollFirst());
    }

    public void testPollLast() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        ArrayDequeTest.assertNull((Object)q.pollLast());
    }

    public void testPoll() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.poll());
        }
        ArrayDequeTest.assertNull((Object)q.poll());
    }

    public void testRemove() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.contains(i));
            ArrayDequeTest.assertTrue((boolean)q.remove(i));
            ArrayDequeTest.assertFalse((boolean)q.contains(i));
            ArrayDequeTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.contains(i));
            ArrayDequeTest.assertTrue((boolean)q.remove(i));
            ArrayDequeTest.assertFalse((boolean)q.contains(i));
            ArrayDequeTest.assertFalse((boolean)q.remove(i + 1));
            ArrayDequeTest.assertFalse((boolean)q.contains(i + 1));
        }
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testPeekFirst() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.peekFirst());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
            ArrayDequeTest.assertTrue((q.peekFirst() == null || !((Object)q.peekFirst()).equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testPeek() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.peek());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.poll());
            ArrayDequeTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull((Object)q.peek());
    }

    public void testPeekLast() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.peekLast());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollLast());
            ArrayDequeTest.assertTrue((q.peekLast() == null || !((Object)q.peekLast()).equals(i) ? 1 : 0) != 0);
        }
        ArrayDequeTest.assertNull((Object)q.peekLast());
    }

    public void testElement() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.element());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testFirstElement() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.getFirst());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        try {
            q.getFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLastElement() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.getLast());
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        try {
            q.getLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ArrayDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirst() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.removeFirst());
        }
        try {
            q.removeFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ArrayDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testRemoveLast() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ArrayDequeTest.assertEquals((Object)i, (Object)q.removeLast());
        }
        try {
            q.removeLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ArrayDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirstOccurrence() {
        int i;
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
            ArrayDequeTest.assertFalse((boolean)q.removeFirstOccurrence(new Integer(i + 1)));
        }
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveLastOccurrence() {
        int i;
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ArrayDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
            ArrayDequeTest.assertFalse((boolean)q.removeLastOccurrence(new Integer(i + 1)));
        }
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.contains(new Integer(i)));
            ArrayDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
            ArrayDequeTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        q.clear();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        ArrayDequeTest.assertEquals((int)0, (int)q.size());
        ArrayDequeTest.assertTrue((boolean)q.add(new Integer(1)));
        ArrayDequeTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ArrayDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        ArrayDeque<Integer> p = new ArrayDeque<Integer>();
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((boolean)q.containsAll(p));
            ArrayDequeTest.assertFalse((boolean)p.containsAll(q));
            ArrayDequeTest.assertTrue((boolean)p.add(new Integer(i)));
        }
        ArrayDequeTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        ArrayDeque<Integer> p = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            ArrayDequeTest.assertEquals((boolean)changed, (i > 0 ? 1 : 0) != 0);
            ArrayDequeTest.assertTrue((boolean)q.containsAll(p));
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            p.removeFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ArrayDeque<Integer> q = this.populatedDeque(20);
            ArrayDeque<Integer> p = this.populatedDeque(i);
            ArrayDequeTest.assertTrue((boolean)q.removeAll(p));
            ArrayDequeTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                ArrayDequeTest.assertFalse((boolean)q.contains(p.removeFirst()));
            }
        }
    }

    public void testToArray() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            ArrayDequeTest.assertSame((Object)o[i], (Object)q.pollFirst());
        }
    }

    public void testToArray2() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        ArrayDequeTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            ArrayDequeTest.assertSame((Object)ints[i], (Object)q.remove());
        }
    }

    public void testToArray_NullArg() {
        ArrayDeque<Object> l = new ArrayDeque<Object>();
        l.add(new Object());
        try {
            l.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        ArrayDeque<Integer> l = new ArrayDeque<Integer>();
        l.add(new Integer(5));
        try {
            l.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ArrayDequeTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertEquals((Object)(++k), it.next());
        }
        ArrayDequeTest.assertEquals((int)3, (int)k);
    }

    public void testIteratorRemove() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = 1; j2 <= max; ++j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.iterator();
            for (j = 1; j <= split; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.iterator();
            for (j = split + 1; j <= max; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ArrayDequeTest.assertFalse((boolean)it.hasNext());
            ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testDescendingIterator() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        int i = 0;
        Iterator<Integer> it = q.descendingIterator();
        while (it.hasNext()) {
            ArrayDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ArrayDequeTest.assertEquals((int)i, (int)20);
        ArrayDequeTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
    }

    public void testDescendingIteratorOrdering() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        for (int iters = 0; iters < 100; ++iters) {
            q.add(new Integer(3));
            q.add(new Integer(2));
            q.add(new Integer(1));
            int k = 0;
            Iterator it = q.descendingIterator();
            while (it.hasNext()) {
                ArrayDequeTest.assertEquals((Object)(++k), it.next());
            }
            ArrayDequeTest.assertEquals((int)3, (int)k);
            q.remove();
            q.remove();
            q.remove();
        }
    }

    public void testDescendingIteratorRemove() {
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = max; j2 >= 1; --j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.descendingIterator();
            for (j = 1; j <= split; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.descendingIterator();
            for (j = split + 1; j <= max; ++j) {
                ArrayDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ArrayDequeTest.assertFalse((boolean)it.hasNext());
            ArrayDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testToString() {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ArrayDequeTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        ArrayDeque<Integer> q = this.populatedDeque(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ArrayDeque r = (ArrayDeque)in.readObject();
        ArrayDequeTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ArrayDequeTest.assertEquals((Object)q.remove(), r.remove());
        }
    }
}

