/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerArray;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicIntegerArrayTest
extends JSR166TestCase {
    static final int COUNTDOWN = 100000;

    public static void main(String[] args) {
        TestRunner.run((Test)AtomicIntegerArrayTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicIntegerArrayTest.class);
    }

    public void testConstructor() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.get(i));
        }
    }

    public void testConstructor2NPE() {
        try {
            int[] a = null;
            AtomicIntegerArray ai = new AtomicIntegerArray(a);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        int[] a = new int[]{17, 3, -42, 99, -7};
        AtomicIntegerArray ai = new AtomicIntegerArray(a);
        AtomicIntegerArrayTest.assertEquals((int)a.length, (int)ai.length());
        for (int i = 0; i < a.length; ++i) {
            AtomicIntegerArrayTest.assertEquals((int)a[i], (int)ai.get(i));
        }
    }

    public void testIndexing() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        try {
            ai.get(20);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.get(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(20, 0);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(-1, 0);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.get(i));
            ai.set(i, 2);
            AtomicIntegerArrayTest.assertEquals((int)2, (int)ai.get(i));
            ai.set(i, -3);
            AtomicIntegerArrayTest.assertEquals((int)-3, (int)ai.get(i));
        }
    }

    public void testGetLazySet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.lazySet(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.get(i));
            ai.lazySet(i, 2);
            AtomicIntegerArrayTest.assertEquals((int)2, (int)ai.get(i));
            ai.lazySet(i, -3);
            AtomicIntegerArrayTest.assertEquals((int)-3, (int)ai.get(i));
        }
    }

    public void testCompareAndSet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertTrue((boolean)ai.compareAndSet(i, 1, 2));
            AtomicIntegerArrayTest.assertTrue((boolean)ai.compareAndSet(i, 2, -4));
            AtomicIntegerArrayTest.assertEquals((int)-4, (int)ai.get(i));
            AtomicIntegerArrayTest.assertFalse((boolean)ai.compareAndSet(i, -5, 7));
            AtomicIntegerArrayTest.assertEquals((int)-4, (int)ai.get(i));
            AtomicIntegerArrayTest.assertTrue((boolean)ai.compareAndSet(i, -4, 7));
            AtomicIntegerArrayTest.assertEquals((int)7, (int)ai.get(i));
        }
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicIntegerArray a = new AtomicIntegerArray(1);
        a.set(0, 1);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!a.compareAndSet(0, 2, 3)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicIntegerArrayTest.assertTrue((boolean)a.compareAndSet(0, 1, 2));
        t.join(LONG_DELAY_MS);
        AtomicIntegerArrayTest.assertFalse((boolean)t.isAlive());
        AtomicIntegerArrayTest.assertEquals((int)a.get(0), (int)3);
    }

    public void testWeakCompareAndSet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            while (!ai.weakCompareAndSet(i, 1, 2)) {
            }
            while (!ai.weakCompareAndSet(i, 2, -4)) {
            }
            AtomicIntegerArrayTest.assertEquals((int)-4, (int)ai.get(i));
            while (!ai.weakCompareAndSet(i, -4, 7)) {
            }
            AtomicIntegerArrayTest.assertEquals((int)7, (int)ai.get(i));
        }
    }

    public void testGetAndSet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.getAndSet(i, 0));
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.getAndSet(i, -10));
            AtomicIntegerArrayTest.assertEquals((int)-10, (int)ai.getAndSet(i, 1));
        }
    }

    public void testGetAndAdd() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.getAndAdd(i, 2));
            AtomicIntegerArrayTest.assertEquals((int)3, (int)ai.get(i));
            AtomicIntegerArrayTest.assertEquals((int)3, (int)ai.getAndAdd(i, -4));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.get(i));
        }
    }

    public void testGetAndDecrement() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.getAndDecrement(i));
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.getAndDecrement(i));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.getAndDecrement(i));
        }
    }

    public void testGetAndIncrement() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.getAndIncrement(i));
            AtomicIntegerArrayTest.assertEquals((int)2, (int)ai.get(i));
            ai.set(i, -2);
            AtomicIntegerArrayTest.assertEquals((int)-2, (int)ai.getAndIncrement(i));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.getAndIncrement(i));
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.getAndIncrement(i));
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.get(i));
        }
    }

    public void testAddAndGet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)3, (int)ai.addAndGet(i, 2));
            AtomicIntegerArrayTest.assertEquals((int)3, (int)ai.get(i));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.addAndGet(i, -4));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.get(i));
        }
    }

    public void testDecrementAndGet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.decrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.decrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)-2, (int)ai.decrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)-2, (int)ai.get(i));
        }
    }

    public void testIncrementAndGet() {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 1);
            AtomicIntegerArrayTest.assertEquals((int)2, (int)ai.incrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)2, (int)ai.get(i));
            ai.set(i, -2);
            AtomicIntegerArrayTest.assertEquals((int)-1, (int)ai.incrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)0, (int)ai.incrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.incrementAndGet(i));
            AtomicIntegerArrayTest.assertEquals((int)1, (int)ai.get(i));
        }
    }

    public void testCountingInMultipleThreads() throws InterruptedException {
        AtomicIntegerArray ai = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, 100000);
        }
        Counter c1 = new Counter(ai);
        Counter c2 = new Counter(ai);
        Thread t1 = new Thread(c1);
        Thread t2 = new Thread(c2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        AtomicIntegerArrayTest.assertEquals((int)(c1.counts + c2.counts), (int)2000000);
    }

    public void testSerialization() throws Exception {
        AtomicIntegerArray l = new AtomicIntegerArray(20);
        for (int i = 0; i < 20; ++i) {
            l.set(i, -i);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicIntegerArray r = (AtomicIntegerArray)in.readObject();
        for (int i = 0; i < 20; ++i) {
            AtomicIntegerArrayTest.assertEquals((int)l.get(i), (int)r.get(i));
        }
    }

    public void testToString() {
        int[] a = new int[]{17, 3, -42, 99, -7};
        AtomicIntegerArray ai = new AtomicIntegerArray(a);
        AtomicIntegerArrayTest.assertEquals((String)Arrays.toString(a), (String)ai.toString());
    }

    class Counter
    extends JSR166TestCase.CheckedRunnable {
        final AtomicIntegerArray ai;
        volatile int counts;

        Counter(AtomicIntegerArray a) {
            super(AtomicIntegerArrayTest.this);
            this.ai = a;
        }

        @Override
        public void realRun() {
            boolean done;
            do {
                done = true;
                for (int i = 0; i < this.ai.length(); ++i) {
                    int v = this.ai.get(i);
                    Assert.assertTrue((v >= 0 ? 1 : 0) != 0);
                    if (v == 0) continue;
                    done = false;
                    if (!this.ai.compareAndSet(i, v, v - 1)) continue;
                    ++this.counts;
                }
            } while (!done);
        }
    }
}

