/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicIntegerFieldUpdaterTest
extends JSR166TestCase {
    volatile int x = 0;
    int w;
    long z;

    public static void main(String[] args) {
        TestRunner.run((Test)AtomicIntegerFieldUpdaterTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicIntegerFieldUpdaterTest.class);
    }

    public void testConstructor() {
        try {
            AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "y");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "z");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "w");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.get(this));
        a.set(this, 2);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)2, (int)a.get(this));
        a.set(this, -3);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-3, (int)a.get(this));
    }

    public void testGetLazySet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.get(this));
        a.lazySet(this, 2);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)2, (int)a.get(this));
        a.lazySet(this, -3);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-3, (int)a.get(this));
    }

    public void testCompareAndSet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 1, 2));
        AtomicIntegerFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 2, -4));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-4, (int)a.get(this));
        AtomicIntegerFieldUpdaterTest.assertFalse((boolean)a.compareAndSet(this, -5, 7));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-4, (int)a.get(this));
        AtomicIntegerFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, -4, 7));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)7, (int)a.get(this));
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        this.x = 1;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!a.compareAndSet(AtomicIntegerFieldUpdaterTest.this, 2, 3)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicIntegerFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, 1, 2));
        t.join(LONG_DELAY_MS);
        AtomicIntegerFieldUpdaterTest.assertFalse((boolean)t.isAlive());
        AtomicIntegerFieldUpdaterTest.assertEquals((int)a.get(this), (int)3);
    }

    public void testWeakCompareAndSet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        while (!a.weakCompareAndSet(this, 1, 2)) {
        }
        while (!a.weakCompareAndSet(this, 2, -4)) {
        }
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-4, (int)a.get(this));
        while (!a.weakCompareAndSet(this, -4, 7)) {
        }
        AtomicIntegerFieldUpdaterTest.assertEquals((int)7, (int)a.get(this));
    }

    public void testGetAndSet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.getAndSet(this, 0));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)0, (int)a.getAndSet(this, -10));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-10, (int)a.getAndSet(this, 1));
    }

    public void testGetAndAdd() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.getAndAdd(this, 2));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)3, (int)a.get(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)3, (int)a.getAndAdd(this, -4));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.get(this));
    }

    public void testGetAndDecrement() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.getAndDecrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)0, (int)a.getAndDecrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.getAndDecrement(this));
    }

    public void testGetAndIncrement() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.getAndIncrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)2, (int)a.get(this));
        a.set(this, -2);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-2, (int)a.getAndIncrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.getAndIncrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)0, (int)a.getAndIncrement(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.get(this));
    }

    public void testAddAndGet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)3, (int)a.addAndGet(this, 2));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)3, (int)a.get(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.addAndGet(this, -4));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.get(this));
    }

    public void testDecrementAndGet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)0, (int)a.decrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.decrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-2, (int)a.decrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-2, (int)a.get(this));
    }

    public void testIncrementAndGet() {
        AtomicIntegerFieldUpdater<AtomicIntegerFieldUpdaterTest> a;
        try {
            a = AtomicIntegerFieldUpdater.newUpdater(AtomicIntegerFieldUpdaterTest.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = 1;
        AtomicIntegerFieldUpdaterTest.assertEquals((int)2, (int)a.incrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)2, (int)a.get(this));
        a.set(this, -2);
        AtomicIntegerFieldUpdaterTest.assertEquals((int)-1, (int)a.incrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)0, (int)a.incrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.incrementAndGet(this));
        AtomicIntegerFieldUpdaterTest.assertEquals((int)1, (int)a.get(this));
    }
}

