/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicIntegerTest
extends JSR166TestCase {
    final int[] VALUES = new int[]{Integer.MIN_VALUE, -1, 0, 1, 42, Integer.MAX_VALUE};

    public static void main(String[] args) {
        TestRunner.run((Test)AtomicIntegerTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicIntegerTest.class);
    }

    public void testConstructor() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.get());
    }

    public void testConstructor2() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((int)0, (int)ai.get());
    }

    public void testGetSet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.get());
        ai.set(2);
        AtomicIntegerTest.assertEquals((int)2, (int)ai.get());
        ai.set(-3);
        AtomicIntegerTest.assertEquals((int)-3, (int)ai.get());
    }

    public void testGetLazySet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.get());
        ai.lazySet(2);
        AtomicIntegerTest.assertEquals((int)2, (int)ai.get());
        ai.lazySet(-3);
        AtomicIntegerTest.assertEquals((int)-3, (int)ai.get());
    }

    public void testCompareAndSet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertTrue((boolean)ai.compareAndSet(1, 2));
        AtomicIntegerTest.assertTrue((boolean)ai.compareAndSet(2, -4));
        AtomicIntegerTest.assertEquals((int)-4, (int)ai.get());
        AtomicIntegerTest.assertFalse((boolean)ai.compareAndSet(-5, 7));
        AtomicIntegerTest.assertEquals((int)-4, (int)ai.get());
        AtomicIntegerTest.assertTrue((boolean)ai.compareAndSet(-4, 7));
        AtomicIntegerTest.assertEquals((int)7, (int)ai.get());
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicInteger ai = new AtomicInteger(1);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!ai.compareAndSet(2, 3)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicIntegerTest.assertTrue((boolean)ai.compareAndSet(1, 2));
        t.join(LONG_DELAY_MS);
        AtomicIntegerTest.assertFalse((boolean)t.isAlive());
        AtomicIntegerTest.assertEquals((int)ai.get(), (int)3);
    }

    public void testWeakCompareAndSet() {
        AtomicInteger ai = new AtomicInteger(1);
        while (!ai.weakCompareAndSet(1, 2)) {
        }
        while (!ai.weakCompareAndSet(2, -4)) {
        }
        AtomicIntegerTest.assertEquals((int)-4, (int)ai.get());
        while (!ai.weakCompareAndSet(-4, 7)) {
        }
        AtomicIntegerTest.assertEquals((int)7, (int)ai.get());
    }

    public void testGetAndSet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.getAndSet(0));
        AtomicIntegerTest.assertEquals((int)0, (int)ai.getAndSet(-10));
        AtomicIntegerTest.assertEquals((int)-10, (int)ai.getAndSet(1));
    }

    public void testGetAndAdd() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.getAndAdd(2));
        AtomicIntegerTest.assertEquals((int)3, (int)ai.get());
        AtomicIntegerTest.assertEquals((int)3, (int)ai.getAndAdd(-4));
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.get());
    }

    public void testGetAndDecrement() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.getAndDecrement());
        AtomicIntegerTest.assertEquals((int)0, (int)ai.getAndDecrement());
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.getAndDecrement());
    }

    public void testGetAndIncrement() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)1, (int)ai.getAndIncrement());
        AtomicIntegerTest.assertEquals((int)2, (int)ai.get());
        ai.set(-2);
        AtomicIntegerTest.assertEquals((int)-2, (int)ai.getAndIncrement());
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.getAndIncrement());
        AtomicIntegerTest.assertEquals((int)0, (int)ai.getAndIncrement());
        AtomicIntegerTest.assertEquals((int)1, (int)ai.get());
    }

    public void testAddAndGet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)3, (int)ai.addAndGet(2));
        AtomicIntegerTest.assertEquals((int)3, (int)ai.get());
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.addAndGet(-4));
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.get());
    }

    public void testDecrementAndGet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)0, (int)ai.decrementAndGet());
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.decrementAndGet());
        AtomicIntegerTest.assertEquals((int)-2, (int)ai.decrementAndGet());
        AtomicIntegerTest.assertEquals((int)-2, (int)ai.get());
    }

    public void testIncrementAndGet() {
        AtomicInteger ai = new AtomicInteger(1);
        AtomicIntegerTest.assertEquals((int)2, (int)ai.incrementAndGet());
        AtomicIntegerTest.assertEquals((int)2, (int)ai.get());
        ai.set(-2);
        AtomicIntegerTest.assertEquals((int)-1, (int)ai.incrementAndGet());
        AtomicIntegerTest.assertEquals((int)0, (int)ai.incrementAndGet());
        AtomicIntegerTest.assertEquals((int)1, (int)ai.incrementAndGet());
        AtomicIntegerTest.assertEquals((int)1, (int)ai.get());
    }

    public void testSerialization() throws Exception {
        AtomicInteger l = new AtomicInteger();
        l.set(22);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicInteger r = (AtomicInteger)in.readObject();
        AtomicIntegerTest.assertEquals((int)l.get(), (int)r.get());
    }

    public void testToString() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((String)"0", (String)ai.toString());
        for (int x : this.VALUES) {
            ai.set(x);
            AtomicIntegerTest.assertEquals((String)ai.toString(), (String)Integer.toString(x));
        }
    }

    public void testIntValue() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((int)0, (int)ai.intValue());
        for (int x : this.VALUES) {
            ai.set(x);
            AtomicIntegerTest.assertEquals((int)x, (int)ai.intValue());
        }
    }

    public void testLongValue() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((long)0L, (long)ai.longValue());
        for (int x : this.VALUES) {
            ai.set(x);
            AtomicIntegerTest.assertEquals((long)x, (long)ai.longValue());
        }
    }

    public void testFloatValue() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(ai.floatValue()));
        for (int x : this.VALUES) {
            ai.set(x);
            AtomicIntegerTest.assertEquals((Object)Float.valueOf(x), (Object)Float.valueOf(ai.floatValue()));
        }
    }

    public void testDoubleValue() {
        AtomicInteger ai = new AtomicInteger();
        AtomicIntegerTest.assertEquals((Object)0.0, (Object)ai.doubleValue());
        for (int x : this.VALUES) {
            ai.set(x);
            AtomicIntegerTest.assertEquals((Object)x, (Object)ai.doubleValue());
        }
    }
}

