/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicLongTest
extends JSR166TestCase {
    final long[] VALUES = new long[]{Long.MIN_VALUE, Integer.MIN_VALUE, -1L, 0L, 1L, 42L, Integer.MAX_VALUE, Long.MAX_VALUE};

    public static void main(String[] args) {
        TestRunner.run((Test)AtomicLongTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicLongTest.class);
    }

    public void testConstructor() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.get());
    }

    public void testConstructor2() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((long)0L, (long)ai.get());
    }

    public void testGetSet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.get());
        ai.set(2L);
        AtomicLongTest.assertEquals((long)2L, (long)ai.get());
        ai.set(-3L);
        AtomicLongTest.assertEquals((long)-3L, (long)ai.get());
    }

    public void testGetLazySet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.get());
        ai.lazySet(2L);
        AtomicLongTest.assertEquals((long)2L, (long)ai.get());
        ai.lazySet(-3L);
        AtomicLongTest.assertEquals((long)-3L, (long)ai.get());
    }

    public void testCompareAndSet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertTrue((boolean)ai.compareAndSet(1L, 2L));
        AtomicLongTest.assertTrue((boolean)ai.compareAndSet(2L, -4L));
        AtomicLongTest.assertEquals((long)-4L, (long)ai.get());
        AtomicLongTest.assertFalse((boolean)ai.compareAndSet(-5L, 7L));
        AtomicLongTest.assertEquals((long)-4L, (long)ai.get());
        AtomicLongTest.assertTrue((boolean)ai.compareAndSet(-4L, 7L));
        AtomicLongTest.assertEquals((long)7L, (long)ai.get());
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicLong ai = new AtomicLong(1L);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!ai.compareAndSet(2L, 3L)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicLongTest.assertTrue((boolean)ai.compareAndSet(1L, 2L));
        t.join(LONG_DELAY_MS);
        AtomicLongTest.assertFalse((boolean)t.isAlive());
        AtomicLongTest.assertEquals((long)ai.get(), (long)3L);
    }

    public void testWeakCompareAndSet() {
        AtomicLong ai = new AtomicLong(1L);
        while (!ai.weakCompareAndSet(1L, 2L)) {
        }
        while (!ai.weakCompareAndSet(2L, -4L)) {
        }
        AtomicLongTest.assertEquals((long)-4L, (long)ai.get());
        while (!ai.weakCompareAndSet(-4L, 7L)) {
        }
        AtomicLongTest.assertEquals((long)7L, (long)ai.get());
    }

    public void testGetAndSet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.getAndSet(0L));
        AtomicLongTest.assertEquals((long)0L, (long)ai.getAndSet(-10L));
        AtomicLongTest.assertEquals((long)-10L, (long)ai.getAndSet(1L));
    }

    public void testGetAndAdd() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.getAndAdd(2L));
        AtomicLongTest.assertEquals((long)3L, (long)ai.get());
        AtomicLongTest.assertEquals((long)3L, (long)ai.getAndAdd(-4L));
        AtomicLongTest.assertEquals((long)-1L, (long)ai.get());
    }

    public void testGetAndDecrement() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.getAndDecrement());
        AtomicLongTest.assertEquals((long)0L, (long)ai.getAndDecrement());
        AtomicLongTest.assertEquals((long)-1L, (long)ai.getAndDecrement());
    }

    public void testGetAndIncrement() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)1L, (long)ai.getAndIncrement());
        AtomicLongTest.assertEquals((long)2L, (long)ai.get());
        ai.set(-2L);
        AtomicLongTest.assertEquals((long)-2L, (long)ai.getAndIncrement());
        AtomicLongTest.assertEquals((long)-1L, (long)ai.getAndIncrement());
        AtomicLongTest.assertEquals((long)0L, (long)ai.getAndIncrement());
        AtomicLongTest.assertEquals((long)1L, (long)ai.get());
    }

    public void testAddAndGet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)3L, (long)ai.addAndGet(2L));
        AtomicLongTest.assertEquals((long)3L, (long)ai.get());
        AtomicLongTest.assertEquals((long)-1L, (long)ai.addAndGet(-4L));
        AtomicLongTest.assertEquals((long)-1L, (long)ai.get());
    }

    public void testDecrementAndGet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)0L, (long)ai.decrementAndGet());
        AtomicLongTest.assertEquals((long)-1L, (long)ai.decrementAndGet());
        AtomicLongTest.assertEquals((long)-2L, (long)ai.decrementAndGet());
        AtomicLongTest.assertEquals((long)-2L, (long)ai.get());
    }

    public void testIncrementAndGet() {
        AtomicLong ai = new AtomicLong(1L);
        AtomicLongTest.assertEquals((long)2L, (long)ai.incrementAndGet());
        AtomicLongTest.assertEquals((long)2L, (long)ai.get());
        ai.set(-2L);
        AtomicLongTest.assertEquals((long)-1L, (long)ai.incrementAndGet());
        AtomicLongTest.assertEquals((long)0L, (long)ai.incrementAndGet());
        AtomicLongTest.assertEquals((long)1L, (long)ai.incrementAndGet());
        AtomicLongTest.assertEquals((long)1L, (long)ai.get());
    }

    public void testSerialization() throws Exception {
        AtomicLong l = new AtomicLong();
        l.set(-22L);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicLong r = (AtomicLong)in.readObject();
        AtomicLongTest.assertEquals((long)l.get(), (long)r.get());
    }

    public void testToString() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((String)"0", (String)ai.toString());
        for (long i : this.VALUES) {
            ai.set(i);
            AtomicLongTest.assertEquals((String)ai.toString(), (String)Long.toString(i));
        }
    }

    public void testIntValue() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((int)0, (int)ai.intValue());
        for (long x : this.VALUES) {
            ai.set(x);
            AtomicLongTest.assertEquals((int)((int)x), (int)ai.intValue());
        }
    }

    public void testLongValue() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((long)0L, (long)ai.longValue());
        for (long x : this.VALUES) {
            ai.set(x);
            AtomicLongTest.assertEquals((long)x, (long)ai.longValue());
        }
    }

    public void testFloatValue() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(ai.floatValue()));
        for (long x : this.VALUES) {
            ai.set(x);
            AtomicLongTest.assertEquals((Object)Float.valueOf(x), (Object)Float.valueOf(ai.floatValue()));
        }
    }

    public void testDoubleValue() {
        AtomicLong ai = new AtomicLong();
        AtomicLongTest.assertEquals((Object)0.0, (Object)ai.doubleValue());
        for (long x : this.VALUES) {
            ai.set(x);
            AtomicLongTest.assertEquals((Object)x, (Object)ai.doubleValue());
        }
    }
}

