/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.atomic.AtomicMarkableReference;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicMarkableReferenceTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AtomicMarkableReferenceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicMarkableReferenceTest.class);
    }

    public void testConstructor() {
        AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReference<Object> a2 = new AtomicMarkableReference<Object>(null, true);
        AtomicMarkableReferenceTest.assertNull(a2.getReference());
        AtomicMarkableReferenceTest.assertTrue((boolean)a2.isMarked());
    }

    public void testGetSet() {
        boolean[] mark = new boolean[1];
        AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        ai.set(two, false);
        AtomicMarkableReferenceTest.assertSame((Object)two, (Object)ai.getReference());
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        ai.set(one, true);
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.getReference());
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertTrue((boolean)mark[0]);
    }

    public void testAttemptMark() {
        boolean[] mark = new boolean[1];
        AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.attemptMark(one, true));
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertTrue((boolean)mark[0]);
    }

    public void testCompareAndSet() {
        boolean[] mark = new boolean[1];
        AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two, false, false));
        AtomicMarkableReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.compareAndSet(two, m3, false, true));
        AtomicMarkableReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertTrue((boolean)mark[0]);
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.compareAndSet(two, m3, true, true));
        AtomicMarkableReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertTrue((boolean)mark[0]);
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!ai.compareAndSet(JSR166TestCase.two, JSR166TestCase.three, false, false)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two, false, false));
        t.join(LONG_DELAY_MS);
        AtomicMarkableReferenceTest.assertFalse((boolean)t.isAlive());
        AtomicMarkableReferenceTest.assertSame((Object)ai.getReference(), (Object)three);
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
    }

    public void testCompareAndSetInMultipleThreads2() throws Exception {
        final AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!ai.compareAndSet(JSR166TestCase.one, JSR166TestCase.one, true, false)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicMarkableReferenceTest.assertTrue((boolean)ai.compareAndSet(one, one, false, true));
        t.join(LONG_DELAY_MS);
        AtomicMarkableReferenceTest.assertFalse((boolean)t.isAlive());
        AtomicMarkableReferenceTest.assertSame((Object)ai.getReference(), (Object)one);
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
    }

    public void testWeakCompareAndSet() {
        boolean[] mark = new boolean[1];
        AtomicMarkableReference<Integer> ai = new AtomicMarkableReference<Integer>(one, false);
        AtomicMarkableReferenceTest.assertSame((Object)one, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)ai.isMarked());
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        while (!ai.weakCompareAndSet(one, two, false, false)) {
        }
        AtomicMarkableReferenceTest.assertSame((Object)two, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertFalse((boolean)mark[0]);
        while (!ai.weakCompareAndSet(two, m3, false, true)) {
        }
        AtomicMarkableReferenceTest.assertSame((Object)m3, (Object)ai.get(mark));
        AtomicMarkableReferenceTest.assertTrue((boolean)mark[0]);
    }
}

