/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicReferenceArrayTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AtomicReferenceArrayTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicReferenceArrayTest.class);
    }

    public void testConstructor() {
        AtomicReferenceArray ai = new AtomicReferenceArray(20);
        for (int i = 0; i < 20; ++i) {
            AtomicReferenceArrayTest.assertNull(ai.get(i));
        }
    }

    public void testConstructor2NPE() {
        try {
            E[] a = null;
            AtomicReferenceArray ai = new AtomicReferenceArray(a);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        Integer[] a = new Integer[]{two, one, three, four, seven};
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(a);
        AtomicReferenceArrayTest.assertEquals((int)a.length, (int)ai.length());
        for (int i = 0; i < a.length; ++i) {
            AtomicReferenceArrayTest.assertEquals((Object)a[i], (Object)ai.get(i));
        }
    }

    public void testIndexing() {
        AtomicReferenceArray ai = new AtomicReferenceArray(20);
        try {
            ai.get(20);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.get(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(20, null);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException success) {
            // empty catch block
        }
        try {
            ai.set(-1, null);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, one);
            AtomicReferenceArrayTest.assertSame((Object)one, ai.get(i));
            ai.set(i, two);
            AtomicReferenceArrayTest.assertSame((Object)two, ai.get(i));
            ai.set(i, m3);
            AtomicReferenceArrayTest.assertSame((Object)m3, ai.get(i));
        }
    }

    public void testGetLazySet() {
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ai.lazySet(i, one);
            AtomicReferenceArrayTest.assertSame((Object)one, ai.get(i));
            ai.lazySet(i, two);
            AtomicReferenceArrayTest.assertSame((Object)two, ai.get(i));
            ai.lazySet(i, m3);
            AtomicReferenceArrayTest.assertSame((Object)m3, ai.get(i));
        }
    }

    public void testCompareAndSet() {
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, one);
            AtomicReferenceArrayTest.assertTrue((boolean)ai.compareAndSet(i, one, two));
            AtomicReferenceArrayTest.assertTrue((boolean)ai.compareAndSet(i, two, m4));
            AtomicReferenceArrayTest.assertSame((Object)m4, ai.get(i));
            AtomicReferenceArrayTest.assertFalse((boolean)ai.compareAndSet(i, m5, seven));
            AtomicReferenceArrayTest.assertSame((Object)m4, ai.get(i));
            AtomicReferenceArrayTest.assertTrue((boolean)ai.compareAndSet(i, m4, seven));
            AtomicReferenceArrayTest.assertSame((Object)seven, ai.get(i));
        }
    }

    public void testCompareAndSetInMultipleThreads() throws InterruptedException {
        final AtomicReferenceArray<Integer> a = new AtomicReferenceArray<Integer>(1);
        a.set(0, one);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!a.compareAndSet(0, JSR166TestCase.two, JSR166TestCase.three)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicReferenceArrayTest.assertTrue((boolean)a.compareAndSet(0, one, two));
        t.join(LONG_DELAY_MS);
        AtomicReferenceArrayTest.assertFalse((boolean)t.isAlive());
        AtomicReferenceArrayTest.assertSame(a.get(0), (Object)three);
    }

    public void testWeakCompareAndSet() {
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, one);
            while (!ai.weakCompareAndSet(i, one, two)) {
            }
            while (!ai.weakCompareAndSet(i, two, m4)) {
            }
            AtomicReferenceArrayTest.assertSame((Object)m4, ai.get(i));
            while (!ai.weakCompareAndSet(i, m4, seven)) {
            }
            AtomicReferenceArrayTest.assertSame((Object)seven, ai.get(i));
        }
    }

    public void testGetAndSet() {
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            ai.set(i, one);
            AtomicReferenceArrayTest.assertSame((Object)one, (Object)ai.getAndSet(i, zero));
            AtomicReferenceArrayTest.assertSame((Object)zero, (Object)ai.getAndSet(i, m10));
            AtomicReferenceArrayTest.assertSame((Object)m10, (Object)ai.getAndSet(i, one));
        }
    }

    public void testSerialization() throws Exception {
        AtomicReferenceArray<Integer> l = new AtomicReferenceArray<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            l.set(i, new Integer(-i));
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicReferenceArray r = (AtomicReferenceArray)in.readObject();
        AtomicReferenceArrayTest.assertEquals((int)l.length(), (int)r.length());
        for (int i = 0; i < 20; ++i) {
            AtomicReferenceArrayTest.assertEquals(r.get(i), l.get(i));
        }
    }

    public void testToString() {
        Object[] a = new Integer[]{two, one, three, four, seven};
        AtomicReferenceArray<Integer> ai = new AtomicReferenceArray<Integer>(a);
        AtomicReferenceArrayTest.assertEquals((String)Arrays.toString(a), (String)ai.toString());
    }
}

