/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicReferenceFieldUpdaterTest
extends JSR166TestCase {
    volatile Integer x = null;
    Object z;
    Integer w;

    public static void main(String[] args) {
        TestRunner.run((Test)AtomicReferenceFieldUpdaterTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicReferenceFieldUpdaterTest.class);
    }

    public void testConstructor() {
        try {
            AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "y");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "z");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "w");
            this.shouldThrow();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = one;
        AtomicReferenceFieldUpdaterTest.assertSame((Object)one, (Object)a.get(this));
        a.set(this, two);
        AtomicReferenceFieldUpdaterTest.assertSame((Object)two, (Object)a.get(this));
        a.set(this, m3);
        AtomicReferenceFieldUpdaterTest.assertSame((Object)m3, (Object)a.get(this));
    }

    public void testGetLazySet() {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = one;
        AtomicReferenceFieldUpdaterTest.assertSame((Object)one, (Object)a.get(this));
        a.lazySet(this, two);
        AtomicReferenceFieldUpdaterTest.assertSame((Object)two, (Object)a.get(this));
        a.lazySet(this, m3);
        AtomicReferenceFieldUpdaterTest.assertSame((Object)m3, (Object)a.get(this));
    }

    public void testCompareAndSet() {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = one;
        AtomicReferenceFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, one, two));
        AtomicReferenceFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, two, m4));
        AtomicReferenceFieldUpdaterTest.assertSame((Object)m4, (Object)a.get(this));
        AtomicReferenceFieldUpdaterTest.assertFalse((boolean)a.compareAndSet(this, m5, seven));
        AtomicReferenceFieldUpdaterTest.assertFalse((seven == a.get(this) ? 1 : 0) != 0);
        AtomicReferenceFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, m4, seven));
        AtomicReferenceFieldUpdaterTest.assertSame((Object)seven, (Object)a.get(this));
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        this.x = one;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!a.compareAndSet(AtomicReferenceFieldUpdaterTest.this, JSR166TestCase.two, JSR166TestCase.three)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicReferenceFieldUpdaterTest.assertTrue((boolean)a.compareAndSet(this, one, two));
        t.join(LONG_DELAY_MS);
        AtomicReferenceFieldUpdaterTest.assertFalse((boolean)t.isAlive());
        AtomicReferenceFieldUpdaterTest.assertSame((Object)a.get(this), (Object)three);
    }

    public void testWeakCompareAndSet() {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = one;
        while (!a.weakCompareAndSet(this, one, two)) {
        }
        while (!a.weakCompareAndSet(this, two, m4)) {
        }
        AtomicReferenceFieldUpdaterTest.assertSame((Object)m4, (Object)a.get(this));
        while (!a.weakCompareAndSet(this, m4, seven)) {
        }
        AtomicReferenceFieldUpdaterTest.assertSame((Object)seven, (Object)a.get(this));
    }

    public void testGetAndSet() {
        AtomicReferenceFieldUpdater<AtomicReferenceFieldUpdaterTest, Integer> a;
        try {
            a = AtomicReferenceFieldUpdater.newUpdater(AtomicReferenceFieldUpdaterTest.class, Integer.class, "x");
        }
        catch (RuntimeException ok) {
            return;
        }
        this.x = one;
        AtomicReferenceFieldUpdaterTest.assertSame((Object)one, (Object)a.getAndSet(this, zero));
        AtomicReferenceFieldUpdaterTest.assertSame((Object)zero, (Object)a.getAndSet(this, m10));
        AtomicReferenceFieldUpdaterTest.assertSame((Object)m10, (Object)a.getAndSet(this, 1));
    }
}

