/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AtomicReferenceTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AtomicReferenceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AtomicReferenceTest.class);
    }

    public void testConstructor() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertSame((Object)one, (Object)ai.get());
    }

    public void testConstructor2() {
        AtomicReference ai = new AtomicReference();
        AtomicReferenceTest.assertNull(ai.get());
    }

    public void testGetSet() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertSame((Object)one, (Object)ai.get());
        ai.set(two);
        AtomicReferenceTest.assertSame((Object)two, (Object)ai.get());
        ai.set(m3);
        AtomicReferenceTest.assertSame((Object)m3, (Object)ai.get());
    }

    public void testGetLazySet() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertSame((Object)one, (Object)ai.get());
        ai.lazySet(two);
        AtomicReferenceTest.assertSame((Object)two, (Object)ai.get());
        ai.lazySet(m3);
        AtomicReferenceTest.assertSame((Object)m3, (Object)ai.get());
    }

    public void testCompareAndSet() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two));
        AtomicReferenceTest.assertTrue((boolean)ai.compareAndSet(two, m4));
        AtomicReferenceTest.assertSame((Object)m4, (Object)ai.get());
        AtomicReferenceTest.assertFalse((boolean)ai.compareAndSet(m5, seven));
        AtomicReferenceTest.assertSame((Object)m4, (Object)ai.get());
        AtomicReferenceTest.assertTrue((boolean)ai.compareAndSet(m4, seven));
        AtomicReferenceTest.assertSame((Object)seven, (Object)ai.get());
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!ai.compareAndSet(JSR166TestCase.two, JSR166TestCase.three)) {
                    Thread.yield();
                }
            }
        });
        t.start();
        AtomicReferenceTest.assertTrue((boolean)ai.compareAndSet(one, two));
        t.join(LONG_DELAY_MS);
        AtomicReferenceTest.assertFalse((boolean)t.isAlive());
        AtomicReferenceTest.assertSame((Object)ai.get(), (Object)three);
    }

    public void testWeakCompareAndSet() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        while (!ai.weakCompareAndSet(one, two)) {
        }
        while (!ai.weakCompareAndSet(two, m4)) {
        }
        AtomicReferenceTest.assertSame((Object)m4, (Object)ai.get());
        while (!ai.weakCompareAndSet(m4, seven)) {
        }
        AtomicReferenceTest.assertSame((Object)seven, (Object)ai.get());
    }

    public void testGetAndSet() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertSame((Object)one, (Object)ai.getAndSet(zero));
        AtomicReferenceTest.assertSame((Object)zero, (Object)ai.getAndSet(m10));
        AtomicReferenceTest.assertSame((Object)m10, (Object)ai.getAndSet(one));
    }

    public void testSerialization() throws Exception {
        AtomicReference<Integer> l = new AtomicReference<Integer>();
        l.set(one);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        AtomicReference r = (AtomicReference)in.readObject();
        AtomicReferenceTest.assertEquals(l.get(), r.get());
    }

    public void testToString() {
        AtomicReference<Integer> ai = new AtomicReference<Integer>(one);
        AtomicReferenceTest.assertEquals((String)ai.toString(), (String)one.toString());
        ai.set(two);
        AtomicReferenceTest.assertEquals((String)ai.toString(), (String)two.toString());
    }
}

