/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public abstract class BlockingQueueTest
extends JSR166TestCase {
    public Test testSuite() {
        return new TestSuite(((Object)((Object)this)).getClass());
    }

    protected abstract BlockingQueue emptyCollection();

    public void testTimedPollWithOffer() throws InterruptedException {
        final BlockingQueue q = this.emptyCollection();
        final JSR166TestCase.CheckedBarrier barrier = new JSR166TestCase.CheckedBarrier(this, 2);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                barrier.await();
                Assert.assertSame((Object)JSR166TestCase.zero, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Thread.currentThread().interrupt();
                try {
                    q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
                    BlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException success) {
                    // empty catch block
                }
                barrier.await();
                try {
                    q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                    BlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        barrier.await();
        BlockingQueueTest.assertTrue((boolean)q.offer(zero, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        barrier.await();
        this.sleep(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTakeFromEmptyBlocksInterruptibly() throws InterruptedException {
        final BlockingQueue q = this.emptyCollection();
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long t0 = System.nanoTime();
                threadStarted.countDown();
                try {
                    q.take();
                    BlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((BlockingQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        BlockingQueueTest.delay(SHORT_DELAY_MS);
        BlockingQueueTest.assertTrue((boolean)t.isAlive());
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTakeFromEmptyAfterInterrupt() throws InterruptedException {
        final BlockingQueue q = this.emptyCollection();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long t0 = System.nanoTime();
                Thread.currentThread().interrupt();
                try {
                    q.take();
                    BlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((BlockingQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.SMALL_DELAY_MS ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void XXXXtestFails() {
        BlockingQueueTest.fail((String)this.emptyCollection().getClass().toString());
    }
}

