/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConcurrentLinkedDequeTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ConcurrentLinkedDequeTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ConcurrentLinkedDequeTest.class);
    }

    private ConcurrentLinkedDeque<Integer> populatedDeque(int n) {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        ConcurrentLinkedDequeTest.assertFalse((boolean)q.isEmpty());
        ConcurrentLinkedDequeTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        ConcurrentLinkedDequeTest.assertTrue((boolean)new ConcurrentLinkedDeque().isEmpty());
        ConcurrentLinkedDequeTest.assertEquals((int)0, (int)new ConcurrentLinkedDeque().size());
    }

    public void testConstructor3() {
        try {
            ConcurrentLinkedDeque q = new ConcurrentLinkedDeque(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmpty() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
        q.add(one);
        ConcurrentLinkedDequeTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        q.remove();
        q.remove();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testPushNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.push(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPush() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(3);
        q.pollLast();
        q.push(four);
        ConcurrentLinkedDequeTest.assertSame((Object)four, (Object)q.peekFirst());
    }

    public void testPop() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pop());
        }
        try {
            q.pop();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOfferNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferFirstNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.offerFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferLastNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.offerLast(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offer(zero));
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offer(one));
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testOfferFirst() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offerFirst(zero));
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offerFirst(one));
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekLast());
    }

    public void testOfferLast() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offerLast(zero));
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.offerLast(one));
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddFirstNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.addFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddLastNull() {
        try {
            ConcurrentLinkedDeque<Object> q = new ConcurrentLinkedDeque<Object>();
            q.addLast(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAdd() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.add(zero));
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.add(one));
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddFirst() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        q.addFirst(zero);
        q.addFirst(one);
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekLast());
    }

    public void testAddLast() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        q.addLast(zero);
        q.addLast(one);
        ConcurrentLinkedDequeTest.assertSame((Object)zero, q.peekFirst());
        ConcurrentLinkedDequeTest.assertSame((Object)one, q.peekLast());
    }

    public void testAddAll1() {
        try {
            ConcurrentLinkedDeque q = new ConcurrentLinkedDeque();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        ConcurrentLinkedDequeTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPollFirst() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.pollFirst());
    }

    public void testPollLast() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.pollLast());
    }

    public void testPoll() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.poll());
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.poll());
    }

    public void testPeek() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.peek());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.poll());
            ConcurrentLinkedDequeTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peek());
    }

    public void testElement() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.element());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(i));
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.remove(i));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.contains(i));
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(i));
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.remove(i));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.contains(i));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.remove(i + 1));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.contains(i + 1));
        }
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testPeekFirst() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.peekFirst());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
            ConcurrentLinkedDequeTest.assertTrue((q.peekFirst() == null || !((Object)q.peekFirst()).equals(i) ? 1 : 0) != 0);
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testPeekLast() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.peekLast());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollLast());
            ConcurrentLinkedDequeTest.assertTrue((q.peekLast() == null || !((Object)q.peekLast()).equals(i) ? 1 : 0) != 0);
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peekLast());
    }

    public void testFirstElement() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.getFirst());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        try {
            q.getFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLastElement() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.getLast());
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        try {
            q.getLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirst() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.removeFirst());
        }
        try {
            q.removeFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testRemoveLast() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            ConcurrentLinkedDequeTest.assertEquals((Object)i, (Object)q.removeLast());
        }
        try {
            q.removeLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ConcurrentLinkedDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirstOccurrence() {
        int i;
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.removeFirstOccurrence(new Integer(i + 1)));
        }
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveLastOccurrence() {
        int i;
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.removeLastOccurrence(new Integer(i + 1)));
        }
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            ConcurrentLinkedDequeTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        q.clear();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
        ConcurrentLinkedDequeTest.assertEquals((int)0, (int)q.size());
        q.add(one);
        ConcurrentLinkedDequeTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        ConcurrentLinkedDeque<Integer> p = new ConcurrentLinkedDeque<Integer>();
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentLinkedDequeTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ConcurrentLinkedDequeTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        ConcurrentLinkedDeque<Integer> p = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ConcurrentLinkedDequeTest.assertFalse((boolean)changed);
            } else {
                ConcurrentLinkedDequeTest.assertTrue((boolean)changed);
            }
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentLinkedDequeTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
            ConcurrentLinkedDeque<Integer> p = this.populatedDeque(i);
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.removeAll(p));
            ConcurrentLinkedDequeTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.remove();
                ConcurrentLinkedDequeTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testToArray() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            ConcurrentLinkedDequeTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        ConcurrentLinkedDequeTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            ConcurrentLinkedDequeTest.assertSame((Object)ints[i], (Object)q.poll());
        }
    }

    public void testToArray_NullArg() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        try {
            q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        try {
            q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentLinkedDequeTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentLinkedDequeTest.assertEquals((Object)(++k), it.next());
        }
        ConcurrentLinkedDequeTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        ConcurrentLinkedDequeTest.assertEquals((String)"deque should be empty again", (int)0, (int)q.size());
    }

    public void testIteratorRemove() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = 1; j2 <= max; ++j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.iterator();
            for (j = 1; j <= split; ++j) {
                ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.iterator();
            for (j = split + 1; j <= max; ++j) {
                ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ConcurrentLinkedDequeTest.assertFalse((boolean)it.hasNext());
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testDescendingIterator() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        int i = 0;
        Iterator<Integer> it = q.descendingIterator();
        while (it.hasNext()) {
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentLinkedDequeTest.assertEquals((int)i, (int)20);
        ConcurrentLinkedDequeTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
    }

    public void testDescendingIteratorOrdering() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        for (int iters = 0; iters < 100; ++iters) {
            q.add(new Integer(3));
            q.add(new Integer(2));
            q.add(new Integer(1));
            int k = 0;
            Iterator it = q.descendingIterator();
            while (it.hasNext()) {
                ConcurrentLinkedDequeTest.assertEquals((Object)(++k), it.next());
            }
            ConcurrentLinkedDequeTest.assertEquals((int)3, (int)k);
            q.remove();
            q.remove();
            q.remove();
        }
    }

    public void testDescendingIteratorRemove() {
        ConcurrentLinkedDeque<Integer> q = new ConcurrentLinkedDeque<Integer>();
        Random rng = new Random();
        for (int iters = 0; iters < 100; ++iters) {
            int j;
            int max = rng.nextInt(5) + 2;
            int split = rng.nextInt(max - 1) + 1;
            for (int j2 = max; j2 >= 1; --j2) {
                q.add(new Integer(j2));
            }
            Iterator it = q.descendingIterator();
            for (j = 1; j <= split; ++j) {
                ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(j));
            }
            it.remove();
            ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(split + 1));
            for (j = 1; j <= split; ++j) {
                q.remove(new Integer(j));
            }
            it = q.descendingIterator();
            for (j = split + 1; j <= max; ++j) {
                ConcurrentLinkedDequeTest.assertEquals(it.next(), (Object)new Integer(j));
                it.remove();
            }
            ConcurrentLinkedDequeTest.assertFalse((boolean)it.hasNext());
            ConcurrentLinkedDequeTest.assertTrue((boolean)q.isEmpty());
        }
    }

    public void testToString() {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ConcurrentLinkedDequeTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        ConcurrentLinkedDeque<Integer> q = this.populatedDeque(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentLinkedDeque r = (ConcurrentLinkedDeque)in.readObject();
        ConcurrentLinkedDequeTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ConcurrentLinkedDequeTest.assertEquals((Object)q.remove(), r.remove());
        }
    }
}

