/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConcurrentSkipListSubMapTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ConcurrentSkipListSubMapTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ConcurrentSkipListSubMapTest.class);
    }

    private static ConcurrentNavigableMap map5() {
        ConcurrentSkipListMap<Integer, String> map = new ConcurrentSkipListMap<Integer, String>();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.isEmpty());
        map.put(zero, "Z");
        map.put(one, "A");
        map.put(five, "E");
        map.put(three, "C");
        map.put(two, "B");
        map.put(four, "D");
        map.put(seven, "F");
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)7, (int)map.size());
        return map.subMap((Object)one, true, (Object)seven, false);
    }

    private static ConcurrentNavigableMap dmap5() {
        ConcurrentSkipListMap<Integer, String> map = new ConcurrentSkipListMap<Integer, String>();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.isEmpty());
        map.put(m1, "A");
        map.put(m5, "E");
        map.put(m3, "C");
        map.put(m2, "B");
        map.put(m4, "D");
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)map.size());
        return map.descendingMap();
    }

    private static ConcurrentNavigableMap map0() {
        ConcurrentSkipListMap map = new ConcurrentSkipListMap();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.isEmpty());
        return map.tailMap(one, true);
    }

    private static ConcurrentNavigableMap dmap0() {
        ConcurrentSkipListMap map = new ConcurrentSkipListMap();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.isEmpty());
        return map;
    }

    public void testClear() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        map.clear();
        ConcurrentSkipListSubMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testEquals() {
        ConcurrentNavigableMap map1 = ConcurrentSkipListSubMapTest.map5();
        ConcurrentNavigableMap map2 = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)map1, (Object)map2);
        ConcurrentSkipListSubMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map1.equals(map2));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testContainsKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(one));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testContainsValue() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsValue("A"));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testGet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((String)"A", (String)((String)map.get(one)));
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.map0();
        ConcurrentSkipListSubMapTest.assertNull(empty.get(one));
    }

    public void testIsEmpty() {
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.map0();
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.isEmpty());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testFirstKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, map.firstKey());
    }

    public void testLastKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, map.lastKey());
    }

    public void testKeySet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Set s = map.keySet();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(two));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(three));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(four));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(five));
    }

    public void testKeySetOrder() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)last, (Object)one);
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListSubMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
        }
    }

    public void testValues() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Collection s = map.values();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testKeySetToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        ConcurrentSkipListSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingKeySetToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ar[0] = m10;
        ConcurrentSkipListSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testValuesToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Collection v = map.values();
        Object[] ar = v.toArray();
        ArrayList<Object> s = new ArrayList<Object>(Arrays.asList(ar));
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Set s = map.entrySet();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            ConcurrentSkipListSubMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testPutAll() {
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.map0();
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        empty.putAll(map);
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)empty.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(two));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(three));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(four));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(five));
    }

    public void testPutIfAbsent() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        map.putIfAbsent(six, "Z");
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(six));
    }

    public void testPutIfAbsent2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", (Object)map.putIfAbsent(one, "Z"));
    }

    public void testReplace() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertNull((Object)map.replace(six, "Z"));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(six));
    }

    public void testReplace2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertNotNull((Object)map.replace(one, "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testReplaceValue() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.replace(one, "Z", "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(one));
    }

    public void testReplaceValue2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.replace(one, "A", "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"Z", map.get(one));
    }

    public void testRemove() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        map.remove(five);
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(five));
    }

    public void testRemove2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(five));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", map.get(five));
        map.remove(five, "E");
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(five));
        map.remove(four, "A");
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(four));
    }

    public void testLowerEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e1 = map.lowerEntry(three);
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(six);
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(one);
        ConcurrentSkipListSubMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testHigherEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e1 = map.higherEntry(three);
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(five);
        ConcurrentSkipListSubMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(six);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testFloorEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e1 = map.floorEntry(three);
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(six);
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(one);
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testCeilingEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e1 = map.ceilingEntry(three);
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(five);
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(six);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testPollFirstEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, e.getKey());
        map.put(one, "A");
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, e.getKey());
        map.remove(four);
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertNull(e);
    }

    public void testPollLastEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        Map.Entry e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, e.getKey());
        map.put(five, "E");
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, e.getKey());
        map.remove(two);
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertNull(e);
    }

    public void testSize() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.map0();
        ConcurrentSkipListSubMapTest.assertEquals((int)0, (int)empty.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testToString() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            ConcurrentSkipListSubMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGet_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsValue_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map0();
            c.containsValue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutIfAbsent1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.putIfAbsent(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplace_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.replace(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReplaceValue_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.replace(null, one, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove2_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.map5();
            c.remove(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSerialization() throws Exception {
        ConcurrentNavigableMap q = ConcurrentSkipListSubMapTest.map5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentNavigableMap r = (ConcurrentNavigableMap)in.readObject();
        ConcurrentSkipListSubMapTest.assertEquals((int)q.size(), (int)r.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)q.equals(r));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testSubMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        SortedMap sm = map.subMap(two, four);
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(two));
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"C", sm.remove(three));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testSubMapContents2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        SortedMap sm = map.subMap(two, three);
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(three));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(two));
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertSame(sm.remove(three), null);
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testHeadMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        SortedMap sm = map.headMap(four);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(four));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)2, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, map.firstKey());
    }

    public void testTailMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.map5();
        SortedMap sm = map.tailMap(two);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(one));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(two));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(three));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(four));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)two, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)three, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        SortedMap ssm = sm.tailMap(four);
        ConcurrentSkipListSubMapTest.assertEquals((Object)four, (Object)ssm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)five, (Object)ssm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"D", ssm.remove(four));
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testDescendingClear() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        map.clear();
        ConcurrentSkipListSubMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testDescendingEquals() {
        ConcurrentNavigableMap map1 = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentNavigableMap map2 = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)map1, (Object)map2);
        ConcurrentSkipListSubMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map1.equals(map2));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testDescendingContainsKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testDescendingContainsValue() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsValue("A"));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testDescendingGet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((String)"A", (String)((String)map.get(m1)));
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.dmap0();
        ConcurrentSkipListSubMapTest.assertNull(empty.get(m1));
    }

    public void testDescendingIsEmpty() {
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.dmap0();
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.isEmpty());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testDescendingFirstKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, map.firstKey());
    }

    public void testDescendingLastKey() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, map.lastKey());
    }

    public void testDescendingKeySet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Set s = map.keySet();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(m2));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(m3));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(m4));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains(m5));
    }

    public void testDescendingKeySetOrder() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)last, (Object)m1);
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            ConcurrentSkipListSubMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
        }
    }

    public void testDescendingValues() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Collection s = map.values();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testDescendingAscendingKeySetToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        ConcurrentSkipListSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingDescendingKeySetToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        NavigableSet s = map.descendingKeySet();
        Object[] ar = s.toArray();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ar[0] = m10;
        ConcurrentSkipListSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingValuesToArray() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Collection v = map.values();
        Object[] ar = v.toArray();
        ArrayList<Object> s = new ArrayList<Object>(Arrays.asList(ar));
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)ar.length);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("A"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("B"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("C"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("D"));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testDescendingEntrySet() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Set s = map.entrySet();
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            ConcurrentSkipListSubMapTest.assertTrue((e.getKey().equals(m1) && e.getValue().equals("A") || e.getKey().equals(m2) && e.getValue().equals("B") || e.getKey().equals(m3) && e.getValue().equals("C") || e.getKey().equals(m4) && e.getValue().equals("D") || e.getKey().equals(m5) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testDescendingPutAll() {
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.dmap0();
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        empty.putAll(map);
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)empty.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(m3));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(m4));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)empty.containsKey(m5));
    }

    public void testDescendingPutIfAbsent() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        map.putIfAbsent(six, "Z");
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(six));
    }

    public void testDescendingPutIfAbsent2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", (Object)map.putIfAbsent(m1, "Z"));
    }

    public void testDescendingReplace() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertNull((Object)map.replace(six, "Z"));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(six));
    }

    public void testDescendingReplace2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertNotNull((Object)map.replace(m1, "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"Z", map.get(m1));
    }

    public void testDescendingReplaceValue() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(m1));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.replace(m1, "Z", "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(m1));
    }

    public void testDescendingReplaceValue2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", map.get(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.replace(m1, "A", "Z"));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"Z", map.get(m1));
    }

    public void testDescendingRemove() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        map.remove(m5);
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(m5));
    }

    public void testDescendingRemove2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(m5));
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", map.get(m5));
        map.remove(m5, "E");
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(m5));
        map.remove(m4, "A");
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)map.containsKey(m4));
    }

    public void testDescendingLowerEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e1 = map.lowerEntry(m3);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(m6);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(m1);
        ConcurrentSkipListSubMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testDescendingHigherEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e1 = map.higherEntry(m3);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(m5);
        ConcurrentSkipListSubMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(m6);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testDescendingFloorEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e1 = map.floorEntry(m3);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(m6);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(m1);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testDescendingCeilingEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e1 = map.ceilingEntry(m3);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(m5);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(m6);
        ConcurrentSkipListSubMapTest.assertNull(e4);
    }

    public void testDescendingPollFirstEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, e.getKey());
        map.put(m1, "A");
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, e.getKey());
        map.remove(m4);
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollFirstEntry();
        ConcurrentSkipListSubMapTest.assertNull(e);
    }

    public void testDescendingPollLastEntry() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        Map.Entry e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, e.getKey());
        map.put(m5, "E");
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, e.getKey());
        map.remove(m2);
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        ConcurrentSkipListSubMapTest.assertNull(e);
    }

    public void testDescendingSize() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        ConcurrentNavigableMap empty = ConcurrentSkipListSubMapTest.dmap0();
        ConcurrentSkipListSubMapTest.assertEquals((int)0, (int)empty.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testDescendingToString() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            ConcurrentSkipListSubMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testDescendingGet_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingContainsKey_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingContainsValue_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap0();
            c.containsValue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingPut1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingPutIfAbsent1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.putIfAbsent(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingReplace_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.replace(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingReplaceValue_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.replace(null, m1, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingRemove1_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingRemove2_NullPointerException() {
        try {
            ConcurrentNavigableMap c = ConcurrentSkipListSubMapTest.dmap5();
            c.remove(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingSerialization() throws Exception {
        ConcurrentNavigableMap q = ConcurrentSkipListSubMapTest.dmap5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ConcurrentNavigableMap r = (ConcurrentNavigableMap)in.readObject();
        ConcurrentSkipListSubMapTest.assertEquals((int)q.size(), (int)r.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)q.equals(r));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testDescendingSubMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        SortedMap sm = map.subMap(m2, m4);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"C", sm.remove(m3));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testDescendingSubMapContents2() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        SortedMap sm = map.subMap(m2, m3);
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, sm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, sm.lastKey());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m3));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubMapTest.assertFalse((boolean)map.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertSame(sm.remove(m3), null);
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testDescendingHeadMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        SortedMap sm = map.headMap(m4);
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m1, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubMapTest.assertEquals((int)2, (int)map.size());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, map.firstKey());
    }

    public void testDescendingTailMapContents() {
        ConcurrentNavigableMap map = ConcurrentSkipListSubMapTest.dmap5();
        SortedMap sm = map.tailMap(m2);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m4));
        ConcurrentSkipListSubMapTest.assertTrue((boolean)sm.containsKey(m5));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, (Object)k);
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m2, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m3, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, e.getKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"E", e.getValue());
        ConcurrentSkipListSubMapTest.assertFalse((boolean)i.hasNext());
        SortedMap ssm = sm.tailMap(m4);
        ConcurrentSkipListSubMapTest.assertEquals((Object)m4, (Object)ssm.firstKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)m5, (Object)ssm.lastKey());
        ConcurrentSkipListSubMapTest.assertEquals((Object)"D", ssm.remove(m4));
        ConcurrentSkipListSubMapTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListSubMapTest.assertEquals((int)4, (int)map.size());
    }
}

