/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConcurrentSkipListSubSetTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ConcurrentSkipListSubSetTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ConcurrentSkipListSubSetTest.class);
    }

    private NavigableSet<Integer> populatedSet(int n) {
        int i;
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(new Integer(-n)));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(new Integer(n)));
        NavigableSet<Integer> s = q.subSet(new Integer(0), true, new Integer(n), false);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)s.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)n, (int)s.size());
        return s;
    }

    private NavigableSet set5() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        q.add(one);
        q.add(two);
        q.add(three);
        q.add(four);
        q.add(five);
        q.add(zero);
        q.add(seven);
        NavigableSet<Integer> s = q.subSet(one, true, seven, false);
        ConcurrentSkipListSubSetTest.assertEquals((int)5, (int)s.size());
        return s;
    }

    private NavigableSet dset5() {
        ConcurrentSkipListSet<Integer> q = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        q.add(m1);
        q.add(m2);
        q.add(m3);
        q.add(m4);
        q.add(m5);
        NavigableSet s = q.descendingSet();
        ConcurrentSkipListSubSetTest.assertEquals((int)5, (int)s.size());
        return s;
    }

    private static NavigableSet set0() {
        ConcurrentSkipListSet<Integer> set = new ConcurrentSkipListSet<Integer>();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)set.isEmpty());
        return set.tailSet(m1, true);
    }

    private static NavigableSet dset0() {
        ConcurrentSkipListSet set = new ConcurrentSkipListSet();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)set.isEmpty());
        return set;
    }

    public void testConstructor1() {
        ConcurrentSkipListSubSetTest.assertEquals((int)0, (int)ConcurrentSkipListSubSetTest.set0().size());
    }

    public void testEmpty() {
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.pollFirst();
        q.pollFirst();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        NavigableSet<Integer> q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testAddNull() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.set0();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAdd() {
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(six));
    }

    public void testAddDup() {
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(six));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.add(six));
    }

    public void testAddNonComparable() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.set0();
            q.add(new Object());
            q.add(new Object());
            q.add(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.set0();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.set0();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.set0();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i + 20);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(19 - i);
        }
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)new Integer(i), q.pollFirst());
        }
    }

    public void testPoll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        ConcurrentSkipListSubSetTest.assertNull((Object)q.pollFirst());
    }

    public void testRemoveElement() {
        int i;
        NavigableSet<Integer> q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(i));
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.remove(i));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(i));
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(i));
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.remove(i));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(i));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.remove(i + 1));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(i + 1));
        }
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        NavigableSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.pollFirst();
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        NavigableSet<Integer> q = this.populatedSet(20);
        q.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        NavigableSet p = ConcurrentSkipListSubSetTest.set0();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ConcurrentSkipListSubSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        NavigableSet<Integer> p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ConcurrentSkipListSubSetTest.assertFalse((boolean)changed);
            } else {
                ConcurrentSkipListSubSetTest.assertTrue((boolean)changed);
            }
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            NavigableSet<Integer> q = this.populatedSet(20);
            NavigableSet<Integer> p = this.populatedSet(i);
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.removeAll(p));
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.pollFirst();
                ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testLower() {
        NavigableSet q = this.set5();
        Integer e1 = q.lower(three);
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)e1);
        Integer e2 = q.lower(six);
        ConcurrentSkipListSubSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.lower(one);
        ConcurrentSkipListSubSetTest.assertNull((Object)e3);
        Integer e4 = q.lower(zero);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testHigher() {
        NavigableSet q = this.set5();
        Integer e1 = q.higher(three);
        ConcurrentSkipListSubSetTest.assertEquals((Object)four, (Object)e1);
        Integer e2 = q.higher(zero);
        ConcurrentSkipListSubSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.higher(five);
        ConcurrentSkipListSubSetTest.assertNull((Object)e3);
        Integer e4 = q.higher(six);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testFloor() {
        NavigableSet q = this.set5();
        Integer e1 = q.floor(three);
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.floor(six);
        ConcurrentSkipListSubSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.floor(one);
        ConcurrentSkipListSubSetTest.assertEquals((Object)one, (Object)e3);
        Integer e4 = q.floor(zero);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testCeiling() {
        NavigableSet q = this.set5();
        Integer e1 = q.ceiling(three);
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.ceiling(zero);
        ConcurrentSkipListSubSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.ceiling(five);
        ConcurrentSkipListSubSetTest.assertEquals((Object)five, (Object)e3);
        Integer e4 = q.ceiling(six);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testToArray() {
        NavigableSet<Integer> q = this.populatedSet(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            ConcurrentSkipListSubSetTest.assertSame((Object)o[i], (Object)q.pollFirst());
        }
    }

    public void testToArray2() {
        NavigableSet<Integer> q = this.populatedSet(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        ConcurrentSkipListSubSetTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            ConcurrentSkipListSubSetTest.assertSame((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testIterator() {
        NavigableSet<Integer> q = this.populatedSet(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)20);
    }

    public void testEmptyIterator() {
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)0);
    }

    public void testIteratorRemove() {
        NavigableSet q = ConcurrentSkipListSubSetTest.set0();
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        ConcurrentSkipListSubSetTest.assertEquals(it.next(), (Object)new Integer(2));
        ConcurrentSkipListSubSetTest.assertEquals(it.next(), (Object)new Integer(3));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        NavigableSet<Integer> q = this.populatedSet(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        NavigableSet<Integer> q = this.populatedSet(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        NavigableSet r = (NavigableSet)in.readObject();
        ConcurrentSkipListSubSetTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)q.pollFirst(), r.pollFirst());
        }
    }

    public void testSubSetContents() {
        NavigableSet set = this.set5();
        SortedSet<Integer> sm = set.subSet(two, four);
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)set.contains(two));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.remove(three));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testSubSetContents2() {
        NavigableSet set = this.set5();
        SortedSet<Integer> sm = set.subSet(two, three);
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(three));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)set.contains(two));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.remove(three));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testHeadSetContents() {
        NavigableSet set = this.set5();
        SortedSet<Integer> sm = set.headSet(four);
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(one));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(four));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)2, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)four, set.first());
    }

    public void testTailSetContents() {
        NavigableSet set = this.set5();
        SortedSet<Integer> sm = set.tailSet(two);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(one));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(two));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(three));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(four));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)five, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        SortedSet<Integer> ssm = sm.tailSet(four);
        ConcurrentSkipListSubSetTest.assertEquals((Object)four, (Object)ssm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)five, (Object)ssm.last());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)ssm.remove(four));
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testDescendingSize() {
        int i;
        NavigableSet<Integer> q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testDescendingAddNull() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingAdd() {
        NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(m6));
    }

    public void testDescendingAddDup() {
        NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.add(m6));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.add(m6));
    }

    public void testDescendingAddNonComparable() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
            q.add(new Object());
            q.add(new Object());
            q.add(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testDescendingAddAll1() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingAddAll2() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingAddAll3() {
        try {
            NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i + 20);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(19 - i);
        }
        NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)new Integer(i), q.pollFirst());
        }
    }

    public void testDescendingPoll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        ConcurrentSkipListSubSetTest.assertNull((Object)q.pollFirst());
    }

    public void testDescendingRemoveElement() {
        int i;
        NavigableSet<Integer> q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.remove(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.remove(new Integer(i)));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.remove(new Integer(i + 1)));
        }
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testDescendingContains() {
        NavigableSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.pollFirst();
            ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testDescendingClear() {
        NavigableSet<Integer> q = this.populatedSet(20);
        q.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testDescendingContainsAll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        NavigableSet p = ConcurrentSkipListSubSetTest.dset0();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSubSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        ConcurrentSkipListSubSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testDescendingRetainAll() {
        NavigableSet<Integer> q = this.populatedSet(20);
        NavigableSet<Integer> p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                ConcurrentSkipListSubSetTest.assertFalse((boolean)changed);
            } else {
                ConcurrentSkipListSubSetTest.assertTrue((boolean)changed);
            }
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.containsAll(p));
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testDescendingRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            NavigableSet<Integer> q = this.populatedSet(20);
            NavigableSet<Integer> p = this.populatedSet(i);
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.removeAll(p));
            ConcurrentSkipListSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.pollFirst();
                ConcurrentSkipListSubSetTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testDescendingLower() {
        NavigableSet q = this.dset5();
        Integer e1 = q.lower(m3);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)e1);
        Integer e2 = q.lower(m6);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m5, (Object)e2);
        Integer e3 = q.lower(m1);
        ConcurrentSkipListSubSetTest.assertNull((Object)e3);
        Integer e4 = q.lower(zero);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testDescendingHigher() {
        NavigableSet q = this.dset5();
        Integer e1 = q.higher(m3);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m4, (Object)e1);
        Integer e2 = q.higher(zero);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m1, (Object)e2);
        Integer e3 = q.higher(m5);
        ConcurrentSkipListSubSetTest.assertNull((Object)e3);
        Integer e4 = q.higher(m6);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testDescendingFloor() {
        NavigableSet q = this.dset5();
        Integer e1 = q.floor(m3);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)e1);
        Integer e2 = q.floor(m6);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m5, (Object)e2);
        Integer e3 = q.floor(m1);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m1, (Object)e3);
        Integer e4 = q.floor(zero);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testDescendingCeiling() {
        NavigableSet q = this.dset5();
        Integer e1 = q.ceiling(m3);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)e1);
        Integer e2 = q.ceiling(zero);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m1, (Object)e2);
        Integer e3 = q.ceiling(m5);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m5, (Object)e3);
        Integer e4 = q.ceiling(m6);
        ConcurrentSkipListSubSetTest.assertNull((Object)e4);
    }

    public void testDescendingToArray() {
        NavigableSet<Integer> q = this.populatedSet(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)o[i], (Object)q.pollFirst());
        }
    }

    public void testDescendingToArray2() {
        NavigableSet<Integer> q = this.populatedSet(20);
        Object[] ints = new Integer[20];
        ConcurrentSkipListSubSetTest.assertSame((Object)ints, (Object)q.toArray(ints));
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testDescendingIterator() {
        NavigableSet<Integer> q = this.populatedSet(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)20);
    }

    public void testDescendingEmptyIterator() {
        NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            ConcurrentSkipListSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        ConcurrentSkipListSubSetTest.assertEquals((int)i, (int)0);
    }

    public void testDescendingIteratorRemove() {
        NavigableSet q = ConcurrentSkipListSubSetTest.dset0();
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        ConcurrentSkipListSubSetTest.assertEquals(it.next(), (Object)new Integer(2));
        ConcurrentSkipListSubSetTest.assertEquals(it.next(), (Object)new Integer(3));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testDescendingToString() {
        NavigableSet<Integer> q = this.populatedSet(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            ConcurrentSkipListSubSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testDescendingSerialization() throws Exception {
        NavigableSet<Integer> q = this.populatedSet(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        NavigableSet r = (NavigableSet)in.readObject();
        ConcurrentSkipListSubSetTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            ConcurrentSkipListSubSetTest.assertEquals((Object)q.pollFirst(), r.pollFirst());
        }
    }

    public void testDescendingSubSetContents() {
        NavigableSet set = this.dset5();
        SortedSet<Integer> sm = set.subSet(m2, m4);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertEquals((int)2, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m1));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m2));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m3));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m4));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m5));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)set.contains(m2));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.remove(m3));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testDescendingSubSetContents2() {
        NavigableSet set = this.dset5();
        SortedSet<Integer> sm = set.subSet(m2, m3);
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)sm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)sm.last());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m1));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m2));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m3));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m4));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m5));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        ConcurrentSkipListSubSetTest.assertFalse((boolean)set.contains(m2));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)0, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.remove(m3));
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testDescendingHeadSetContents() {
        NavigableSet set = this.dset5();
        SortedSet<Integer> sm = set.headSet(m4);
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m1));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m2));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m3));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m4));
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m5));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m1, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.isEmpty());
        ConcurrentSkipListSubSetTest.assertEquals((int)2, (int)set.size());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m4, set.first());
    }

    public void testDescendingTailSetContents() {
        NavigableSet set = this.dset5();
        SortedSet<Integer> sm = set.tailSet(m2);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)sm.contains(m1));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m2));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m3));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m4));
        ConcurrentSkipListSubSetTest.assertTrue((boolean)sm.contains(m5));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m2, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m3, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m4, (Object)k);
        k = (Integer)i.next();
        ConcurrentSkipListSubSetTest.assertEquals((Object)m5, (Object)k);
        ConcurrentSkipListSubSetTest.assertFalse((boolean)i.hasNext());
        SortedSet<Integer> ssm = sm.tailSet(m4);
        ConcurrentSkipListSubSetTest.assertEquals((Object)m4, (Object)ssm.first());
        ConcurrentSkipListSubSetTest.assertEquals((Object)m5, (Object)ssm.last());
        ConcurrentSkipListSubSetTest.assertTrue((boolean)ssm.remove(m4));
        ConcurrentSkipListSubSetTest.assertEquals((int)1, (int)ssm.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)3, (int)sm.size());
        ConcurrentSkipListSubSetTest.assertEquals((int)4, (int)set.size());
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            return ((Comparable)y).compareTo(x);
        }
    }
}

