/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CopyOnWriteArrayListTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)CopyOnWriteArrayListTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CopyOnWriteArrayListTest.class);
    }

    static CopyOnWriteArrayList populatedArray(int n) {
        CopyOnWriteArrayList<Integer> a = new CopyOnWriteArrayList<Integer>();
        CopyOnWriteArrayListTest.assertTrue((boolean)a.isEmpty());
        for (int i = 0; i < n; ++i) {
            a.add(new Integer(i));
        }
        CopyOnWriteArrayListTest.assertFalse((boolean)a.isEmpty());
        CopyOnWriteArrayListTest.assertEquals((int)n, (int)a.size());
        return a;
    }

    public void testConstructor() {
        CopyOnWriteArrayList a = new CopyOnWriteArrayList();
        CopyOnWriteArrayListTest.assertTrue((boolean)a.isEmpty());
    }

    public void testConstructor2() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 19; ++i) {
            ints[i] = new Integer(i);
        }
        CopyOnWriteArrayList<Integer> a = new CopyOnWriteArrayList<Integer>(ints);
        for (int i = 0; i < 20; ++i) {
            CopyOnWriteArrayListTest.assertEquals((Object)ints[i], (Object)a.get(i));
        }
    }

    public void testConstructor3() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 19; ++i) {
            ints[i] = new Integer(i);
        }
        CopyOnWriteArrayList<Integer> a = new CopyOnWriteArrayList<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            CopyOnWriteArrayListTest.assertEquals((Object)ints[i], (Object)a.get(i));
        }
    }

    public void testAddAll() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(three);
        v.add(four);
        v.add(five);
        full.addAll(v);
        CopyOnWriteArrayListTest.assertEquals((int)6, (int)full.size());
    }

    public void testAddAllAbsent() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(three);
        v.add(four);
        v.add(one);
        full.addAllAbsent(v);
        CopyOnWriteArrayListTest.assertEquals((int)5, (int)full.size());
    }

    public void testAddIfAbsent() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        full.addIfAbsent(one);
        CopyOnWriteArrayListTest.assertEquals((int)20, (int)full.size());
    }

    public void testAddIfAbsent2() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        full.addIfAbsent(three);
        CopyOnWriteArrayListTest.assertTrue((boolean)full.contains(three));
    }

    public void testClear() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        full.clear();
        CopyOnWriteArrayListTest.assertEquals((int)0, (int)full.size());
    }

    public void testClone() {
        CopyOnWriteArrayList l1 = CopyOnWriteArrayListTest.populatedArray(20);
        CopyOnWriteArrayList l2 = (CopyOnWriteArrayList)l1.clone();
        CopyOnWriteArrayListTest.assertEquals((Object)l1, (Object)l2);
        l1.clear();
        CopyOnWriteArrayListTest.assertFalse((boolean)l1.equals(l2));
    }

    public void testContains() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertTrue((boolean)full.contains(one));
        CopyOnWriteArrayListTest.assertFalse((boolean)full.contains(five));
    }

    public void testAddIndex() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        full.add(0, m1);
        CopyOnWriteArrayListTest.assertEquals((int)4, (int)full.size());
        CopyOnWriteArrayListTest.assertEquals((Object)m1, full.get(0));
        CopyOnWriteArrayListTest.assertEquals((Object)zero, full.get(1));
        full.add(2, m2);
        CopyOnWriteArrayListTest.assertEquals((int)5, (int)full.size());
        CopyOnWriteArrayListTest.assertEquals((Object)m2, full.get(2));
        CopyOnWriteArrayListTest.assertEquals((Object)two, full.get(4));
    }

    public void testEquals() {
        CopyOnWriteArrayList a = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayList b = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertTrue((boolean)a.equals(b));
        CopyOnWriteArrayListTest.assertTrue((boolean)b.equals(a));
        CopyOnWriteArrayListTest.assertEquals((int)a.hashCode(), (int)b.hashCode());
        a.add(m1);
        CopyOnWriteArrayListTest.assertFalse((boolean)a.equals(b));
        CopyOnWriteArrayListTest.assertFalse((boolean)b.equals(a));
        b.add(m1);
        CopyOnWriteArrayListTest.assertTrue((boolean)a.equals(b));
        CopyOnWriteArrayListTest.assertTrue((boolean)b.equals(a));
        CopyOnWriteArrayListTest.assertEquals((int)a.hashCode(), (int)b.hashCode());
    }

    public void testContainsAll() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(one);
        v.add(two);
        CopyOnWriteArrayListTest.assertTrue((boolean)full.containsAll(v));
        v.add(six);
        CopyOnWriteArrayListTest.assertFalse((boolean)full.containsAll(v));
    }

    public void testGet() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertEquals((Object)0, full.get(0));
    }

    public void testIndexOf() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertEquals((int)1, (int)full.indexOf(one));
        CopyOnWriteArrayListTest.assertEquals((int)-1, (int)full.indexOf("puppies"));
    }

    public void testIndexOf2() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertEquals((int)1, (int)full.indexOf(one, 0));
        CopyOnWriteArrayListTest.assertEquals((int)-1, (int)full.indexOf(one, 2));
    }

    public void testIsEmpty() {
        CopyOnWriteArrayList empty = new CopyOnWriteArrayList();
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        CopyOnWriteArrayListTest.assertTrue((boolean)empty.isEmpty());
        CopyOnWriteArrayListTest.assertFalse((boolean)full.isEmpty());
    }

    public void testIterator() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        Iterator i = full.iterator();
        int j = 0;
        while (i.hasNext()) {
            CopyOnWriteArrayListTest.assertEquals((Object)j, i.next());
            ++j;
        }
        CopyOnWriteArrayListTest.assertEquals((int)20, (int)j);
    }

    public void testIteratorRemove() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        Iterator it = full.iterator();
        it.next();
        try {
            it.remove();
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        String s = full.toString();
        for (int i = 0; i < 3; ++i) {
            CopyOnWriteArrayListTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testLastIndexOf1() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        full.add(one);
        full.add(three);
        CopyOnWriteArrayListTest.assertEquals((int)3, (int)full.lastIndexOf(one));
        CopyOnWriteArrayListTest.assertEquals((int)-1, (int)full.lastIndexOf(six));
    }

    public void testlastIndexOf2() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        full.add(one);
        full.add(three);
        CopyOnWriteArrayListTest.assertEquals((int)3, (int)full.lastIndexOf(one, 4));
        CopyOnWriteArrayListTest.assertEquals((int)-1, (int)full.lastIndexOf(three, 3));
    }

    public void testListIterator1() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        ListIterator i = full.listIterator();
        int j = 0;
        while (i.hasNext()) {
            CopyOnWriteArrayListTest.assertEquals((Object)j, i.next());
            ++j;
        }
        CopyOnWriteArrayListTest.assertEquals((int)20, (int)j);
    }

    public void testListIterator2() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        ListIterator i = full.listIterator(1);
        int j = 0;
        while (i.hasNext()) {
            CopyOnWriteArrayListTest.assertEquals((Object)(j + 1), i.next());
            ++j;
        }
        CopyOnWriteArrayListTest.assertEquals((int)2, (int)j);
    }

    public void testRemove() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertEquals((Object)2, full.remove(2));
        CopyOnWriteArrayListTest.assertEquals((int)2, (int)full.size());
    }

    public void testRemoveAll() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Vector<Integer> v = new Vector<Integer>();
        v.add(one);
        v.add(two);
        full.removeAll(v);
        CopyOnWriteArrayListTest.assertEquals((int)1, (int)full.size());
    }

    public void testSet() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        CopyOnWriteArrayListTest.assertEquals((Object)2, (Object)full.set(2, four));
        CopyOnWriteArrayListTest.assertEquals((Object)4, full.get(2));
    }

    public void testSize() {
        CopyOnWriteArrayList empty = new CopyOnWriteArrayList();
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(20);
        CopyOnWriteArrayListTest.assertEquals((int)20, (int)full.size());
        CopyOnWriteArrayListTest.assertEquals((int)0, (int)empty.size());
    }

    public void testToArray() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Object[] o = full.toArray();
        CopyOnWriteArrayListTest.assertEquals((int)3, (int)o.length);
        CopyOnWriteArrayListTest.assertEquals((Object)0, (Object)o[0]);
        CopyOnWriteArrayListTest.assertEquals((Object)1, (Object)o[1]);
        CopyOnWriteArrayListTest.assertEquals((Object)2, (Object)o[2]);
    }

    public void testToArray2() {
        CopyOnWriteArrayList full = CopyOnWriteArrayListTest.populatedArray(3);
        Integer[] i = new Integer[3];
        i = full.toArray(i);
        CopyOnWriteArrayListTest.assertEquals((int)3, (int)i.length);
        CopyOnWriteArrayListTest.assertEquals((int)0, (int)i[0]);
        CopyOnWriteArrayListTest.assertEquals((int)1, (int)i[1]);
        CopyOnWriteArrayListTest.assertEquals((int)2, (int)i[2]);
    }

    public void testSubList() {
        CopyOnWriteArrayList a = CopyOnWriteArrayListTest.populatedArray(10);
        CopyOnWriteArrayListTest.assertTrue((boolean)a.subList(1, 1).isEmpty());
        for (int j = 0; j < 9; ++j) {
            for (int i = j; i < 10; ++i) {
                List b = a.subList(j, i);
                for (int k = j; k < i; ++k) {
                    CopyOnWriteArrayListTest.assertEquals((Object)new Integer(k), b.get(k - j));
                }
            }
        }
        List<Integer> s = a.subList(2, 5);
        CopyOnWriteArrayListTest.assertEquals((int)s.size(), (int)3);
        s.set(2, m1);
        CopyOnWriteArrayListTest.assertEquals(a.get(4), (Object)m1);
        s.clear();
        CopyOnWriteArrayListTest.assertEquals((int)a.size(), (int)7);
    }

    public void testToArray_ArrayStoreException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("zfasdfsdf");
            c.add("asdadasd");
            c.toArray(new Long[5]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testGet1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.get(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGet2_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.add("asdad");
            c.get(100);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSet1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.set(-1, "qwerty");
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSet2() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.add("asdad");
            c.set(100, "qwerty");
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAdd1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add(-1, "qwerty");
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAdd2_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.add("asdasdasd");
            c.add(100, "qwerty");
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemove1_IndexOutOfBounds() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.remove(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemove2_IndexOutOfBounds() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.add("adasdasd");
            c.remove(100);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAddAll1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.addAll(-1, new LinkedList());
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAddAll2_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.add("asdasdasd");
            c.addAll(100, new LinkedList());
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListIterator1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.listIterator(-1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListIterator2_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("adasd");
            c.add("asdasdas");
            c.listIterator(100);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubList1_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.subList(-1, 100);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubList2_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList<String> c = new CopyOnWriteArrayList<String>();
            c.add("asdasd");
            c.subList(1, 100);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubList3_IndexOutOfBoundsException() {
        try {
            CopyOnWriteArrayList c = new CopyOnWriteArrayList();
            c.subList(3, 1);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSerialization() throws Exception {
        CopyOnWriteArrayList q = CopyOnWriteArrayListTest.populatedArray(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        CopyOnWriteArrayList r = (CopyOnWriteArrayList)in.readObject();
        CopyOnWriteArrayListTest.assertEquals((int)q.size(), (int)r.size());
        CopyOnWriteArrayListTest.assertTrue((boolean)q.equals(r));
        CopyOnWriteArrayListTest.assertTrue((boolean)r.equals(q));
    }
}

