/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CountDownLatchTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)CountDownLatchTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CountDownLatchTest.class);
    }

    public void testConstructor() {
        try {
            new CountDownLatch(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCount() {
        CountDownLatch l = new CountDownLatch(2);
        CountDownLatchTest.assertEquals((long)2L, (long)l.getCount());
        l.countDown();
        CountDownLatchTest.assertEquals((long)1L, (long)l.getCount());
    }

    public void testCountDown() {
        CountDownLatch l = new CountDownLatch(1);
        CountDownLatchTest.assertEquals((long)1L, (long)l.getCount());
        l.countDown();
        CountDownLatchTest.assertEquals((long)0L, (long)l.getCount());
        l.countDown();
        CountDownLatchTest.assertEquals((long)0L, (long)l.getCount());
    }

    public void testAwait() throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
                l.await();
                Assert.assertEquals((long)0L, (long)l.getCount());
            }
        });
        t.start();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)2L);
        CountDownLatchTest.delay(SHORT_DELAY_MS);
        l.countDown();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)1L);
        l.countDown();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)0L);
        t.join();
    }

    public void testTimedAwait() throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)l.await(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)2L);
        CountDownLatchTest.delay(SHORT_DELAY_MS);
        l.countDown();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)1L);
        l.countDown();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)0L);
        t.join();
    }

    public void testAwait_InterruptedException() throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(1);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
                l.await();
            }
        });
        t.start();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)1L);
        t.interrupt();
        t.join();
    }

    public void testTimedAwait_InterruptedException() throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(1);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
                l.await(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        CountDownLatchTest.delay(SHORT_DELAY_MS);
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)1L);
        t.interrupt();
        t.join();
    }

    public void testAwaitTimeout() throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(1);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
                Assert.assertFalse((boolean)l.await(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((l.getCount() > 0L ? 1 : 0) != 0);
            }
        });
        t.start();
        CountDownLatchTest.assertEquals((long)l.getCount(), (long)1L);
        t.join();
    }

    public void testToString() {
        CountDownLatch s = new CountDownLatch(2);
        String us = s.toString();
        CountDownLatchTest.assertTrue((us.indexOf("Count = 2") >= 0 ? 1 : 0) != 0);
        s.countDown();
        String s1 = s.toString();
        CountDownLatchTest.assertTrue((s1.indexOf("Count = 1") >= 0 ? 1 : 0) != 0);
        s.countDown();
        String s2 = s.toString();
        CountDownLatchTest.assertTrue((s2.indexOf("Count = 0") >= 0 ? 1 : 0) != 0);
    }
}

