/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExecutorCompletionServiceTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ExecutorCompletionServiceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ExecutorCompletionServiceTest.class);
    }

    public void testConstructorNPE() {
        try {
            ExecutorCompletionService ecs = new ExecutorCompletionService(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNPE2() {
        try {
            ExecutorService e = Executors.newCachedThreadPool();
            ExecutorCompletionService ecs = new ExecutorCompletionService(e, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitNPE() {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService ecs = new ExecutorCompletionService(e);
        try {
            Callable c = null;
            ecs.submit(c);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitNPE2() {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(e);
        try {
            Runnable r = null;
            ecs.submit(r, Boolean.TRUE);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTake() throws InterruptedException {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> ecs = new ExecutorCompletionService<String>(e);
        try {
            JSR166TestCase.StringTask c = new JSR166TestCase.StringTask();
            ecs.submit(c);
            Future f = ecs.take();
            ExecutorCompletionServiceTest.assertTrue((boolean)f.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTake2() throws InterruptedException {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> ecs = new ExecutorCompletionService<String>(e);
        try {
            JSR166TestCase.StringTask c = new JSR166TestCase.StringTask();
            Future<String> f1 = ecs.submit(c);
            Future f2 = ecs.take();
            ExecutorCompletionServiceTest.assertSame(f1, f2);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoll1() throws InterruptedException {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> ecs = new ExecutorCompletionService<String>(e);
        try {
            Future f;
            ExecutorCompletionServiceTest.assertNull(ecs.poll());
            JSR166TestCase.StringTask c = new JSR166TestCase.StringTask();
            ecs.submit(c);
            ExecutorCompletionServiceTest.delay(SHORT_DELAY_MS);
            while ((f = ecs.poll()) == null) {
            }
            ExecutorCompletionServiceTest.assertTrue((boolean)f.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoll2() throws InterruptedException {
        ExecutorService e = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> ecs = new ExecutorCompletionService<String>(e);
        try {
            ExecutorCompletionServiceTest.assertNull(ecs.poll());
            JSR166TestCase.StringTask c = new JSR166TestCase.StringTask();
            ecs.submit(c);
            Future f = ecs.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            if (f != null) {
                ExecutorCompletionServiceTest.assertTrue((boolean)f.isDone());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewTaskForCallable() throws InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(false);
        ThreadPoolExecutor e = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue(1)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> c) {
                class MyCallableFuture<V>
                extends FutureTask<V> {
                    final /* synthetic */ AtomicBoolean val$done;
                    final /* synthetic */ ExecutorCompletionServiceTest this$0;

                    MyCallableFuture(Callable<V> c) {
                        this.this$0 = var1_1;
                        this.val$done = var3_3;
                        super(c);
                    }

                    @Override
                    protected void done() {
                        this.val$done.set(true);
                    }
                }
                return new MyCallableFuture(ExecutorCompletionServiceTest.this, c, done);
            }
        };
        ExecutorCompletionService<String> ecs = new ExecutorCompletionService<String>(e);
        try {
            ExecutorCompletionServiceTest.assertNull(ecs.poll());
            JSR166TestCase.StringTask c = new JSR166TestCase.StringTask();
            Future<String> f1 = ecs.submit(c);
            ExecutorCompletionServiceTest.assertTrue((String)"submit must return MyCallableFuture", (boolean)(f1 instanceof MyCallableFuture));
            Future f2 = ecs.take();
            ExecutorCompletionServiceTest.assertSame((String)"submit and take must return same objects", f1, f2);
            ExecutorCompletionServiceTest.assertTrue((String)"completed task must have set done", (boolean)done.get());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewTaskForRunnable() throws InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(false);
        ThreadPoolExecutor e = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue(1)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable t, T r) {
                class MyRunnableFuture<V>
                extends FutureTask<V> {
                    final /* synthetic */ AtomicBoolean val$done;
                    final /* synthetic */ ExecutorCompletionServiceTest this$0;

                    MyRunnableFuture(Runnable t, V r) {
                        this.this$0 = var1_1;
                        this.val$done = var4_4;
                        super(t, r);
                    }

                    @Override
                    protected void done() {
                        this.val$done.set(true);
                    }
                }
                return new MyRunnableFuture(ExecutorCompletionServiceTest.this, t, r, done);
            }
        };
        ExecutorCompletionService ecs = new ExecutorCompletionService(e);
        try {
            ExecutorCompletionServiceTest.assertNull(ecs.poll());
            JSR166TestCase.NoOpRunnable r = new JSR166TestCase.NoOpRunnable();
            Future<Object> f1 = ecs.submit(r, null);
            ExecutorCompletionServiceTest.assertTrue((String)"submit must return MyRunnableFuture", (boolean)(f1 instanceof MyRunnableFuture));
            Future f2 = ecs.take();
            ExecutorCompletionServiceTest.assertSame((String)"submit and take must return same objects", f1, f2);
            ExecutorCompletionServiceTest.assertTrue((String)"completed task must have set done", (boolean)done.get());
        }
        finally {
            this.joinPool(e);
        }
    }
}

