/*
 * Decompiled with CFR 0.152.
 */
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExecutorsTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ExecutorsTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ExecutorsTest.class);
    }

    public void testNewCachedThreadPool1() {
        ExecutorService e = Executors.newCachedThreadPool();
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewCachedThreadPool2() {
        ExecutorService e = Executors.newCachedThreadPool(new JSR166TestCase.SimpleThreadFactory());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewCachedThreadPool3() {
        try {
            ExecutorService e = Executors.newCachedThreadPool(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNewSingleThreadExecutor1() {
        ExecutorService e = Executors.newSingleThreadExecutor();
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewSingleThreadExecutor2() {
        ExecutorService e = Executors.newSingleThreadExecutor(new JSR166TestCase.SimpleThreadFactory());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewSingleThreadExecutor3() {
        try {
            ExecutorService e = Executors.newSingleThreadExecutor(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCastNewSingleThreadExecutor() {
        ExecutorService e = Executors.newSingleThreadExecutor();
        try {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)e;
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testNewFixedThreadPool1() {
        ExecutorService e = Executors.newFixedThreadPool(2);
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewFixedThreadPool2() {
        ExecutorService e = Executors.newFixedThreadPool(2, new JSR166TestCase.SimpleThreadFactory());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testNewFixedThreadPool3() {
        try {
            ExecutorService e = Executors.newFixedThreadPool(2, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNewFixedThreadPool4() {
        try {
            ExecutorService e = Executors.newFixedThreadPool(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testunconfigurableExecutorService() {
        ExecutorService e = Executors.unconfigurableExecutorService(Executors.newFixedThreadPool(2));
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        e.execute(new JSR166TestCase.NoOpRunnable());
        this.joinPool(e);
    }

    public void testunconfigurableExecutorServiceNPE() {
        try {
            ExecutorService e = Executors.unconfigurableExecutorService(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testunconfigurableScheduledExecutorServiceNPE() {
        try {
            ScheduledExecutorService e = Executors.unconfigurableScheduledExecutorService(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewSingleThreadScheduledExecutor() throws Exception {
        ScheduledExecutorService p = Executors.newSingleThreadScheduledExecutor();
        try {
            final CountDownLatch done = new CountDownLatch(1);
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                }
            };
            ScheduledFuture<Boolean> f = p.schedule(Executors.callable(task, Boolean.TRUE), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ExecutorsTest.assertFalse((boolean)f.isDone());
            ExecutorsTest.assertTrue((boolean)done.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get());
            ExecutorsTest.assertTrue((boolean)f.isDone());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testnewScheduledThreadPool() throws Exception {
        ScheduledExecutorService p = Executors.newScheduledThreadPool(2);
        try {
            final CountDownLatch done = new CountDownLatch(1);
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                }
            };
            ScheduledFuture<Boolean> f = p.schedule(Executors.callable(task, Boolean.TRUE), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ExecutorsTest.assertFalse((boolean)f.isDone());
            ExecutorsTest.assertTrue((boolean)done.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get());
            ExecutorsTest.assertTrue((boolean)f.isDone());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testunconfigurableScheduledExecutorService() throws Exception {
        ScheduledExecutorService p = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(2));
        try {
            final CountDownLatch done = new CountDownLatch(1);
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                }
            };
            ScheduledFuture<Boolean> f = p.schedule(Executors.callable(task, Boolean.TRUE), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ExecutorsTest.assertFalse((boolean)f.isDone());
            ExecutorsTest.assertTrue((boolean)done.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ExecutorsTest.assertSame((Object)Boolean.TRUE, f.get());
            ExecutorsTest.assertTrue((boolean)f.isDone());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testTimedCallable() throws Exception {
        JSR166TestCase.CheckedInterruptedRunnable sleeper = new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.LONG_DELAY_MS);
            }
        };
        for (ExecutorService executor : new ExecutorService[]{Executors.newSingleThreadExecutor(), Executors.newCachedThreadPool(), Executors.newFixedThreadPool(2), Executors.newScheduledThreadPool(2)}) {
            try {
                Future<?> future = executor.submit(sleeper);
                try {
                    future.get(SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
                    this.shouldThrow();
                    future.cancel(true);
                }
                catch (TimeoutException success) {
                    future.cancel(true);
                    continue;
                    catch (Throwable throwable) {
                        future.cancel(true);
                        throw throwable;
                    }
                }
            }
            finally {
                this.joinPool(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultThreadFactory() throws Exception {
        final ThreadGroup egroup = Thread.currentThread().getThreadGroup();
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                try {
                    Thread current = Thread.currentThread();
                    Assert.assertTrue((!current.isDaemon() ? 1 : 0) != 0);
                    Assert.assertTrue((current.getPriority() <= 5 ? 1 : 0) != 0);
                    ThreadGroup g = current.getThreadGroup();
                    SecurityManager s = System.getSecurityManager();
                    if (s != null) {
                        Assert.assertTrue((g == s.getThreadGroup() ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue((g == egroup ? 1 : 0) != 0);
                    }
                    String name = current.getName();
                    Assert.assertTrue((boolean)name.endsWith("thread-1"));
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        };
        ExecutorService e = Executors.newSingleThreadExecutor(Executors.defaultThreadFactory());
        e.execute(r);
        try {
            e.shutdown();
        }
        catch (SecurityException ok) {
            // empty catch block
        }
        try {
            ExecutorsTest.delay(SHORT_DELAY_MS);
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testPrivilegedThreadFactory() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                final ThreadGroup egroup = Thread.currentThread().getThreadGroup();
                final ClassLoader thisccl = Thread.currentThread().getContextClassLoader();
                final AccessControlContext thisacc = AccessController.getContext();
                JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() {
                        Thread current = Thread.currentThread();
                        Assert.assertTrue((!current.isDaemon() ? 1 : 0) != 0);
                        Assert.assertTrue((current.getPriority() <= 5 ? 1 : 0) != 0);
                        ThreadGroup g = current.getThreadGroup();
                        SecurityManager s = System.getSecurityManager();
                        if (s != null) {
                            Assert.assertTrue((g == s.getThreadGroup() ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((g == egroup ? 1 : 0) != 0);
                        }
                        String name = current.getName();
                        Assert.assertTrue((boolean)name.endsWith("thread-1"));
                        Assert.assertSame((Object)thisccl, (Object)current.getContextClassLoader());
                        Assert.assertEquals((Object)thisacc, (Object)AccessController.getContext());
                    }
                };
                ExecutorService e = Executors.newSingleThreadExecutor(Executors.privilegedThreadFactory());
                e.execute(r);
                e.shutdown();
                JSR166TestCase.delay(JSR166TestCase.SHORT_DELAY_MS);
                ExecutorsTest.this.joinPool(e);
            }
        };
        this.runWithPermissions(r, new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"), new RuntimePermission("modifyThread"));
    }

    boolean haveCCLPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new RuntimePermission("setContextClassLoader"));
                sm.checkPermission(new RuntimePermission("getClassLoader"));
            }
            catch (AccessControlException e) {
                return false;
            }
        }
        return true;
    }

    void checkCCL() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
    }

    public void testCreatePrivilegedCallableUsingCCLWithNoPrivs() {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                if (System.getSecurityManager() == null) {
                    return;
                }
                try {
                    Executors.privilegedCallableUsingCurrentClassLoader(new JSR166TestCase.NoOpCallable());
                    ExecutorsTest.this.shouldThrow();
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        };
        this.runWithoutPermissions(r);
    }

    public void testprivilegedCallableUsingCCLWithPrivs() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                Executors.privilegedCallableUsingCurrentClassLoader(new JSR166TestCase.NoOpCallable()).call();
            }
        };
        this.runWithPermissions(r, new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));
    }

    public void testprivilegedCallableWithNoPrivs() throws Exception {
        Executors.privilegedCallable(new CheckCCL());
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                if (System.getSecurityManager() == null) {
                    return;
                }
                Callable<Object> task = Executors.privilegedCallable(new CheckCCL());
                try {
                    task.call();
                    ExecutorsTest.this.shouldThrow();
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        };
        this.runWithoutPermissions(r);
    }

    public void testprivilegedCallableWithPrivs() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                Executors.privilegedCallable(new CheckCCL()).call();
            }
        };
        this.runWithPermissions(r, new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));
    }

    public void testCallable1() throws Exception {
        Callable<Object> c = Executors.callable(new JSR166TestCase.NoOpRunnable());
        ExecutorsTest.assertNull((Object)c.call());
    }

    public void testCallable2() throws Exception {
        Callable<Integer> c = Executors.callable(new JSR166TestCase.NoOpRunnable(), one);
        ExecutorsTest.assertSame((Object)one, (Object)c.call());
    }

    public void testCallable3() throws Exception {
        Callable<Object> c = Executors.callable(new PrivilegedAction(){

            public Object run() {
                return JSR166TestCase.one;
            }
        });
        ExecutorsTest.assertSame((Object)one, (Object)c.call());
    }

    public void testCallable4() throws Exception {
        Callable<Object> c = Executors.callable(new PrivilegedExceptionAction(){

            public Object run() {
                return JSR166TestCase.one;
            }
        });
        ExecutorsTest.assertSame((Object)one, (Object)c.call());
    }

    public void testCallableNPE1() {
        try {
            Callable<Object> c = Executors.callable((Runnable)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCallableNPE2() {
        try {
            Callable<Integer> c = Executors.callable(null, one);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCallableNPE3() {
        try {
            Callable<Object> c = Executors.callable((PrivilegedAction)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCallableNPE4() {
        try {
            Callable<Object> c = Executors.callable((PrivilegedExceptionAction)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    class CheckCCL
    implements Callable<Object> {
        CheckCCL() {
        }

        @Override
        public Object call() {
            ExecutorsTest.this.checkCCL();
            return null;
        }
    }
}

