/*
 * Decompiled with CFR 0.152.
 */
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ForkJoinPoolTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ForkJoinPoolTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ForkJoinPoolTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultInitialState() {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            ForkJoinPoolTest.assertSame((Object)ForkJoinPool.defaultForkJoinWorkerThreadFactory, (Object)p.getFactory());
            ForkJoinPoolTest.assertFalse((boolean)p.getAsyncMode());
            ForkJoinPoolTest.assertEquals((int)0, (int)p.getActiveThreadCount());
            ForkJoinPoolTest.assertEquals((long)0L, (long)p.getStealCount());
            ForkJoinPoolTest.assertEquals((long)0L, (long)p.getQueuedTaskCount());
            ForkJoinPoolTest.assertEquals((int)0, (int)p.getQueuedSubmissionCount());
            ForkJoinPoolTest.assertFalse((boolean)p.hasQueuedSubmissions());
            ForkJoinPoolTest.assertFalse((boolean)p.isShutdown());
            ForkJoinPoolTest.assertFalse((boolean)p.isTerminating());
            ForkJoinPoolTest.assertFalse((boolean)p.isTerminated());
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testConstructor1() {
        try {
            new ForkJoinPool(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new ForkJoinPool(1, null, null, false);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetParallelism() {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            ForkJoinPoolTest.assertEquals((int)1, (int)p.getParallelism());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPoolSize() {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            ForkJoinPoolTest.assertEquals((int)0, (int)p.getActiveThreadCount());
            Future future = p.submit((Callable)new JSR166TestCase.StringTask());
            ForkJoinPoolTest.assertEquals((int)1, (int)p.getPoolSize());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetUncaughtExceptionHandler() throws InterruptedException {
        final CountDownLatch uehInvoked = new CountDownLatch(1);
        Thread.UncaughtExceptionHandler eh = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                uehInvoked.countDown();
            }
        };
        ForkJoinPool p = new ForkJoinPool(1, new FailingThreadFactory(), eh, false);
        try {
            ForkJoinPoolTest.assertSame((Object)eh, (Object)p.getUncaughtExceptionHandler());
            p.execute(new FibTask(8));
            ForkJoinPoolTest.assertTrue((boolean)uehInvoked.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        finally {
            p.shutdownNow();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testisQuiescent() throws InterruptedException {
        ForkJoinPool p = new ForkJoinPool(2);
        try {
            ForkJoinPoolTest.assertTrue((boolean)p.isQuiescent());
            p.invoke(new FibTask(20));
            ForkJoinPoolTest.assertSame((Object)ForkJoinPool.defaultForkJoinWorkerThreadFactory, (Object)p.getFactory());
            ForkJoinPoolTest.delay(SMALL_DELAY_MS);
            ForkJoinPoolTest.assertTrue((boolean)p.isQuiescent());
            ForkJoinPoolTest.assertFalse((boolean)p.getAsyncMode());
            ForkJoinPoolTest.assertEquals((int)0, (int)p.getActiveThreadCount());
            ForkJoinPoolTest.assertEquals((long)0L, (long)p.getQueuedTaskCount());
            ForkJoinPoolTest.assertEquals((int)0, (int)p.getQueuedSubmissionCount());
            ForkJoinPoolTest.assertFalse((boolean)p.hasQueuedSubmissions());
            ForkJoinPoolTest.assertFalse((boolean)p.isShutdown());
            ForkJoinPoolTest.assertFalse((boolean)p.isTerminating());
            ForkJoinPoolTest.assertFalse((boolean)p.isTerminated());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitForkJoinTask() throws Throwable {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            ForkJoinTask<Integer> f = p.submit(new FibTask(8));
            ForkJoinPoolTest.assertEquals((int)21, (int)f.get());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitAfterShutdown() {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            p.shutdown();
            ForkJoinPoolTest.assertTrue((boolean)p.isShutdown());
            try {
                ForkJoinTask<Integer> f = p.submit(new FibTask(8));
                this.shouldThrow();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockingForkJoinTask() throws Throwable {
        ForkJoinPool p = new ForkJoinPool(4);
        try {
            ReentrantLock lock = new ReentrantLock();
            ManagedLocker locker = new ManagedLocker(lock);
            LockingFibTask f = new LockingFibTask(20, locker, lock);
            p.execute(f);
            ForkJoinPoolTest.assertEquals((int)6765, (int)((Integer)f.get()));
        }
        finally {
            p.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPollSubmission() {
        CountDownLatch done = new CountDownLatch(1);
        SubFJP p = new SubFJP();
        try {
            Future a = p.submit(this.awaiter(done));
            Future b = p.submit(this.awaiter(done));
            Future c = p.submit(this.awaiter(done));
            ForkJoinTask<?> r = p.pollSubmission();
            ForkJoinPoolTest.assertTrue((r == a || r == b || r == c ? 1 : 0) != 0);
            ForkJoinPoolTest.assertFalse((boolean)r.isDone());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDrainTasksTo() {
        CountDownLatch done = new CountDownLatch(1);
        SubFJP p = new SubFJP();
        try {
            Future a = p.submit(this.awaiter(done));
            Future b = p.submit(this.awaiter(done));
            Future c = p.submit(this.awaiter(done));
            ArrayList al = new ArrayList();
            p.drainTasksTo(al);
            ForkJoinPoolTest.assertTrue((al.size() > 0 ? 1 : 0) != 0);
            for (ForkJoinTask r : al) {
                ForkJoinPoolTest.assertTrue((r == a || r == b || r == c ? 1 : 0) != 0);
                ForkJoinPoolTest.assertFalse((boolean)r.isDone());
            }
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteRunnable() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            JSR166TestCase.TrackedRunnable task = ForkJoinPoolTest.trackedRunnable(SHORT_DELAY_MS);
            ForkJoinPoolTest.assertFalse((boolean)task.isDone());
            Future<?> future = e.submit(task);
            ForkJoinPoolTest.assertNull(future.get());
            ForkJoinPoolTest.assertNull(future.get(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            ForkJoinPoolTest.assertTrue((boolean)task.isDone());
            ForkJoinPoolTest.assertTrue((boolean)future.isDone());
            ForkJoinPoolTest.assertFalse((boolean)future.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            ForkJoinPoolTest.assertSame((Object)"a test string", (Object)future.get());
            ForkJoinPoolTest.assertTrue((boolean)future.isDone());
            ForkJoinPoolTest.assertFalse((boolean)future.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            ForkJoinPoolTest.assertNull(future.get());
            ForkJoinPoolTest.assertTrue((boolean)future.isDone());
            ForkJoinPoolTest.assertFalse((boolean)future.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            Future<String> future = e.submit((Runnable)new JSR166TestCase.NoOpRunnable(), "a test string");
            ForkJoinPoolTest.assertSame((Object)"a test string", (Object)future.get());
            ForkJoinPoolTest.assertTrue((boolean)future.isDone());
            ForkJoinPoolTest.assertFalse((boolean)future.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testSubmitPrivilegedAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                ForkJoinPool e = new ForkJoinPool(1);
                Future<Object> future = e.submit(Executors.callable(new PrivilegedAction(){

                    public Object run() {
                        return "a test string";
                    }
                }));
                Assert.assertSame((Object)"a test string", (Object)future.get());
            }
        };
        this.runWithPermissions(r, new RuntimePermission("modifyThread"));
    }

    public void testSubmitPrivilegedExceptionAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                ForkJoinPool e = new ForkJoinPool(1);
                Future<Object> future = e.submit(Executors.callable(new PrivilegedExceptionAction(){

                    public Object run() {
                        return "a test string";
                    }
                }));
                Assert.assertSame((Object)"a test string", (Object)future.get());
            }
        };
        this.runWithPermissions(r, new RuntimePermission("modifyThread"));
    }

    public void testSubmitFailedPrivilegedExceptionAction() throws Exception {
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                ForkJoinPool e = new ForkJoinPool(1);
                Future<Object> future = e.submit(Executors.callable(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        throw new IndexOutOfBoundsException();
                    }
                }));
                try {
                    future.get();
                    ForkJoinPoolTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Assert.assertTrue((boolean)(success.getCause() instanceof IndexOutOfBoundsException));
                }
            }
        };
        this.runWithPermissions(r, new RuntimePermission("modifyThread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteNullRunnable() {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            Future<?> future = e.submit((Runnable)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitNullCallable() {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            Future future = e.submit((Callable)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptedSubmit() throws InterruptedException {
        final CountDownLatch submitted = new CountDownLatch(1);
        final CountDownLatch quittingTime = new CountDownLatch(1);
        final ForkJoinPool p = new ForkJoinPool(1);
        final JSR166TestCase.CheckedCallable<Void> awaiter = new JSR166TestCase.CheckedCallable<Void>(){

            @Override
            public Void realCall() throws InterruptedException {
                Assert.assertTrue((boolean)quittingTime.await(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                return null;
            }
        };
        try {
            Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

                @Override
                public void realRun() throws Exception {
                    Future future = p.submit(awaiter);
                    submitted.countDown();
                    future.get();
                }
            });
            t.start();
            ForkJoinPoolTest.assertTrue((boolean)submitted.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            t.interrupt();
            t.join();
        }
        finally {
            quittingTime.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitEE() throws Throwable {
        ForkJoinPool p = new ForkJoinPool(1);
        try {
            ((ForkJoinTask)p.submit(new Callable(){

                public Object call() {
                    int i = 5 / 0;
                    return Boolean.TRUE;
                }
            })).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinPoolTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinPoolTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny6() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ForkJoinPoolTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws InterruptedException {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            List r = e.invokeAll(new ArrayList());
            ForkJoinPoolTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws InterruptedException {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l);
        ForkJoinPoolTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinPoolTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ForkJoinPoolTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ForkJoinPoolTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinPoolTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ForkJoinPoolTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws InterruptedException {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ForkJoinPoolTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws InterruptedException {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ForkJoinPoolTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinPoolTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Throwable {
        ForkJoinPool e = new ForkJoinPool(1);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ForkJoinPoolTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ForkJoinPoolTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    static final class LockingFibTask
    extends RecursiveTask<Integer> {
        final int number;
        final ManagedLocker locker;
        final ReentrantLock lock;

        LockingFibTask(int n, ManagedLocker locker, ReentrantLock lock) {
            this.number = n;
            this.locker = locker;
            this.lock = lock;
        }

        @Override
        public Integer compute() {
            ForkJoinTask f1 = null;
            LockingFibTask f2 = null;
            this.locker.block();
            int n = this.number;
            if (n > 1) {
                f1 = new LockingFibTask(n - 1, this.locker, this.lock);
                f2 = new LockingFibTask(n - 2, this.locker, this.lock);
            }
            this.lock.unlock();
            if (n <= 1) {
                return n;
            }
            f1.fork();
            return f2.compute() + (Integer)f1.join();
        }
    }

    static final class FailingTask
    extends ForkJoinTask<Void> {
        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        protected final void setRawResult(Void mustBeNull) {
        }

        @Override
        protected final boolean exec() {
            throw new Error();
        }

        FailingTask() {
        }
    }

    static final class FibTask
    extends RecursiveTask<Integer> {
        final int number;

        FibTask(int n) {
            this.number = n;
        }

        @Override
        public Integer compute() {
            int n = this.number;
            if (n <= 1) {
                return n;
            }
            FibTask f1 = new FibTask(n - 1);
            f1.fork();
            return new FibTask(n - 2).compute() + (Integer)f1.join();
        }
    }

    static class ManagedLocker
    implements ForkJoinPool.ManagedBlocker {
        final ReentrantLock lock;
        boolean hasLock = false;

        ManagedLocker(ReentrantLock lock) {
            this.lock = lock;
        }

        @Override
        public boolean block() {
            if (!this.hasLock) {
                this.lock.lock();
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.hasLock || (this.hasLock = this.lock.tryLock());
        }
    }

    static class SubFJP
    extends ForkJoinPool {
        SubFJP() {
            super(1);
        }

        @Override
        public int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
            return super.drainTasksTo(c);
        }

        @Override
        public ForkJoinTask<?> pollSubmission() {
            return super.pollSubmission();
        }
    }

    static class FailingThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        volatile int calls = 0;

        FailingThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool p) {
            if (++this.calls > 1) {
                return null;
            }
            return new FailingFJWSubclass(p);
        }
    }

    static class FailingFJWSubclass
    extends ForkJoinWorkerThread {
        public FailingFJWSubclass(ForkJoinPool p) {
            super(p);
        }

        @Override
        protected void onStart() {
            super.onStart();
            throw new Error();
        }
    }

    static class MyHandler
    implements Thread.UncaughtExceptionHandler {
        volatile int catches = 0;

        MyHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ++this.catches;
        }
    }
}

