/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ForkJoinTaskTest
extends JSR166TestCase {
    static final int mainPoolSize = Math.max(2, Runtime.getRuntime().availableProcessors());

    public static void main(String[] args) {
        TestRunner.run((Test)ForkJoinTaskTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ForkJoinTaskTest.class);
    }

    private static ForkJoinPool mainPool() {
        return new ForkJoinPool(mainPoolSize);
    }

    private static ForkJoinPool singletonPool() {
        return new ForkJoinPool(1);
    }

    private static ForkJoinPool asyncSingletonPool() {
        return new ForkJoinPool(1, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvokeOnPool(ForkJoinPool pool, RecursiveAction a) {
        try {
            ForkJoinTaskTest.assertFalse((boolean)a.isDone());
            ForkJoinTaskTest.assertFalse((boolean)a.isCompletedNormally());
            ForkJoinTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
            ForkJoinTaskTest.assertFalse((boolean)a.isCancelled());
            ForkJoinTaskTest.assertNull((Object)a.getException());
            ForkJoinTaskTest.assertNull((Object)a.getRawResult());
            ForkJoinTaskTest.assertNull((Object)pool.invoke(a));
            ForkJoinTaskTest.assertTrue((boolean)a.isDone());
            ForkJoinTaskTest.assertTrue((boolean)a.isCompletedNormally());
            ForkJoinTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
            ForkJoinTaskTest.assertFalse((boolean)a.isCancelled());
            ForkJoinTaskTest.assertNull((Object)a.getException());
            ForkJoinTaskTest.assertNull((Object)a.getRawResult());
        }
        finally {
            this.joinPool(pool);
        }
    }

    void checkNotDone(ForkJoinTask a) {
        ForkJoinTaskTest.assertFalse((boolean)a.isDone());
        ForkJoinTaskTest.assertFalse((boolean)a.isCompletedNormally());
        ForkJoinTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
        ForkJoinTaskTest.assertFalse((boolean)a.isCancelled());
        ForkJoinTaskTest.assertNull((Object)a.getException());
        ForkJoinTaskTest.assertNull(a.getRawResult());
        try {
            a.get(0L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    <T> void checkCompletedNormally(ForkJoinTask<T> a) {
        this.checkCompletedNormally(a, null);
    }

    <T> void checkCompletedNormally(ForkJoinTask<T> a, T expected) {
        ForkJoinTaskTest.assertTrue((boolean)a.isDone());
        ForkJoinTaskTest.assertFalse((boolean)a.isCancelled());
        ForkJoinTaskTest.assertTrue((boolean)a.isCompletedNormally());
        ForkJoinTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
        ForkJoinTaskTest.assertNull((Object)a.getException());
        ForkJoinTaskTest.assertSame(expected, a.getRawResult());
        Thread.currentThread().interrupt();
        long t0 = System.nanoTime();
        ForkJoinTaskTest.assertSame(expected, a.join());
        ForkJoinTaskTest.assertTrue((this.millisElapsedSince(t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        Thread.interrupted();
        Thread.currentThread().interrupt();
        t0 = System.nanoTime();
        a.quietlyJoin();
        ForkJoinTaskTest.assertTrue((this.millisElapsedSince(t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        Thread.interrupted();
        ForkJoinTaskTest.assertFalse((boolean)a.cancel(false));
        ForkJoinTaskTest.assertFalse((boolean)a.cancel(true));
        try {
            ForkJoinTaskTest.assertSame(expected, a.get());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            ForkJoinTaskTest.assertSame(expected, a.get(5L, TimeUnit.SECONDS));
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCancelled(ForkJoinTask a) {
        ForkJoinTaskTest.assertTrue((boolean)a.isDone());
        ForkJoinTaskTest.assertTrue((boolean)a.isCancelled());
        ForkJoinTaskTest.assertFalse((boolean)a.isCompletedNormally());
        ForkJoinTaskTest.assertTrue((boolean)a.isCompletedAbnormally());
        ForkJoinTaskTest.assertTrue((boolean)(a.getException() instanceof CancellationException));
        ForkJoinTaskTest.assertNull(a.getRawResult());
        ForkJoinTaskTest.assertTrue((boolean)a.cancel(false));
        ForkJoinTaskTest.assertTrue((boolean)a.cancel(true));
        try {
            Thread.currentThread().interrupt();
            a.join();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        Thread.interrupted();
        long t0 = System.nanoTime();
        a.quietlyJoin();
        ForkJoinTaskTest.assertTrue((this.millisElapsedSince(t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        try {
            a.get();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCompletedAbnormally(ForkJoinTask a, Throwable t) {
        ForkJoinTaskTest.assertTrue((boolean)a.isDone());
        ForkJoinTaskTest.assertFalse((boolean)a.isCancelled());
        ForkJoinTaskTest.assertFalse((boolean)a.isCompletedNormally());
        ForkJoinTaskTest.assertTrue((boolean)a.isCompletedAbnormally());
        ForkJoinTaskTest.assertSame(t.getClass(), a.getException().getClass());
        ForkJoinTaskTest.assertNull(a.getRawResult());
        ForkJoinTaskTest.assertFalse((boolean)a.cancel(false));
        ForkJoinTaskTest.assertFalse((boolean)a.cancel(true));
        try {
            Thread.currentThread().interrupt();
            a.join();
            this.shouldThrow();
        }
        catch (Throwable expected) {
            ForkJoinTaskTest.assertSame(t.getClass(), expected.getClass());
        }
        Thread.interrupted();
        long t0 = System.nanoTime();
        a.quietlyJoin();
        ForkJoinTaskTest.assertTrue((this.millisElapsedSince(t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        try {
            a.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinTaskTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ForkJoinTaskTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    public void testInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertNull(f.invoke());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                f.quietlyInvoke();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.join());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkTimedGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkTimedGetNPE() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(5L, null);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testForkHelpQuiesce() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.helpQuiesce();
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)0, (int)8.getQueuedTaskCount());
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                f.quietlyInvoke();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                ForkJoinTaskTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalForkTimedGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                ForkJoinTaskTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testCancelledInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testCancelledForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testCancelledForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testCancelledForkTimedGet() throws Exception {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testCancelledForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                ForkJoinTaskTest.this.checkCancelled(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testGetPool() {
        final ForkJoinPool mainPool = ForkJoinTaskTest.mainPool();
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertSame((Object)mainPool, (Object)20.getPool());
            }
        };
        this.testInvokeOnPool(mainPool, a);
    }

    public void testGetPool2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertNull((Object)21.getPool());
            }
        };
        ForkJoinTaskTest.assertNull(a.invoke());
    }

    public void testInForkJoinPool() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertTrue((boolean)22.inForkJoinPool());
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInForkJoinPool2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertFalse((boolean)23.inForkJoinPool());
            }
        };
        ForkJoinTaskTest.assertNull(a.invoke());
    }

    public void testSetRawResult() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                this.setRawResult(null);
                Assert.assertNull((Object)this.getRawResult());
            }
        };
        ForkJoinTaskTest.assertNull(a.invoke());
    }

    public void testCompleteExceptionally() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                f.completeExceptionally(new FJException());
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInvokeAll2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                26.invokeAll(f, g);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInvokeAll1() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                27.invokeAll(f);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.number);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInvokeAll3() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                28.invokeAll(f, g, h);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                Assert.assertEquals((int)13, (int)h.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
                ForkJoinTaskTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                HashSet<AsyncFib> set = new HashSet<AsyncFib>();
                set.add(f);
                set.add(g);
                set.add(h);
                29.invokeAll(set);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                Assert.assertEquals((int)13, (int)h.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
                ForkJoinTaskTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testInvokeAllNPE() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                Object h = null;
                try {
                    30.invokeAll(f, g, h);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                FailingAsyncFib g = new FailingAsyncFib(9);
                try {
                    31.invokeAll(f, g);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll1() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib g = new FailingAsyncFib(9);
                try {
                    32.invokeAll(g);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll3() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                FailingAsyncFib g = new FailingAsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                try {
                    33.invokeAll(f, g, h);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testAbnormalInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                HashSet<BinaryAsyncAction> set = new HashSet<BinaryAsyncAction>();
                set.add(f);
                set.add(g);
                set.add(h);
                try {
                    34.invokeAll(set);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.mainPool(), a);
    }

    public void testTryUnfork() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((boolean)f.tryUnfork());
                35.helpQuiesce();
                ForkJoinTaskTest.this.checkNotDone(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testGetSurplusQueuedTaskCount() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib h = new AsyncFib(7);
                Assert.assertSame((Object)h, h.fork());
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((36.getSurplusQueuedTaskCount() > 0 ? 1 : 0) != 0);
                36.helpQuiesce();
                Assert.assertEquals((int)0, (int)36.getSurplusQueuedTaskCount());
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
                ForkJoinTaskTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testPeekNextLocalTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 37.peekNextLocalTask());
                Assert.assertNull(f.join());
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                37.helpQuiesce();
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testPollNextLocalTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 38.pollNextLocalTask());
                38.helpQuiesce();
                ForkJoinTaskTest.this.checkNotDone(f);
                Assert.assertEquals((int)34, (int)g.number);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testPollTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 39.pollTask());
                39.helpQuiesce();
                ForkJoinTaskTest.this.checkNotDone(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testPeekNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 40.peekNextLocalTask());
                Assert.assertNull(f.join());
                40.helpQuiesce();
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)34, (int)g.number);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.asyncSingletonPool(), a);
    }

    public void testPollNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 41.pollNextLocalTask());
                41.helpQuiesce();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkNotDone(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.asyncSingletonPool(), a);
    }

    public void testPollTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib g = new AsyncFib(9);
                Assert.assertSame((Object)g, g.fork());
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 42.pollTask());
                42.helpQuiesce();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkNotDone(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.asyncSingletonPool(), a);
    }

    public void testInvokeSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertNull(f.invoke());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testQuietlyInvokeSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                f.quietlyInvoke();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.join());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkGetSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkTimedGetSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkTimedGetNPESingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(5L, null);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkQuietlyJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testForkHelpQuiesceSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.helpQuiesce();
                Assert.assertEquals((int)0, (int)50.getQueuedTaskCount());
                Assert.assertEquals((int)21, (int)f.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalInvokeSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalQuietlyInvokeSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                f.quietlyInvoke();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                ForkJoinTaskTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalForkJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalForkGetSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalForkTimedGetSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalForkQuietlyJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                ForkJoinTaskTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCancelledInvokeSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCancelledForkJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCancelledForkGetSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCancelledForkTimedGetSingleton() throws Exception {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    ForkJoinTaskTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCancelledForkQuietlyJoinSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                ForkJoinTaskTest.this.checkCancelled(f);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testCompleteExceptionallySingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                f.completeExceptionally(new FJException());
                try {
                    f.invoke();
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testInvokeAll2Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                63.invokeAll(f, g);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testInvokeAll1Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                64.invokeAll(f);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.number);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testInvokeAll3Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                65.invokeAll(f, g, h);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                Assert.assertEquals((int)13, (int)h.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
                ForkJoinTaskTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testInvokeAllCollectionSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                HashSet<AsyncFib> set = new HashSet<AsyncFib>();
                set.add(f);
                set.add(g);
                set.add(h);
                66.invokeAll(set);
                Assert.assertEquals((int)21, (int)f.number);
                Assert.assertEquals((int)34, (int)g.number);
                Assert.assertEquals((int)13, (int)h.number);
                ForkJoinTaskTest.this.checkCompletedNormally(f);
                ForkJoinTaskTest.this.checkCompletedNormally(g);
                ForkJoinTaskTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testInvokeAllNPESingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                Object h = null;
                try {
                    67.invokeAll(f, g, h);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalInvokeAll2Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                FailingAsyncFib g = new FailingAsyncFib(9);
                try {
                    68.invokeAll(f, g);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalInvokeAll1Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib g = new FailingAsyncFib(9);
                try {
                    69.invokeAll(g);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalInvokeAll3Singleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                AsyncFib f = new AsyncFib(8);
                FailingAsyncFib g = new FailingAsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                try {
                    70.invokeAll(f, g, h);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    public void testAbnormalInvokeAllCollectionSingleton() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingAsyncFib f = new FailingAsyncFib(8);
                AsyncFib g = new AsyncFib(9);
                AsyncFib h = new AsyncFib(7);
                HashSet<BinaryAsyncAction> set = new HashSet<BinaryAsyncAction>();
                set.add(f);
                set.add(g);
                set.add(h);
                try {
                    71.invokeAll(set);
                    ForkJoinTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    ForkJoinTaskTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(ForkJoinTaskTest.singletonPool(), a);
    }

    static final class FailingAsyncFib
    extends BinaryAsyncAction {
        int number;

        public FailingAsyncFib(int n) {
            this.number = n;
        }

        @Override
        public final boolean exec() {
            FailingAsyncFib f = this;
            int n = f.number;
            if (n > 1) {
                while (n > 1) {
                    FailingAsyncFib p = f;
                    FailingAsyncFib r = new FailingAsyncFib(n - 2);
                    f = new FailingAsyncFib(--n);
                    p.linkSubtasks(r, f);
                    r.fork();
                }
                f.number = n;
            }
            f.complete();
            return false;
        }

        @Override
        protected void onComplete(BinaryAsyncAction x, BinaryAsyncAction y) {
            this.completeExceptionally(new FJException());
        }
    }

    static final class AsyncFib
    extends BinaryAsyncAction {
        int number;

        public AsyncFib(int n) {
            this.number = n;
        }

        @Override
        public final boolean exec() {
            AsyncFib f = this;
            int n = f.number;
            if (n > 1) {
                while (n > 1) {
                    AsyncFib p = f;
                    AsyncFib r = new AsyncFib(n - 2);
                    f = new AsyncFib(--n);
                    p.linkSubtasks(r, f);
                    r.fork();
                }
                f.number = n;
            }
            f.complete();
            return false;
        }

        @Override
        protected void onComplete(BinaryAsyncAction x, BinaryAsyncAction y) {
            this.number = ((AsyncFib)x).number + ((AsyncFib)y).number;
        }
    }

    static abstract class BinaryAsyncAction
    extends ForkJoinTask<Void> {
        private volatile int controlState;
        static final AtomicIntegerFieldUpdater<BinaryAsyncAction> controlStateUpdater = AtomicIntegerFieldUpdater.newUpdater(BinaryAsyncAction.class, "controlState");
        private BinaryAsyncAction parent;
        private BinaryAsyncAction sibling;

        protected BinaryAsyncAction() {
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        protected final void setRawResult(Void mustBeNull) {
        }

        public final void linkSubtasks(BinaryAsyncAction x, BinaryAsyncAction y) {
            x.parent = y.parent = this;
            x.sibling = y;
            y.sibling = x;
        }

        protected void onComplete(BinaryAsyncAction x, BinaryAsyncAction y) {
        }

        protected boolean onException() {
            return true;
        }

        public void linkAndForkSubtasks(BinaryAsyncAction x, BinaryAsyncAction y) {
            this.linkSubtasks(x, y);
            y.fork();
            x.fork();
        }

        private void completeThis() {
            super.complete(null);
        }

        private void completeThisExceptionally(Throwable ex) {
            super.completeExceptionally(ex);
        }

        public final void complete() {
            BinaryAsyncAction a = this;
            while (true) {
                BinaryAsyncAction s = a.sibling;
                BinaryAsyncAction p = a.parent;
                a.sibling = null;
                a.parent = null;
                a.completeThis();
                if (p == null || p.compareAndSetControlState(0, 1)) break;
                try {
                    p.onComplete(a, s);
                }
                catch (Throwable rex) {
                    p.completeExceptionally(rex);
                    return;
                }
                a = p;
            }
        }

        @Override
        public final void completeExceptionally(Throwable ex) {
            BinaryAsyncAction a = this;
            while (!a.isCompletedAbnormally()) {
                a.completeThisExceptionally(ex);
                BinaryAsyncAction s = a.sibling;
                if (s != null) {
                    s.cancel(false);
                }
                if (a.onException() && (a = a.parent) != null) continue;
                break;
            }
        }

        public final BinaryAsyncAction getParent() {
            return this.parent;
        }

        public BinaryAsyncAction getSibling() {
            return this.sibling;
        }

        @Override
        public void reinitialize() {
            this.sibling = null;
            this.parent = null;
            super.reinitialize();
        }

        protected final int getControlState() {
            return this.controlState;
        }

        protected final boolean compareAndSetControlState(int expect, int update) {
            return controlStateUpdater.compareAndSet(this, expect, update);
        }

        protected final void setControlState(int value) {
            this.controlState = value;
        }

        protected final void incrementControlState() {
            controlStateUpdater.incrementAndGet(this);
        }

        protected final void decrementControlState() {
            controlStateUpdater.decrementAndGet(this);
        }
    }

    public static final class FJException
    extends RuntimeException {
        FJException() {
        }
    }
}

